/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractParameterToolTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    protected void validate(ParameterTool parameter) {
        ClosureCleaner.ensureSerializable((Object)parameter);
        this.validatePrivate(parameter);
        ParameterTool copy = null;
        try {
            byte[] b = InstantiationUtil.serializeObject((Object)parameter);
            copy = (ParameterTool)InstantiationUtil.deserializeObject((byte[])b, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.validatePrivate(copy);
    }

    private void validatePrivate(ParameterTool parameter) {
        Assert.assertEquals((Object)"myInput", (Object)parameter.getRequired("input"));
        Assert.assertEquals((Object)"myDefaultValue", (Object)parameter.get("output", "myDefaultValue"));
        Assert.assertEquals(null, (Object)parameter.get("whatever"));
        Assert.assertEquals((long)15L, (long)parameter.getLong("expectedCount", -1L));
        Assert.assertTrue((boolean)parameter.getBoolean("thisIsUseful", true));
        Assert.assertEquals((long)42L, (long)parameter.getByte("myDefaultByte", (byte)42));
        Assert.assertEquals((long)42L, (long)parameter.getShort("myDefaultShort", (short)42));
        Configuration config = parameter.getConfiguration();
        Assert.assertEquals((long)15L, (long)config.getLong("expectedCount", -1L));
        Properties props = parameter.getProperties();
        Assert.assertEquals((Object)"myInput", (Object)props.getProperty("input"));
        props = null;
        try {
            String pathToFile = this.tmp.newFile().getAbsolutePath();
            parameter.createPropertiesFile(pathToFile);
            Properties defaultProps = new Properties();
            try (FileInputStream fis = new FileInputStream(pathToFile);){
                defaultProps.load(fis);
            }
            Assert.assertEquals((Object)"myDefaultValue", (Object)defaultProps.get("output"));
            Assert.assertEquals((Object)"-1", (Object)defaultProps.get("expectedCount"));
            Assert.assertTrue((boolean)defaultProps.containsKey("input"));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

