/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class LongSummaryAggregatorTest {
    @Test
    public void testIsNan() throws Exception {
        LongSummaryAggregator ag = new LongSummaryAggregator();
        Assert.assertFalse((boolean)ag.isNan(Long.valueOf(-1L)));
        Assert.assertFalse((boolean)ag.isNan(Long.valueOf(0L)));
        Assert.assertFalse((boolean)ag.isNan(Long.valueOf(23L)));
        Assert.assertFalse((boolean)ag.isNan(Long.valueOf(Long.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(Long.valueOf(Long.MIN_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(null));
    }

    @Test
    public void testIsInfinite() throws Exception {
        LongSummaryAggregator ag = new LongSummaryAggregator();
        Assert.assertFalse((boolean)ag.isInfinite(Long.valueOf(-1L)));
        Assert.assertFalse((boolean)ag.isInfinite(Long.valueOf(0L)));
        Assert.assertFalse((boolean)ag.isInfinite(Long.valueOf(23L)));
        Assert.assertFalse((boolean)ag.isInfinite(Long.valueOf(Long.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(Long.valueOf(Long.MIN_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(null));
    }

    @Test
    public void testMean() throws Exception {
        Assert.assertEquals((double)50.0, (double)this.summarize(0L, 100L).getMean(), (double)0.0);
        Assert.assertEquals((double)33.333333, (double)this.summarize(0L, 0L, 100L).getMean(), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)this.summarize(0L, 0L, 100L, 100L).getMean(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)this.summarize(0L, 100L, null).getMean(), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Long[0]).getMean());
    }

    @Test
    public void testSum() throws Exception {
        Assert.assertEquals((long)100L, (long)((Long)this.summarize(0L, 100L).getSum()));
        Assert.assertEquals((long)15L, (long)((Long)this.summarize(1L, 2L, 3L, 4L, 5L).getSum()));
        Assert.assertEquals((long)0L, (long)((Long)this.summarize(-100L, 0L, 100L, null).getSum()));
        Assert.assertEquals((long)90L, (long)((Long)this.summarize(-10L, 100L, null).getSum()));
        Assert.assertNull((Object)this.summarize(new Long[0]).getSum());
    }

    @Test
    public void testMax() throws Exception {
        Assert.assertEquals((long)1001L, (long)((Long)this.summarize(-1000L, 0L, 1L, 50L, 999L, 1001L).getMax()));
        Assert.assertEquals((long)11L, (long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, 10L, 2L, 3L, 5L, 0L, 11L, -2L, 3L).getMax()));
        Assert.assertEquals((long)11L, (long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, null, 10L, 2L, 3L, 5L, null, 0L, 11L, -2L, 3L).getMax()));
        Assert.assertNull((Object)this.summarize(new Long[0]).getMax());
    }

    @Test
    public void testMin() throws Exception {
        Assert.assertEquals((long)-1000L, (long)((Long)this.summarize(-1000L, 0L, 1L, 50L, 999L, 1001L).getMin()));
        Assert.assertEquals((long)-2L, (long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, 10L, 2L, 3L, 5L, 0L, 11L, -2L, 3L).getMin()));
        Assert.assertEquals((long)-2L, (long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, null, 10L, 2L, 3L, 5L, null, 0L, 11L, -2L, 3L).getMin()));
        Assert.assertNull((Object)this.summarize(new Long[0]).getMin());
    }

    protected NumericColumnSummary<Long> summarize(Long ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Long, NumericColumnSummary<Long>, LongSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Long> result1, NumericColumnSummary<Long> result2) {
                Assert.assertEquals((long)result1.getTotalCount(), (long)result2.getTotalCount());
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getMissingCount(), (long)result2.getMissingCount());
                Assert.assertEquals((long)result1.getNonMissingCount(), (long)result2.getNonMissingCount());
                Assert.assertEquals((long)result1.getInfinityCount(), (long)result2.getInfinityCount());
                Assert.assertEquals((long)result1.getNanCount(), (long)result2.getNanCount());
                Assert.assertEquals((Object)result1.containsNull(), (Object)result2.containsNull());
                Assert.assertEquals((Object)result1.containsNonNull(), (Object)result2.containsNonNull());
                Assert.assertEquals((long)((Long)result1.getMin()), (long)((Long)result2.getMin()));
                Assert.assertEquals((long)((Long)result1.getMax()), (long)((Long)result2.getMax()));
                Assert.assertEquals((long)((Long)result1.getSum()), (long)((Long)result2.getSum()));
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(values);
    }
}

