/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.BooleanSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class BooleanSummaryAggregatorTest {
    @Test
    public void testMixedGroup() {
        BooleanColumnSummary summary = this.summarize(true, false, null, true, true, true, false, null, true, false, true);
        Assert.assertEquals((long)11L, (long)summary.getTotalCount());
        Assert.assertEquals((long)2L, (long)summary.getNullCount());
        Assert.assertEquals((long)9L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)6L, (long)summary.getTrueCount());
        Assert.assertEquals((long)3L, (long)summary.getFalseCount());
    }

    @Test
    public void testAllNullBooleans() {
        BooleanColumnSummary summary = this.summarize(null, null, null, null);
        Assert.assertEquals((long)4L, (long)summary.getTotalCount());
        Assert.assertEquals((long)4L, (long)summary.getNullCount());
        Assert.assertEquals((long)0L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)0L, (long)summary.getTrueCount());
        Assert.assertEquals((long)0L, (long)summary.getFalseCount());
    }

    @Test
    public void testAllTrue() {
        BooleanColumnSummary summary = this.summarize(true, true, true, true, true, true);
        Assert.assertEquals((long)6L, (long)summary.getTotalCount());
        Assert.assertEquals((long)0L, (long)summary.getNullCount());
        Assert.assertEquals((long)6L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)6L, (long)summary.getTrueCount());
        Assert.assertEquals((long)0L, (long)summary.getFalseCount());
    }

    @Test
    public void testAllFalse() {
        BooleanColumnSummary summary = this.summarize(false, false, false);
        Assert.assertEquals((long)3L, (long)summary.getTotalCount());
        Assert.assertEquals((long)0L, (long)summary.getNullCount());
        Assert.assertEquals((long)3L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)0L, (long)summary.getTrueCount());
        Assert.assertEquals((long)3L, (long)summary.getFalseCount());
    }

    protected BooleanColumnSummary summarize(Boolean ... values) {
        return (BooleanColumnSummary)new AggregateCombineHarness<Boolean, BooleanColumnSummary, BooleanSummaryAggregator>(){

            @Override
            protected void compareResults(BooleanColumnSummary result1, BooleanColumnSummary result2) {
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getNonNullCount(), (long)result2.getNonNullCount());
                Assert.assertEquals((long)result1.getTrueCount(), (long)result2.getTrueCount());
                Assert.assertEquals((long)result1.getFalseCount(), (long)result2.getFalseCount());
            }
        }.summarize(values);
    }
}

