/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.sca.UdfAnalyzerTest;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.util.Collector;
import org.junit.Test;

public class UdfAnalyzerExamplesTest {
    @Test
    public void testEnumTrianglesBasicExamplesTriadBuilder() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, TriadBuilder.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, Integer, Integer>>(){}), new String[]{"0"});
    }

    @Test
    public void testEnumTrianglesBasicExamplesTupleEdgeConverter() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, TupleEdgeConverter.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}));
    }

    @Test
    public void testEnumTrianglesOptExamplesEdgeDuplicator() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(FlatMapFunction.class, EdgeDuplicator.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}));
    }

    @Test
    public void testEnumTrianglesOptExamplesDegreeCounter() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, DegreeCounter.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, Integer>>(){}), new String[]{"0"});
    }

    @Test
    public void testKMeansExamplesCentroidAccumulator() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(ReduceFunction.class, CentroidAccumulator.class, TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, Point, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, Point, Long>>(){}), new String[]{"0"});
    }

    @Test
    public void testKMeansExamplesCentroidAverager() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, CentroidAverager.class, TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, Point, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Centroid>(){}));
    }

    @Test
    public void testConnectedComponentsExamplesUndirectEdge() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(FlatMapFunction.class, UndirectEdge.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}));
    }

    @Test
    public void testConnectedComponentsExamplesComponentIdFilter() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInput(FlatJoinFunction.class, ComponentIdFilter.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}));
    }

    @Test
    public void testConnectedComponentsExamplesDuplicateValue() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, DuplicateValue.class, Types.LONG, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}));
    }

    @Test
    public void testConnectedComponentsExamplesNeighborWithComponentIDJoin() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInput(JoinFunction.class, NeighborWithComponentIDJoin.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}));
    }

    @Test
    public void testWebLogAnalysisExamplesAntiJoinVisits() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInputWithKeys(CoGroupFunction.class, AntiJoinVisits.class, TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, String, Integer>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple1<String>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, String, Integer>>(){}), new String[]{"1"}, new String[]{"0"});
    }

    @Test
    public void testPageRankBasicExamplesBuildOutgoingEdgeList() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, BuildOutgoingEdgeList.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple2<Long, Long[]>>(){}), new String[]{"0"});
    }

    @Test
    public void testLogisticRegressionExamplesSumGradient() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(ReduceFunction.class, SumGradient.class, TypeInformation.of((TypeHint)new TypeHint<Tuple1<Double>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple1<Double>>(){}), new String[]{"0"});
    }

    @Test
    public void testLogisticRegressionExamplesPointParser() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, PointParser.class, Types.STRING, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, double[]>>(){}));
    }

    @Test
    public void testCanopyExamplesMassageBOW() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, PointParser.class, Types.STRING, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, String>>(){}));
    }

    @Test
    public void testCanopyExamplesDocumentReducer() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, DocumentReducer.class, TypeInformation.of((TypeHint)new TypeHint<Tuple2<Integer, String>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple5<Integer, Boolean, Boolean, String, String>>(){}), new String[]{"0"});
    }

    @Test
    public void testCanopyExamplesMapToCenter() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, MapToCenter.class, TypeInformation.of((TypeHint)new TypeHint<Tuple5<Integer, Boolean, Boolean, String, String>>(){}), TypeInformation.of((TypeHint)new TypeHint<Tuple5<Integer, Boolean, Boolean, String, String>>(){}));
    }

    @Test
    public void testKMeansppExamplesRecordToDocConverter() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, RecordToDocConverter.class, TypeInformation.of((TypeHint)new TypeHint<Tuple3<Integer, Integer, Double>>(){}), TypeInformation.of((TypeHint)new TypeHint<DocumentWithFreq>(){}), new String[]{"0"});
    }

    @FunctionAnnotation.ForwardedFields(value={"0->id"})
    private static final class RecordToDocConverter
    implements GroupReduceFunction<Tuple3<Integer, Integer, Double>, DocumentWithFreq> {
        private static final long serialVersionUID = -8476366121490468956L;

        private RecordToDocConverter() {
        }

        public void reduce(Iterable<Tuple3<Integer, Integer, Double>> values, Collector<DocumentWithFreq> out) throws Exception {
            Iterator<Tuple3<Integer, Integer, Double>> it = values.iterator();
            if (it.hasNext()) {
                Tuple3<Integer, Integer, Double> elem = it.next();
                DocumentWithFreq doc = new DocumentWithFreq((Integer)elem.f0);
                doc.wordFreq.put(((Integer)elem.f1).toString(), (Double)elem.f2);
                while (it.hasNext()) {
                    elem = it.next();
                    doc.wordFreq.put(((Integer)elem.f1).toString(), (Double)elem.f2);
                }
                out.collect((Object)doc);
            }
        }
    }

    public static class DocumentWithFreq
    implements Serializable {
        private static final long serialVersionUID = -8646398807053061675L;
        public Map<String, Double> wordFreq = new HashMap<String, Double>();
        public Integer id;

        public DocumentWithFreq() {
            this.id = -1;
        }

        public DocumentWithFreq(Integer id) {
            this.id = id;
        }

        public String toString() {
            return Integer.toString(this.id);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;4"})
    private static class MapToCenter
    implements MapFunction<Document, Document> {
        private Document center;

        private MapToCenter() {
        }

        public Document map(Document value) throws Exception {
            if (this.center != null) {
                float similarity = 42.0f;
                boolean isEqual = ((Integer)value.f0).equals(this.center.f0);
                value.f1 = isEqual;
                value.f2 = isEqual;
                if (!((String)value.f3).contains(((Integer)this.center.f0).toString() + ";") && isEqual) {
                    value.f3 = value.f3 + ((Integer)this.center.f0).toString() + ";";
                }
            }
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class DocumentReducer
    implements GroupReduceFunction<Tuple2<Integer, String>, Document> {
        private DocumentReducer() {
        }

        public void reduce(Iterable<Tuple2<Integer, String>> values, Collector<Document> out) throws Exception {
            Iterator<Tuple2<Integer, String>> it = values.iterator();
            Tuple2<Integer, String> first = it.next();
            Integer docId = (Integer)first.f0;
            StringBuilder builder = new StringBuilder((String)first.f1);
            while (it.hasNext()) {
                builder.append("-").append((String)it.next().f1);
            }
            out.collect((Object)new Document(docId, false, false, "", builder.toString()));
        }
    }

    private static class MessageBOW
    implements FlatMapFunction<String, Tuple2<Integer, String>> {
        private MessageBOW() {
        }

        public void flatMap(String value, Collector<Tuple2<Integer, String>> out) throws Exception {
            String[] splits = value.split(" ");
            if (splits.length < 2) {
                return;
            }
            out.collect((Object)new Tuple2((Object)Integer.valueOf(splits[0]), (Object)splits[1]));
        }
    }

    private static class Document
    extends Tuple5<Integer, Boolean, Boolean, String, String> {
        public Document() {
        }

        public Document(Integer docId, Boolean isCenter, Boolean isInSomeT2, String canopyCenters, String words) {
            super((Object)docId, (Object)isCenter, (Object)isInSomeT2, (Object)canopyCenters, (Object)words);
        }

        public Document(Integer docId) {
            super((Object)docId, null, null, null, null);
        }
    }

    private static class PointParser
    implements MapFunction<String, PointWithLabel> {
        private PointParser() {
        }

        public PointWithLabel map(String value) throws Exception {
            PointWithLabel p = new PointWithLabel();
            String[] split = value.split(",");
            double[] features = new double[42];
            int a = 0;
            for (int i = 0; i < split.length; ++i) {
                if (i == 41) {
                    p.setLabel(Integer.valueOf(split[i].trim().substring(0, 1)));
                    continue;
                }
                if (a >= 42 || split[i].trim().isEmpty()) continue;
                features[a++] = Double.parseDouble(split[i].trim());
            }
            p.setFeatures(features);
            return p;
        }
    }

    private static class SumGradient
    implements ReduceFunction<Gradient> {
        private SumGradient() {
        }

        public Gradient reduce(Gradient gradient1, Gradient gradient2) throws Exception {
            for (int i = 0; i < gradient1.getComponents().length; ++i) {
                gradient1.setComponent(i, gradient1.getComponent(i) + gradient2.getComponent(i));
            }
            return gradient1;
        }
    }

    private static class PointWithLabel
    extends Tuple2<Integer, double[]> {
        private PointWithLabel() {
        }

        public double[] getFeatures() {
            return (double[])this.f1;
        }

        public double getFeature(int i) {
            return ((double[])this.f1)[i];
        }

        public void setFeatures(double[] features) {
            this.f1 = features;
        }

        public Integer getLabel() {
            return (Integer)this.f0;
        }

        public void setLabel(Integer label) {
            this.f0 = label;
        }
    }

    private static class Gradient
    extends Vector {
        public Gradient() {
        }

        public Gradient(int size) {
            super(size);
        }
    }

    private static class Vector
    extends Tuple1<double[]> {
        public Vector() {
        }

        public Vector(int size) {
            double[] components = new double[size];
            for (int i = 0; i < size; ++i) {
                components[i] = 0.0;
            }
            this.setComponents(components);
        }

        public double[] getComponents() {
            return (double[])this.f0;
        }

        public double getComponent(int i) {
            return ((double[])this.f0)[i];
        }

        public void setComponent(int i, double value) {
            ((double[])this.f0)[i] = value;
        }

        public void setComponents(double[] components) {
            this.f0 = components;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class BuildOutgoingEdgeList
    implements GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long[]>> {
        private final ArrayList<Long> neighbors = new ArrayList();

        private BuildOutgoingEdgeList() {
        }

        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long[]>> out) {
            this.neighbors.clear();
            Long id = 0L;
            for (Tuple2<Long, Long> n : values) {
                id = (Long)n.f0;
                this.neighbors.add((Long)n.f1);
            }
            out.collect((Object)new Tuple2((Object)id, (Object)this.neighbors.toArray(new Long[this.neighbors.size()])));
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f1"})
    private static class AntiJoinVisits
    implements CoGroupFunction<Tuple3<Integer, String, Integer>, Tuple1<String>, Tuple3<Integer, String, Integer>> {
        private AntiJoinVisits() {
        }

        public void coGroup(Iterable<Tuple3<Integer, String, Integer>> ranks, Iterable<Tuple1<String>> visits, Collector<Tuple3<Integer, String, Integer>> out) {
            if (!visits.iterator().hasNext()) {
                for (Tuple3<Integer, String, Integer> next : ranks) {
                    out.collect(next);
                }
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f1->f1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f0"})
    private static final class NeighborWithComponentIDJoin
    implements JoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private NeighborWithComponentIDJoin() {
        }

        public Tuple2<Long, Long> join(Tuple2<Long, Long> vertexWithComponent, Tuple2<Long, Long> edge) {
            return new Tuple2(edge.f1, vertexWithComponent.f1);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0;*->f1"})
    private static final class DuplicateValue<T>
    implements MapFunction<T, Tuple2<T, T>> {
        private DuplicateValue() {
        }

        public Tuple2<T, T> map(T vertex) {
            return new Tuple2(vertex, vertex);
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*"})
    private static final class ComponentIdFilter
    implements FlatJoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private ComponentIdFilter() {
        }

        public void join(Tuple2<Long, Long> candidate, Tuple2<Long, Long> old, Collector<Tuple2<Long, Long>> out) {
            if ((Long)candidate.f1 < (Long)old.f1) {
                out.collect(candidate);
            }
        }
    }

    private static final class UndirectEdge
    implements FlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        Tuple2<Long, Long> invertedEdge = new Tuple2();

        private UndirectEdge() {
        }

        public void flatMap(Tuple2<Long, Long> edge, Collector<Tuple2<Long, Long>> out) {
            this.invertedEdge.f0 = edge.f1;
            this.invertedEdge.f1 = edge.f0;
            out.collect(edge);
            out.collect(this.invertedEdge);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->id"})
    private static final class CentroidAverager
    implements MapFunction<Tuple3<Integer, Point, Long>, Centroid> {
        private CentroidAverager() {
        }

        public Centroid map(Tuple3<Integer, Point, Long> value) {
            return new Centroid((Integer)value.f0, ((Point)value.f1).div((Long)value.f2));
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static final class CentroidAccumulator
    implements ReduceFunction<Tuple3<Integer, Point, Long>> {
        private CentroidAccumulator() {
        }

        public Tuple3<Integer, Point, Long> reduce(Tuple3<Integer, Point, Long> val1, Tuple3<Integer, Point, Long> val2) {
            return new Tuple3(val1.f0, (Object)((Point)val1.f1).add((Point)val2.f1), (Object)((Long)val1.f2 + (Long)val2.f2));
        }
    }

    public static class Centroid
    extends Point {
        public int id;

        public Centroid() {
        }

        public Centroid(int id, double x, double y) {
            super(x, y);
            this.id = id;
        }

        public Centroid(int id, Point p) {
            super(p.x, p.y);
            this.id = id;
        }

        @Override
        public String toString() {
            return this.id + " " + super.toString();
        }
    }

    public static class Point
    implements Serializable {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point add(Point other) {
            this.x += other.x;
            this.y += other.y;
            return this;
        }

        public Point div(long val) {
            this.x /= (double)val;
            this.y /= (double)val;
            return this;
        }

        public void clear() {
            this.y = 0.0;
            this.x = 0.0;
        }

        public String toString() {
            return this.x + " " + this.y;
        }
    }

    private static class DegreeCounter
    implements GroupReduceFunction<Edge, Edge> {
        final ArrayList<Integer> otherVertices = new ArrayList();
        final Edge outputEdge = new Edge();

        private DegreeCounter() {
        }

        public void reduce(Iterable<Edge> edgesIter, Collector<Edge> out) {
            Iterator<Edge> edges = edgesIter.iterator();
            this.otherVertices.clear();
            Edge edge = edges.next();
            Integer groupVertex = edge.getFirstVertex();
            this.otherVertices.add(edge.getSecondVertex());
            while (edges.hasNext()) {
                edge = edges.next();
                Integer otherVertex = edge.getSecondVertex();
                if (this.otherVertices.contains(otherVertex) || otherVertex.equals(groupVertex)) continue;
                this.otherVertices.add(otherVertex);
            }
            for (Integer otherVertex : this.otherVertices) {
                if (groupVertex < otherVertex) {
                    this.outputEdge.setFirstVertex(groupVertex);
                    this.outputEdge.setSecondVertex(otherVertex);
                } else {
                    this.outputEdge.setFirstVertex(otherVertex);
                    this.outputEdge.setSecondVertex(groupVertex);
                }
                out.collect((Object)this.outputEdge);
            }
        }
    }

    private static class EdgeDuplicator
    implements FlatMapFunction<Edge, Edge> {
        private EdgeDuplicator() {
        }

        public void flatMap(Edge edge, Collector<Edge> out) throws Exception {
            out.collect((Object)edge);
            edge.flipVertices();
            out.collect((Object)edge);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;1"})
    private static class TupleEdgeConverter
    implements MapFunction<Tuple2<Integer, Integer>, Edge> {
        private final Edge outEdge = new Edge();

        private TupleEdgeConverter() {
        }

        public Edge map(Tuple2<Integer, Integer> t) throws Exception {
            this.outEdge.copyVerticesFromTuple2(t);
            return this.outEdge;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    private static class TriadBuilder
    implements GroupReduceFunction<Edge, Triad> {
        private final List<Integer> vertices = new ArrayList<Integer>();
        private final Triad outTriad = new Triad();

        private TriadBuilder() {
        }

        public void reduce(Iterable<Edge> edgesIter, Collector<Triad> out) throws Exception {
            Iterator<Edge> edges = edgesIter.iterator();
            this.vertices.clear();
            Edge firstEdge = edges.next();
            this.outTriad.setFirstVertex(firstEdge.getFirstVertex());
            this.vertices.add(firstEdge.getSecondVertex());
            while (edges.hasNext()) {
                Integer higherVertexId = edges.next().getSecondVertex();
                for (Integer lowerVertexId : this.vertices) {
                    this.outTriad.setSecondVertex(lowerVertexId);
                    this.outTriad.setThirdVertex(higherVertexId);
                    out.collect((Object)this.outTriad);
                }
                this.vertices.add(higherVertexId);
            }
        }
    }

    private static class Triad
    extends Tuple3<Integer, Integer, Integer> {
        private static final long serialVersionUID = 1L;
        public static final int V1 = 0;
        public static final int V2 = 1;
        public static final int V3 = 2;

        public void setFirstVertex(Integer vertex1) {
            this.setField(vertex1, 0);
        }

        public void setSecondVertex(Integer vertex2) {
            this.setField(vertex2, 1);
        }

        public void setThirdVertex(Integer vertex3) {
            this.setField(vertex3, 2);
        }
    }

    private static class Edge
    extends Tuple2<Integer, Integer> {
        private static final long serialVersionUID = 1L;
        public static final int V1 = 0;
        public static final int V2 = 1;

        public Edge() {
        }

        public Edge(Integer v1, Integer v2) {
            this.setFirstVertex(v1);
            this.setSecondVertex(v2);
        }

        public Integer getFirstVertex() {
            return (Integer)this.getField(0);
        }

        public Integer getSecondVertex() {
            return (Integer)this.getField(1);
        }

        public void setFirstVertex(Integer vertex1) {
            this.setField(vertex1, 0);
        }

        public void setSecondVertex(Integer vertex2) {
            this.setField(vertex2, 1);
        }

        public void copyVerticesFromTuple2(Tuple2<Integer, Integer> t) {
            this.setFirstVertex((Integer)t.f0);
            this.setSecondVertex((Integer)t.f1);
        }

        public void flipVertices() {
            Integer tmp = this.getFirstVertex();
            this.setFirstVertex(this.getSecondVertex());
            this.setSecondVertex(tmp);
        }
    }
}

