/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.flink.api.java.io.PrimitiveInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class PrimitiveInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");

    @Test
    public void testStringInput() {
        try {
            String fileContent = "abc||def||||";
            FileInputSplit split = this.createInputSplit("abc||def||||");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "||", String.class);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            String result = null;
            result = (String)format.nextRecord(result);
            Assert.assertEquals((Object)"abc", (Object)result);
            result = (String)format.nextRecord((Object)result);
            Assert.assertEquals((Object)"def", (Object)result);
            result = (String)format.nextRecord((Object)result);
            Assert.assertEquals((Object)"", (Object)result);
            result = (String)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testIntegerInput() throws IOException {
        try {
            String fileContent = "111|222|";
            FileInputSplit split = this.createInputSplit("111|222|");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "|", Integer.class);
            format.configure(new Configuration());
            format.open(split);
            Integer result = null;
            result = (Integer)format.nextRecord(result);
            Assert.assertEquals((Object)111, (Object)result);
            result = (Integer)format.nextRecord((Object)result);
            Assert.assertEquals((Object)222, (Object)result);
            result = (Integer)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testDoubleInputLinewise() throws IOException {
        try {
            String fileContent = "1.21\n2.23\n";
            FileInputSplit split = this.createInputSplit("1.21\n2.23\n");
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, Double.class);
            format.configure(new Configuration());
            format.open(split);
            Double result = null;
            result = (Double)format.nextRecord(result);
            Assert.assertEquals((Object)1.21, (Object)result);
            result = (Double)format.nextRecord((Object)result);
            Assert.assertEquals((Object)2.23, (Object)result);
            result = (Double)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testRemovingTrailingCR() {
        try {
            String first = "First line";
            String second = "Second line";
            String fileContent = first + "\r\n" + second + "\r\n";
            FileInputSplit split = this.createInputSplit(fileContent);
            PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, String.class);
            format.configure(new Configuration());
            format.open(split);
            String result = null;
            result = (String)format.nextRecord(result);
            Assert.assertEquals((Object)first, (Object)result);
            result = (String)format.nextRecord((Object)result);
            Assert.assertEquals((Object)second, (Object)result);
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test(expected=IOException.class)
    public void testFailingInput() throws IOException {
        String fileContent = "111|222|asdf|17";
        FileInputSplit split = this.createInputSplit("111|222|asdf|17");
        PrimitiveInputFormat format = new PrimitiveInputFormat(PATH, "|", Integer.class);
        format.configure(new Configuration());
        format.open(split);
        Integer result = null;
        result = (Integer)format.nextRecord(result);
        Assert.assertEquals((Object)111, (Object)result);
        result = (Integer)format.nextRecord((Object)result);
        Assert.assertEquals((Object)222, (Object)result);
        result = (Integer)format.nextRecord((Object)result);
    }

    private FileInputSplit createInputSplit(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        try (FileWriter wrt = new FileWriter(tempFile);){
            wrt.write(content);
        }
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }
}

