/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.PojoCsvInputFormat;
import org.apache.flink.api.java.io.TupleCsvInputFormat;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.StringParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CsvInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");
    private static final String FIRST_PART = "That is the first part";
    private static final String SECOND_PART = "That is the second part";

    @Test
    public void testSplitCsvInputStreamInLargeBuffer() throws Exception {
        this.testSplitCsvInputStream(0x100000, false);
    }

    @Test
    public void testSplitCsvInputStreamInSmallBuffer() throws Exception {
        this.testSplitCsvInputStream(2, false);
    }

    private void testSplitCsvInputStream(int bufferSize, boolean failAtStart) throws Exception {
        String fileContent = "this is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\nasdadas|5|30.0|\n";
        File tempFile = File.createTempFile("input-stream-decoration-test", "tmp");
        tempFile.deleteOnExit();
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            fileOutputStream.write("this is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\nasdadas|5|30.0|\n".getBytes(ConfigConstants.DEFAULT_CHARSET));
        }
        int noOfBlocks = 3;
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(new Path(tempFile.toURI()), "\n", "|", (TupleTypeInfoBase)typeInfo);
        format.setLenient(true);
        format.setBufferSize(bufferSize);
        Configuration config = new Configuration();
        format.configure(config);
        long[] offsetsAfterRecord = new long[]{15L, 29L, 42L, 58L};
        long[] offsetAtEndOfSplit = new long[]{20L, 40L, 58L};
        int recordCounter = 0;
        int splitCounter = 0;
        FileInputSplit[] inputSplits = format.createInputSplits(3);
        Tuple3 result = new Tuple3();
        for (FileInputSplit inputSplit : inputSplits) {
            Assert.assertEquals((long)(inputSplit.getStart() + inputSplit.getLength()), (long)offsetAtEndOfSplit[splitCounter]);
            ++splitCounter;
            format.open(inputSplit);
            format.reopen(inputSplit, format.getCurrentState());
            while (!format.reachedEnd()) {
                if ((result = (Tuple3)format.nextRecord((Object)result)) != null) {
                    Assert.assertEquals((long)format.getCurrentState(), (long)offsetsAfterRecord[recordCounter]);
                    if (++recordCounter == 1) {
                        Assert.assertNotNull((Object)result);
                        Assert.assertEquals((Object)"this is", (Object)result.f0);
                        Assert.assertEquals((Object)1, (Object)result.f1);
                        Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
                        Assert.assertEquals((long)format.getCurrentState(), (long)15L);
                    } else if (recordCounter == 2) {
                        Assert.assertNotNull((Object)result);
                        Assert.assertEquals((Object)"a test", (Object)result.f0);
                        Assert.assertEquals((Object)3, (Object)result.f1);
                        Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
                        Assert.assertEquals((long)format.getCurrentState(), (long)29L);
                    } else if (recordCounter == 3) {
                        Assert.assertNotNull((Object)result);
                        Assert.assertEquals((Object)"#next", (Object)result.f0);
                        Assert.assertEquals((Object)5, (Object)result.f1);
                        Assert.assertEquals((Object)new Double(6.0), (Object)result.f2);
                        Assert.assertEquals((long)format.getCurrentState(), (long)42L);
                    } else {
                        Assert.assertNotNull((Object)result);
                        Assert.assertEquals((Object)"asdadas", (Object)result.f0);
                        Assert.assertEquals((Object)new Integer(5), (Object)result.f1);
                        Assert.assertEquals((Object)new Double(30.0), (Object)result.f2);
                        Assert.assertEquals((long)format.getCurrentState(), (long)58L);
                    }
                    Long state = format.getCurrentState();
                    long offsetToRestore = state;
                    format = new TupleCsvInputFormat(new Path(tempFile.toURI()), "\n", "|", (TupleTypeInfoBase)typeInfo);
                    format.setLenient(true);
                    format.setBufferSize(bufferSize);
                    format.configure(config);
                    format.reopen(inputSplit, Long.valueOf(offsetToRestore));
                    continue;
                }
                result = new Tuple3();
            }
            format.close();
        }
        Assert.assertEquals((long)4L, (long)recordCounter);
    }

    @Test
    public void ignoreInvalidLinesAndGetOffsetInLargeBuffer() {
        this.ignoreInvalidLines(0x100000);
    }

    @Test
    public void ignoreInvalidLinesAndGetOffsetInSmallBuffer() {
        this.ignoreInvalidLines(2);
    }

    private void ignoreInvalidLines(int bufferSize) {
        try {
            String fileContent = "#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas";
            FileInputSplit split = this.createTempFile("#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setLenient(true);
            format.setBufferSize(bufferSize);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)1, (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            Assert.assertEquals((long)format.getCurrentState(), (long)65L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)3, (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            Assert.assertEquals((long)format.getCurrentState(), (long)91L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"#next", (Object)result.f0);
            Assert.assertEquals((Object)5, (Object)result.f1);
            Assert.assertEquals((Object)new Double(6.0), (Object)result.f2);
            Assert.assertEquals((long)format.getCurrentState(), (long)104L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertEquals((long)"#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas".length(), (long)format.getCurrentState());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void ignoreSingleCharPrefixComments() {
        try {
            String fileContent = "#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setCommentPrefix("#");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)1, (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)3, (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void ignoreMultiCharPrefixComments() {
        try {
            String fileContent = "//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setCommentPrefix("//");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"this is", (Object)result.f0);
            Assert.assertEquals((Object)1, (Object)result.f1);
            Assert.assertEquals((Object)new Double(2.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a test", (Object)result.f0);
            Assert.assertEquals((Object)3, (Object)result.f1);
            Assert.assertEquals((Object)new Double(4.0), (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readStringFields() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"def", (Object)result.f1);
            Assert.assertEquals((Object)"ghijk", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"hhg", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readMixedQuotedStringFields() {
        try {
            String fileContent = "@a|b|c@|def|@ghijk@\nabc||@|hhg@\n|||";
            FileInputSplit split = this.createTempFile("@a|b|c@|def|@ghijk@\nabc||@|hhg@\n|||");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.enableQuotedStringParsing('@');
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"a|b|c", (Object)result.f0);
            Assert.assertEquals((Object)"def", (Object)result.f1);
            Assert.assertEquals((Object)"ghijk", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"|hhg", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readStringFieldsWithTrailingDelimiters() {
        try {
            String fileContent = "abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n";
            FileInputSplit split = this.createTempFile("abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|-");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"def", (Object)result.f1);
            Assert.assertEquals((Object)"ghijk", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"abc", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"hhg", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)"", (Object)result.f0);
            Assert.assertEquals((Object)"", (Object)result.f1);
            Assert.assertEquals((Object)"", (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testTailingEmptyFields() throws Exception {
        String fileContent = "aa,bb,cc\naa,bb,\naa,,\n,,\naa,bb";
        FileInputSplit split = this.createTempFile("aa,bb,cc\naa,bb,\naa,,\n,,\naa,bb");
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Tuple3 result = new Tuple3();
        result = (Tuple3)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aa", (Object)result.f0);
        Assert.assertEquals((Object)"bb", (Object)result.f1);
        Assert.assertEquals((Object)"cc", (Object)result.f2);
        result = (Tuple3)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aa", (Object)result.f0);
        Assert.assertEquals((Object)"bb", (Object)result.f1);
        Assert.assertEquals((Object)"", (Object)result.f2);
        result = (Tuple3)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"aa", (Object)result.f0);
        Assert.assertEquals((Object)"", (Object)result.f1);
        Assert.assertEquals((Object)"", (Object)result.f2);
        result = (Tuple3)format.nextRecord((Object)result);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"", (Object)result.f0);
        Assert.assertEquals((Object)"", (Object)result.f1);
        Assert.assertEquals((Object)"", (Object)result.f2);
        try {
            format.nextRecord((Object)result);
            Assert.fail((String)"Parse Exception was not thrown! (Row too short)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerFields() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555\n666|777|888|999|000|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = new Tuple5();
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)222, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            Assert.assertEquals((Object)444, (Object)result.f3);
            Assert.assertEquals((Object)555, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            Assert.assertEquals((Object)999, (Object)result.f3);
            Assert.assertEquals((Object)0, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testEmptyFields() throws IOException {
        try {
            String fileContent = "|0|0|0|0|0|\n1||1|1|1|1|\n2|2||2|2|2|\n3|3|3| |3|3|\n4|4|4|4||4|\n5|5|5|5|5||\n";
            FileInputSplit split = this.createTempFile("|0|0|0|0|0|\n1||1|1|1|1|\n2|2||2|2|2|\n3|3|3| |3|3|\n4|4|4|4||4|\n5|5|5|5|5||\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Short.class, Integer.class, Long.class, Float.class, Double.class, Byte.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple6 result = new Tuple6();
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (ShortParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (IntegerParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (LongParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (FloatParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (DoubleParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assert.fail((String)"Empty String Parse Exception was not thrown! (ByteParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            result = (Tuple6)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testDoubleFields() throws IOException {
        try {
            String fileContent = "11.1|22.2|33.3|44.4|55.5\n66.6|77.7|88.8|99.9|00.0|\n";
            FileInputSplit split = this.createTempFile("11.1|22.2|33.3|44.4|55.5\n66.6|77.7|88.8|99.9|00.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = new Tuple5();
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)11.1, (Object)result.f0);
            Assert.assertEquals((Object)22.2, (Object)result.f1);
            Assert.assertEquals((Object)33.3, (Object)result.f2);
            Assert.assertEquals((Object)44.4, (Object)result.f3);
            Assert.assertEquals((Object)55.5, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)66.6, (Object)result.f0);
            Assert.assertEquals((Object)77.7, (Object)result.f1);
            Assert.assertEquals((Object)88.8, (Object)result.f2);
            Assert.assertEquals((Object)99.9, (Object)result.f3);
            Assert.assertEquals((Object)0.0, (Object)result.f4);
            result = (Tuple5)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadFirstN() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|\n666|777|888|999|000|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple2 result = new Tuple2();
            result = (Tuple2)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)222, (Object)result.f1);
            result = (Tuple2)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)666, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            result = (Tuple2)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithNullFieldsForTypes() throws IOException {
        try {
            String fileContent = "111|x|222|x|333|x|444|x|555|x|666|x|777|x|888|x|999|x|000|x|\n000|x|999|x|888|x|777|x|666|x|555|x|444|x|333|x|222|x|111|x|";
            FileInputSplit split = this.createTempFile("111|x|222|x|333|x|444|x|555|x|666|x|777|x|888|x|999|x|000|x|\n000|x|999|x|888|x|777|x|666|x|555|x|444|x|333|x|222|x|111|x|");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, false, true, false, false, false, true});
            format.setFieldDelimiter("|x|");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithPositionSetter() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new int[]{0, 3, 7});
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadSparseWithMask() throws IOException {
        try {
            String fileContent = "111&&222&&333&&444&&555&&666&&777&&888&&999&&000&&\n000&&999&&888&&777&&666&&555&&444&&333&&222&&111&&";
            FileInputSplit split = this.createTempFile("111&&222&&333&&444&&555&&666&&777&&888&&999&&000&&\n000&&999&&888&&777&&666&&555&&444&&333&&222&&111&&");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, false, true, false, false, false, true});
            format.setFieldDelimiter("&&");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)111, (Object)result.f0);
            Assert.assertEquals((Object)444, (Object)result.f1);
            Assert.assertEquals((Object)888, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)0, (Object)result.f0);
            Assert.assertEquals((Object)777, (Object)result.f1);
            Assert.assertEquals((Object)333, (Object)result.f2);
            result = (Tuple3)format.nextRecord((Object)result);
            Assert.assertNull((Object)result);
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testParseStringErrors() throws Exception {
        Object[][] failures;
        StringParser stringParser = new StringParser();
        stringParser.enableQuotedStringParsing((byte)34);
        for (Object[] failure : failures = new Object[][]{{"\"string\" trailing", FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING}, {"\"unterminated ", FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING}}) {
            String input = (String)failure[0];
            int result = stringParser.parseField(input.getBytes(ConfigConstants.DEFAULT_CHARSET), 0, input.length(), new byte[]{124}, null);
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)-1));
            Assert.assertThat((Object)stringParser.getErrorState(), (Matcher)CoreMatchers.is((Object)failure[1]));
        }
    }

    public void testParserCorrectness() throws Exception {
        String fileContent = "Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00";
        FileInputSplit split = this.createTempFile("Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00");
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, String.class, String.class, String.class, Double.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
        format.setSkipFirstLineAsHeader(true);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Tuple5 result = new Tuple5();
        Tuple5[] expectedLines = new Tuple5[]{new Tuple5((Object)1997, (Object)"Ford", (Object)"E350", (Object)"ac, abs, moon", (Object)3000.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0), new Tuple5((Object)1996, (Object)"Jeep", (Object)"Grand Cherokee", (Object)"MUST SELL! air, moon roof, loaded", (Object)4799.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition, Very Large\"", (Object)"", (Object)5000.0), new Tuple5((Object)0, (Object)"", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0)};
        try {
            for (Tuple5 expected : expectedLines) {
                result = (Tuple5)format.nextRecord((Object)result);
                Assert.assertEquals((Object)expected, (Object)result);
            }
            Assert.assertNull((Object)format.nextRecord((Object)result));
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    private FileInputSplit createTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);
        wrt.write(content);
        wrt.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    @Test
    public void testWindowsLineEndRemoval() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\r\n");
        this.testRemovingTrailingCR("\r\n", "\n");
    }

    private void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) {
        File tempFile = null;
        String fileContent = FIRST_PART + lineBreakerInFile + SECOND_PART + lineBreakerInFile;
        try {
            tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(fileContent);
            wrt.close();
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class});
            TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(lineBreakerSetup);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Tuple1 result = (Tuple1)inputFormat.nextRecord((Object)new Tuple1());
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)FIRST_PART, (Object)result.f0);
            result = (Tuple1)inputFormat.nextRecord((Object)result);
            Assert.assertNotNull((String)"Expecting to not return null", (Object)result);
            Assert.assertEquals((Object)SECOND_PART, (Object)result.f0);
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }

    private void validatePojoItem(CsvInputFormat<PojoItem> format) throws Exception {
        PojoItem item = new PojoItem();
        format.nextRecord((Object)item);
        Assert.assertEquals((long)123L, (long)item.field1);
        Assert.assertEquals((Object)"AAA", (Object)item.field2);
        Assert.assertEquals((Object)3.123, (Object)item.field3);
        Assert.assertEquals((Object)"BBB", (Object)item.field4);
        format.nextRecord((Object)item);
        Assert.assertEquals((long)456L, (long)item.field1);
        Assert.assertEquals((Object)"BBB", (Object)item.field2);
        Assert.assertEquals((Object)1.123, (Object)item.field3);
        Assert.assertEquals((Object)"AAA", (Object)item.field4);
    }

    @Test
    public void testPojoType() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,AAA,3.123,BBB\n");
        wrt.write("456,BBB,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    public void testPojoTypeWithPrivateField() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,AAA,3.123,BBB\n");
        wrt.write("456,BBB,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PrivatePojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        PrivatePojoItem item = new PrivatePojoItem();
        inputFormat.nextRecord((Object)item);
        Assert.assertEquals((long)123L, (long)item.field1);
        Assert.assertEquals((Object)"AAA", (Object)item.field2);
        Assert.assertEquals((Object)3.123, (Object)item.field3);
        Assert.assertEquals((Object)"BBB", (Object)item.field4);
        inputFormat.nextRecord((Object)item);
        Assert.assertEquals((long)456L, (long)item.field1);
        Assert.assertEquals((Object)"BBB", (Object)item.field2);
        Assert.assertEquals((Object)1.123, (Object)item.field3);
        Assert.assertEquals((Object)"AAA", (Object)item.field4);
    }

    @Test
    public void testPojoTypeWithTrailingEmptyFields() throws Exception {
        String fileContent = "123,,3.123,,\n456,BBB,3.23,,";
        FileInputSplit split = this.createTempFile("123,,3.123,,\n456,BBB,3.23,,");
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PrivatePojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(PATH, typeInfo);
        inputFormat.configure(new Configuration());
        inputFormat.open(split);
        PrivatePojoItem item = new PrivatePojoItem();
        inputFormat.nextRecord((Object)item);
        Assert.assertEquals((long)123L, (long)item.field1);
        Assert.assertEquals((Object)"", (Object)item.field2);
        Assert.assertEquals((Object)3.123, (Object)item.field3);
        Assert.assertEquals((Object)"", (Object)item.field4);
        inputFormat.nextRecord((Object)item);
        Assert.assertEquals((long)456L, (long)item.field1);
        Assert.assertEquals((Object)"BBB", (Object)item.field2);
        Assert.assertEquals((Object)3.23, (Object)item.field3);
        Assert.assertEquals((Object)"", (Object)item.field4);
    }

    @Test
    public void testPojoTypeWithMappingInformation() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,3.123,AAA,BBB\n");
        wrt.write("456,1.123,BBB,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field3", "field2", "field4"});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    public void testPojoTypeWithPartialFieldInCSV() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,NODATA,AAA,NODATA,3.123,BBB\n");
        wrt.write("456,NODATA,BBB,NODATA,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new boolean[]{true, false, true, false, true, true});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    public void testPojoTypeWithMappingInfoAndPartialField() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,3.123,AAA,BBB\n");
        wrt.write("456,1.123,BBB,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field4"}, new boolean[]{true, false, false, true});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        PojoItem item = new PojoItem();
        inputFormat.nextRecord((Object)item);
        Assert.assertEquals((long)123L, (long)item.field1);
        Assert.assertEquals((Object)"BBB", (Object)item.field4);
    }

    @Test
    public void testPojoTypeWithInvalidFieldMapping() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2"});
            Assert.fail((String)"The number of POJO fields cannot be same as that of selected CSV fields");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2", null, "field4"});
            Assert.fail((String)"Fields mapping cannot contain null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2", "field3", "field5"});
            Assert.fail((String)"Invalid field name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testQuotedStringParsingWithIncludeFields() throws Exception {
        String fileContent = "\"20:41:52-1-3-2015\"|\"Re: Taskmanager memory error in Eclipse\"|\"Blahblah <blah@blahblah.org>\"|\"blaaa|\"blubb\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("\"20:41:52-1-3-2015\"|\"Re: Taskmanager memory error in Eclipse\"|\"Blahblah <blah@blahblah.org>\"|\"blaaa|\"blubb\"");
        writer.close();
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, true});
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Tuple2 record = (Tuple2)inputFormat.nextRecord((Object)new Tuple2());
        Assert.assertEquals((Object)"20:41:52-1-3-2015", (Object)record.f0);
        Assert.assertEquals((Object)"Blahblah <blah@blahblah.org>", (Object)record.f1);
    }

    @Test
    public void testQuotedStringParsingWithEscapedQuotes() throws Exception {
        String fileContent = "\"\\\"Hello\\\" World\"|\"We are\\\" young\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("\"\\\"Hello\\\" World\"|\"We are\\\" young\"");
        writer.close();
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo);
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Tuple2 record = (Tuple2)inputFormat.nextRecord((Object)new Tuple2());
        Assert.assertEquals((Object)"\\\"Hello\\\" World", (Object)record.f0);
        Assert.assertEquals((Object)"We are\\\" young", (Object)record.f1);
    }

    @Test
    public void testPojoSubclassType() throws Exception {
        TwitterPOJO pojo;
        String fileContent = "t1,foobar,tweet2\nt2,barfoo,tweet2";
        File tempFile = File.createTempFile("CsvReaderPOJOSubclass", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("t1,foobar,tweet2\nt2,barfoo,tweet2");
        writer.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(TwitterPOJO.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        ArrayList<TwitterPOJO> expected = new ArrayList<TwitterPOJO>();
        for (String line : "t1,foobar,tweet2\nt2,barfoo,tweet2".split("\n")) {
            String[] elements = line.split(",");
            expected.add(new TwitterPOJO(elements[0], elements[1], elements[2]));
        }
        ArrayList<TwitterPOJO> actual = new ArrayList<TwitterPOJO>();
        while ((pojo = (TwitterPOJO)inputFormat.nextRecord((Object)new TwitterPOJO())) != null) {
            actual.add(pojo);
        }
        Assert.assertEquals(expected, actual);
    }

    public static class TwitterPOJO
    extends POJO {
        public String tweet;

        public TwitterPOJO() {
            this("", "", "");
        }

        public TwitterPOJO(String table, String time, String tweet) {
            super(table, time);
            this.tweet = tweet;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TwitterPOJO) {
                TwitterPOJO other = (TwitterPOJO)obj;
                return super.equals(other) && this.tweet.equals(other.tweet);
            }
            return false;
        }
    }

    public static class POJO {
        public String table;
        public String time;

        public POJO() {
            this("", "");
        }

        public POJO(String table, String time) {
            this.table = table;
            this.time = time;
        }

        public boolean equals(Object obj) {
            if (obj instanceof POJO) {
                POJO other = (POJO)obj;
                return this.table.equals(other.table) && this.time.equals(other.time);
            }
            return false;
        }
    }

    public static class PrivatePojoItem {
        private int field1;
        private String field2;
        private Double field3;
        private String field4;

        public int getField1() {
            return this.field1;
        }

        public void setField1(int field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public Double getField3() {
            return this.field3;
        }

        public void setField3(Double field3) {
            this.field3 = field3;
        }

        public String getField4() {
            return this.field4;
        }

        public void setField4(String field4) {
            this.field4 = field4;
        }
    }

    public static class PojoItem {
        public int field1;
        public String field2;
        public Double field3;
        public String field4;
    }
}

