/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.junit.Assert;
import org.junit.Test;

public class ReduceOperatorTest
implements Serializable {
    @Test
    public void testReduceCollection() {
        try {
            ReduceFunction<Tuple2<String, Integer>> reducer = new ReduceFunction<Tuple2<String, Integer>>(){

                public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                    return new Tuple2(value1.f0, (Object)((Integer)value1.f1 + (Integer)value2.f1));
                }
            };
            ReduceOperatorBase op = new ReduceOperatorBase((ReduceFunction)reducer, new UnaryOperatorInformation(TypeInfoParser.parse((String)"Tuple2<String, Integer>"), TypeInfoParser.parse((String)"Tuple2<String, Integer>")), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, null, executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, null, executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assert.assertEquals(expectedResult, resultSetMutableSafe);
            Assert.assertEquals(expectedResult, resultSetRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReduceCollectionWithRuntimeContext() {
        try {
            String taskName = "Test Task";
            final AtomicBoolean opened = new AtomicBoolean();
            final AtomicBoolean closed = new AtomicBoolean();
            RichReduceFunction<Tuple2<String, Integer>> reducer = new RichReduceFunction<Tuple2<String, Integer>>(){

                public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                    return new Tuple2(value1.f0, (Object)((Integer)value1.f1 + (Integer)value2.f1));
                }

                public void open(Configuration parameters) throws Exception {
                    opened.set(true);
                    RuntimeContext ctx = this.getRuntimeContext();
                    Assert.assertEquals((long)0L, (long)ctx.getIndexOfThisSubtask());
                    Assert.assertEquals((long)1L, (long)ctx.getNumberOfParallelSubtasks());
                    Assert.assertEquals((Object)"Test Task", (Object)ctx.getTaskName());
                }

                public void close() throws Exception {
                    closed.set(true);
                }
            };
            ReduceOperatorBase op = new ReduceOperatorBase((ReduceFunction)reducer, new UnaryOperatorInformation(TypeInfoParser.parse((String)"Tuple2<String, Integer>"), TypeInfoParser.parse((String)"Tuple2<String, Integer>")), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            TaskInfo taskInfo = new TaskInfo("Test Task", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), (MetricGroup)new UnregisteredMetricsGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, new HashMap(), new HashMap(), (MetricGroup)new UnregisteredMetricsGroup()), executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assert.assertEquals(expectedResult, resultSetMutableSafe);
            Assert.assertEquals(expectedResult, resultSetRegular);
            Assert.assertTrue((boolean)opened.get());
            Assert.assertTrue((boolean)closed.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

