/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.tuple.Tuple2;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class PlanGeneratorTest {
    PlanGeneratorTest() {
    }

    @Test
    void testGenerate() {
        String fileA = "fileA";
        String fileB = "fileB";
        Map<String, DistributedCache.DistributedCacheEntry> originalArtifacts = Stream.of(Tuple2.of((Object)"fileA", (Object)new DistributedCache.DistributedCacheEntry("test1", Boolean.valueOf(true))), Tuple2.of((Object)"fileB", (Object)new DistributedCache.DistributedCacheEntry("test2", Boolean.valueOf(false)))).collect(Collectors.toMap(x -> (String)x.f0, x -> (DistributedCache.DistributedCacheEntry)x.f1));
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(10);
        env.registerCachedFile("test1", "fileA", true);
        env.registerCachedFile("test2", "fileB", false);
        env.fromElements((Object[])new Integer[]{1, 3, 5}).map((MapFunction & Serializable)value -> String.valueOf(value + 1)).writeAsText("/tmp/csv");
        Plan generatedPlanUnderTest = env.createProgramPlan("test");
        Map<String, DistributedCache.DistributedCacheEntry> retrievedArtifacts = generatedPlanUnderTest.getCachedFiles().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertThat((Collection)generatedPlanUnderTest.getDataSinks()).hasSize(1);
        Assertions.assertThat((int)generatedPlanUnderTest.getDefaultParallelism()).isEqualTo(10);
        Assertions.assertThat((Object)generatedPlanUnderTest.getExecutionConfig()).isEqualTo((Object)env.getConfig());
        Assertions.assertThat((String)generatedPlanUnderTest.getJobName()).isEqualTo("test");
        ((MapAssert)((MapAssert)Assertions.assertThat(retrievedArtifacts).hasSameSizeAs(originalArtifacts)).containsEntry((Object)"fileA", (Object)originalArtifacts.get("fileA"))).containsEntry((Object)"fileB", (Object)originalArtifacts.get("fileB"));
    }
}

