/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class ShortSummaryAggregatorTest {
    ShortSummaryAggregatorTest() {
    }

    @Test
    void testIsNan() {
        ShortSummaryAggregator ag = new ShortSummaryAggregator();
        Assertions.assertThat((boolean)ag.isNan(Short.valueOf((short)-1))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Short.valueOf((short)0))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Short.valueOf((short)23))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Short.valueOf((short)Short.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Short.valueOf((short)Short.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(null)).isFalse();
    }

    @Test
    void testIsInfinite() {
        ShortSummaryAggregator ag = new ShortSummaryAggregator();
        Assertions.assertThat((boolean)ag.isInfinite(Short.valueOf((short)-1))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Short.valueOf((short)0))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Short.valueOf((short)23))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Short.valueOf((short)Short.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Short.valueOf((short)Short.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(null)).isFalse();
    }

    @Test
    void testMean() {
        Assertions.assertThat((Double)this.summarize(0, 100).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0, 0, 100).getMean()).isCloseTo(33.333333, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)this.summarize(0, 0, 100, 100).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0, 100, null).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(new Integer[0]).getMean()).isNull();
    }

    @Test
    void testSum() throws Exception {
        Assertions.assertThat((short)((Short)this.summarize(0, 100).getSum())).isEqualTo((short)100);
        Assertions.assertThat((short)((Short)this.summarize(1, 2, 3, 4, 5).getSum())).isEqualTo((short)15);
        Assertions.assertThat((short)((Short)this.summarize(-100, 0, 100, null).getSum())).isZero();
        Assertions.assertThat((short)((Short)this.summarize(-10, 100, null).getSum())).isEqualTo((short)90);
        Assertions.assertThat((Short)((Short)this.summarize(new Integer[0]).getSum())).isNull();
    }

    @Test
    void testMax() {
        Assertions.assertThat((short)((Short)this.summarize(-1000, 0, 1, 50, 999, 1001).getMax())).isEqualTo((short)1001);
        Assertions.assertThat((short)((Short)this.summarize((Integer)Short.MIN_VALUE, -1000, 0).getMax())).isZero();
        Assertions.assertThat((short)((Short)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMax())).isEqualTo((short)11);
        Assertions.assertThat((short)((Short)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMax())).isEqualTo((short)11);
        Assertions.assertThat((Short)((Short)this.summarize(new Integer[0]).getMax())).isNull();
    }

    @Test
    void testMin() {
        Assertions.assertThat((short)((Short)this.summarize(-1000, 0, 1, 50, 999, 1001).getMin())).isEqualTo((short)-1000);
        Assertions.assertThat((short)((Short)this.summarize((Integer)Short.MIN_VALUE, -1000, 0).getMin())).isEqualTo((short)Short.MIN_VALUE);
        Assertions.assertThat((short)((Short)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMin())).isEqualTo((short)-2);
        Assertions.assertThat((short)((Short)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMin())).isEqualTo((short)-2);
        Assertions.assertThat((Short)((Short)this.summarize(new Integer[0]).getMin())).isNull();
    }

    protected NumericColumnSummary<Short> summarize(Integer ... values) {
        Short[] shortValues = new Short[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            shortValues[i] = values[i].shortValue();
        }
        return (NumericColumnSummary)new AggregateCombineHarness<Short, NumericColumnSummary<Short>, ShortSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Short> result1, NumericColumnSummary<Short> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((short)((Short)result2.getMin())).isEqualTo(((Short)result1.getMin()).shortValue());
                Assertions.assertThat((short)((Short)result2.getMax())).isEqualTo(((Short)result1.getMax()).shortValue());
                Assertions.assertThat((short)((Short)result2.getSum())).isEqualTo(((Short)result1.getSum()).shortValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(shortValues);
    }
}

