/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class LongSummaryAggregatorTest {
    LongSummaryAggregatorTest() {
    }

    @Test
    void testIsNan() {
        LongSummaryAggregator ag = new LongSummaryAggregator();
        Assertions.assertThat((boolean)ag.isNan(Long.valueOf(-1L))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Long.valueOf(0L))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Long.valueOf(23L))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Long.valueOf(Long.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(Long.valueOf(Long.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isNan(null)).isFalse();
    }

    @Test
    void testIsInfinite() {
        LongSummaryAggregator ag = new LongSummaryAggregator();
        Assertions.assertThat((boolean)ag.isInfinite(Long.valueOf(-1L))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Long.valueOf(0L))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Long.valueOf(23L))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Long.valueOf(Long.MAX_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(Long.valueOf(Long.MIN_VALUE))).isFalse();
        Assertions.assertThat((boolean)ag.isInfinite(null)).isFalse();
    }

    @Test
    void testMean() {
        Assertions.assertThat((Double)this.summarize(0L, 100L).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0L, 0L, 100L).getMean()).isCloseTo(33.333333, Offset.offset((Number)1.0E-5));
        Assertions.assertThat((Double)this.summarize(0L, 0L, 100L, 100L).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(0L, 100L, null).getMean()).isCloseTo(50.0, Offset.offset((Number)0.0));
        Assertions.assertThat((Double)this.summarize(new Long[0]).getMean()).isNull();
    }

    @Test
    void testSum() throws Exception {
        Assertions.assertThat((long)((Long)this.summarize(0L, 100L).getSum())).isEqualTo(100L);
        Assertions.assertThat((long)((Long)this.summarize(1L, 2L, 3L, 4L, 5L).getSum())).isEqualTo(15L);
        Assertions.assertThat((long)((Long)this.summarize(-100L, 0L, 100L, null).getSum())).isZero();
        Assertions.assertThat((long)((Long)this.summarize(-10L, 100L, null).getSum())).isEqualTo(90L);
        Assertions.assertThat((Long)((Long)this.summarize(new Long[0]).getSum())).isNull();
    }

    @Test
    void testMax() {
        Assertions.assertThat((long)((Long)this.summarize(-1000L, 0L, 1L, 50L, 999L, 1001L).getMax())).isEqualTo(1001L);
        Assertions.assertThat((long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, 10L, 2L, 3L, 5L, 0L, 11L, -2L, 3L).getMax())).isEqualTo(11L);
        Assertions.assertThat((long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, null, 10L, 2L, 3L, 5L, null, 0L, 11L, -2L, 3L).getMax())).isEqualTo(11L);
        Assertions.assertThat((Long)((Long)this.summarize(new Long[0]).getMax())).isNull();
    }

    @Test
    void testMin() {
        Assertions.assertThat((long)((Long)this.summarize(-1000L, 0L, 1L, 50L, 999L, 1001L).getMin())).isEqualTo(-1000L);
        Assertions.assertThat((long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, 10L, 2L, 3L, 5L, 0L, 11L, -2L, 3L).getMin())).isEqualTo(-2L);
        Assertions.assertThat((long)((Long)this.summarize(1L, 8L, 7L, 6L, 9L, null, 10L, 2L, 3L, 5L, null, 0L, 11L, -2L, 3L).getMin())).isEqualTo(-2L);
        Assertions.assertThat((Long)((Long)this.summarize(new Long[0]).getMin())).isNull();
    }

    protected NumericColumnSummary<Long> summarize(Long ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Long, NumericColumnSummary<Long>, LongSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Long> result1, NumericColumnSummary<Long> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((long)((Long)result2.getMin())).isEqualTo(((Long)result1.getMin()).longValue());
                Assertions.assertThat((long)((Long)result2.getMax())).isEqualTo(((Long)result1.getMax()).longValue());
                Assertions.assertThat((long)((Long)result2.getSum())).isEqualTo(((Long)result1.getSum()).longValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(values);
    }
}

