/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.IntegerSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.IntValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class IntegerValueSummaryAggregatorTest
extends IntegerSummaryAggregatorTest {
    IntegerValueSummaryAggregatorTest() {
    }

    @Override
    protected NumericColumnSummary<Integer> summarize(Integer ... values) {
        IntValue[] intValues = new IntValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            intValues[i] = new IntValue(values[i].intValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<IntValue, NumericColumnSummary<Integer>, ValueSummaryAggregator.IntegerValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Integer> result1, NumericColumnSummary<Integer> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((int)((Integer)result2.getMin())).isEqualTo(((Integer)result1.getMin()).intValue());
                Assertions.assertThat((int)((Integer)result2.getMax())).isEqualTo(((Integer)result1.getMax()).intValue());
                Assertions.assertThat((int)((Integer)result2.getSum())).isEqualTo(((Integer)result1.getSum()).intValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(intValues);
    }
}

