/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.FloatValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class FloatValueSummaryAggregatorTest
extends FloatSummaryAggregatorTest {
    FloatValueSummaryAggregatorTest() {
    }

    @Override
    protected NumericColumnSummary<Float> summarize(Float ... values) {
        FloatValue[] floatValues = new FloatValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            floatValues[i] = new FloatValue(values[i].floatValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<FloatValue, NumericColumnSummary<Float>, ValueSummaryAggregator.FloatValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Float> result1, NumericColumnSummary<Float> result2) {
                Assertions.assertThat((Float)((Float)result2.getMin())).isCloseTo((Float)result1.getMin(), Offset.offset((Number)Float.valueOf(0.0f)));
                Assertions.assertThat((Float)((Float)result2.getMax())).isCloseTo((Float)result1.getMax(), Offset.offset((Number)Float.valueOf(0.0f)));
                Assertions.assertThat((Double)result2.getMean()).isCloseTo(result1.getMean(), Offset.offset((Number)1.0E-10));
                Assertions.assertThat((Double)result2.getVariance()).isCloseTo(result1.getVariance(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((Double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation(), Offset.offset((Number)1.0E-10));
            }
        }.summarize(floatValues);
    }
}

