/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.flink.api.java.sampling.BernoulliSampler;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.PoissonSampler;
import org.apache.flink.api.java.sampling.RandomSampler;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithReplacement;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithoutReplacement;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.apache.flink.testutils.junit.extensions.retry.RetryExtension;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RetryExtension.class})
class RandomSamplerTest {
    private static final int SOURCE_SIZE = 10000;
    private static final int DEFAULT_PARTITION_NUMBER = 10;
    private static final KolmogorovSmirnovTest ksTest = new KolmogorovSmirnovTest();
    private static final List<Double> source = new ArrayList<Double>(10000);
    private final List<Double>[] sourcePartitions = new List[10];

    RandomSamplerTest() {
    }

    @BeforeAll
    static void init() {
        for (int i = 0; i < 10000; ++i) {
            source.add(Double.valueOf(i));
        }
    }

    private void initSourcePartition() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.sourcePartitions[i] = new ArrayList<Double>((int)Math.ceil(1000.0));
        }
        for (i = 0; i < 10000; ++i) {
            int index = i % 10;
            this.sourcePartitions[index].add(Double.valueOf(i));
        }
    }

    @Test
    void testBernoulliSamplerWithUnexpectedFraction1() {
        Assertions.assertThatThrownBy(() -> this.verifySamplerFraction(-1.0, false)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testBernoulliSamplerWithUnexpectedFraction2() {
        Assertions.assertThatThrownBy(() -> this.verifySamplerFraction(2.0, false)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testBernoulliSamplerFraction() {
        this.verifySamplerFraction(0.01, false);
        this.verifySamplerFraction(0.05, false);
        this.verifySamplerFraction(0.1, false);
        this.verifySamplerFraction(0.3, false);
        this.verifySamplerFraction(0.5, false);
        this.verifySamplerFraction(0.854, false);
        this.verifySamplerFraction(0.99, false);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testBernoulliSamplerDuplicateElements() {
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.01));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.1));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.5));
    }

    @Test
    void testPoissonSamplerWithUnexpectedFraction1() {
        Assertions.assertThatThrownBy(() -> this.verifySamplerFraction(-1.0, true)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testPoissonSamplerFraction() {
        this.verifySamplerFraction(0.01, true);
        this.verifySamplerFraction(0.05, true);
        this.verifySamplerFraction(0.1, true);
        this.verifySamplerFraction(0.5, true);
        this.verifySamplerFraction(0.854, true);
        this.verifySamplerFraction(0.99, true);
        this.verifySamplerFraction(1.5, true);
    }

    @Test
    void testReservoirSamplerUnexpectedSize1() {
        Assertions.assertThatThrownBy(() -> this.verifySamplerFixedSampleSize(-1, true)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testReservoirSamplerUnexpectedSize2() {
        Assertions.assertThatThrownBy(() -> this.verifySamplerFixedSampleSize(-1, false)).isInstanceOf(IllegalArgumentException.class);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testBernoulliSamplerDistribution() {
        this.verifyBernoulliSampler(0.01);
        this.verifyBernoulliSampler(0.05);
        this.verifyBernoulliSampler(0.1);
        this.verifyBernoulliSampler(0.5);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testPoissonSamplerDistribution() {
        this.verifyPoissonSampler(0.01);
        this.verifyPoissonSampler(0.05);
        this.verifyPoissonSampler(0.1);
        this.verifyPoissonSampler(0.5);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerSampledSize() {
        this.verifySamplerFixedSampleSize(1, true);
        this.verifySamplerFixedSampleSize(10, true);
        this.verifySamplerFixedSampleSize(100, true);
        this.verifySamplerFixedSampleSize(1234, true);
        this.verifySamplerFixedSampleSize(9999, true);
        this.verifySamplerFixedSampleSize(20000, true);
        this.verifySamplerFixedSampleSize(1, false);
        this.verifySamplerFixedSampleSize(10, false);
        this.verifySamplerFixedSampleSize(100, false);
        this.verifySamplerFixedSampleSize(1234, false);
        this.verifySamplerFixedSampleSize(9999, false);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerSampledSize2() {
        ReservoirSamplerWithoutReplacement sampler = new ReservoirSamplerWithoutReplacement(20000);
        Iterator sampled = sampler.sample(source.iterator());
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getSize(sampled)).as("ReservoirSamplerWithoutReplacement sampled output size should not beyond the source size.", new Object[0])).isEqualTo(10000);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerDuplicateElements() {
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(100));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(1000));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(5000));
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerWithoutReplacement() {
        this.verifyReservoirSamplerWithoutReplacement(100, false);
        this.verifyReservoirSamplerWithoutReplacement(500, false);
        this.verifyReservoirSamplerWithoutReplacement(1000, false);
        this.verifyReservoirSamplerWithoutReplacement(5000, false);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerWithReplacement() {
        this.verifyReservoirSamplerWithReplacement(100, false);
        this.verifyReservoirSamplerWithReplacement(500, false);
        this.verifyReservoirSamplerWithReplacement(1000, false);
        this.verifyReservoirSamplerWithReplacement(5000, false);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerWithMultiSourcePartitions1() {
        this.initSourcePartition();
        this.verifyReservoirSamplerWithoutReplacement(100, true);
        this.verifyReservoirSamplerWithoutReplacement(500, true);
        this.verifyReservoirSamplerWithoutReplacement(1000, true);
        this.verifyReservoirSamplerWithoutReplacement(5000, true);
    }

    @TestTemplate
    @RetryOnFailure(times=3)
    void testReservoirSamplerWithMultiSourcePartitions2() {
        this.initSourcePartition();
        this.verifyReservoirSamplerWithReplacement(100, true);
        this.verifyReservoirSamplerWithReplacement(500, true);
        this.verifyReservoirSamplerWithReplacement(1000, true);
        this.verifyReservoirSamplerWithReplacement(5000, true);
    }

    private void verifySamplerFixedSampleSize(int numSample, boolean withReplacement) {
        Object sampler = withReplacement ? new ReservoirSamplerWithReplacement(numSample) : new ReservoirSamplerWithoutReplacement(numSample);
        Iterator sampled = sampler.sample(source.iterator());
        Assertions.assertThat((int)this.getSize(sampled)).isEqualTo(numSample);
    }

    private void verifySamplerFraction(double fraction, boolean withReplacement) {
        Object sampler = withReplacement ? new PoissonSampler(fraction) : new BernoulliSampler(fraction);
        int totalSampledSize = 0;
        double sampleCount = 20.0;
        int i = 0;
        while ((double)i < sampleCount) {
            totalSampledSize += this.getSize(sampler.sample(source.iterator()));
            ++i;
        }
        double resultFraction = (double)totalSampledSize / (10000.0 * sampleCount);
        ((AbstractDoubleAssert)Assertions.assertThat((double)Math.abs((resultFraction - fraction) / fraction)).as(String.format("expected fraction: %f, result fraction: %f", fraction, resultFraction), new Object[0])).isLessThan(0.2);
    }

    private void verifyRandomSamplerDuplicateElements(RandomSampler<Double> sampler) {
        Iterator values = sampler.sample(source.iterator());
        HashSet<Double> set = new HashSet<Double>();
        while (values.hasNext()) {
            double next = (Double)values.next();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.add(next)).as("Sampler returned duplicate element (" + next + "). Set=" + set, new Object[0])).isTrue();
        }
    }

    private int getSize(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    private void verifyBernoulliSampler(double fraction) {
        BernoulliSampler sampler = new BernoulliSampler(fraction);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, true);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, false);
    }

    private void verifyPoissonSampler(double fraction) {
        PoissonSampler sampler = new PoissonSampler(fraction);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, true);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, false);
    }

    private void verifyReservoirSamplerWithReplacement(int numSamplers, boolean sampleOnPartitions) {
        ReservoirSamplerWithReplacement sampler = new ReservoirSamplerWithReplacement(numSamplers);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, true, sampleOnPartitions);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, false, sampleOnPartitions);
    }

    private void verifyReservoirSamplerWithoutReplacement(int numSamplers, boolean sampleOnPartitions) {
        ReservoirSamplerWithoutReplacement sampler = new ReservoirSamplerWithoutReplacement(numSamplers);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, true, sampleOnPartitions);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, false, sampleOnPartitions);
    }

    private void verifyRandomSamplerWithFraction(double fraction, RandomSampler<Double> sampler, boolean withDefaultSampler) {
        double[] baseSample = withDefaultSampler ? this.getDefaultSampler(fraction) : this.getWrongSampler(fraction);
        this.verifyKSTest(sampler, baseSample, withDefaultSampler);
    }

    private void verifyRandomSamplerWithSampleSize(int sampleSize, RandomSampler<Double> sampler, boolean withDefaultSampler, boolean sampleWithPartitions) {
        double[] baseSample = withDefaultSampler ? this.getDefaultSampler(sampleSize) : this.getWrongSampler(sampleSize);
        this.verifyKSTest(sampler, baseSample, withDefaultSampler, sampleWithPartitions);
    }

    private void verifyKSTest(RandomSampler<Double> sampler, double[] defaultSampler, boolean expectSuccess) {
        this.verifyKSTest(sampler, defaultSampler, expectSuccess, false);
    }

    private void verifyKSTest(RandomSampler<Double> sampler, double[] defaultSampler, boolean expectSuccess, boolean sampleOnPartitions) {
        double[] sampled = this.getSampledOutput(sampler, sampleOnPartitions);
        double pValue = ksTest.kolmogorovSmirnovStatistic(sampled, defaultSampler);
        double dValue = this.getDValue(sampled.length, defaultSampler.length);
        if (expectSuccess) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)pValue).as(String.format("KS test result with p value(%f), d value(%f)", pValue, dValue), new Object[0])).isLessThanOrEqualTo(dValue);
        } else {
            ((AbstractDoubleAssert)Assertions.assertThat((double)pValue).as(String.format("KS test result with p value(%f), d value(%f)", pValue, dValue), new Object[0])).isGreaterThan(dValue);
        }
    }

    private double[] getSampledOutput(RandomSampler<Double> sampler, boolean sampleOnPartitions) {
        Iterator sampled;
        if (sampleOnPartitions) {
            DistributedRandomSampler reservoirRandomSampler = (DistributedRandomSampler)sampler;
            LinkedList intermediateResult = new LinkedList();
            for (int i = 0; i < 10; ++i) {
                Iterator partialIntermediateResult = reservoirRandomSampler.sampleInPartition(this.sourcePartitions[i].iterator());
                while (partialIntermediateResult.hasNext()) {
                    intermediateResult.add(partialIntermediateResult.next());
                }
            }
            sampled = reservoirRandomSampler.sampleInCoordinator(intermediateResult.iterator());
        } else {
            sampled = sampler.sample(source.iterator());
        }
        ArrayList<Double> list = new ArrayList<Double>();
        while (sampled.hasNext()) {
            list.add((Double)sampled.next());
        }
        return this.transferFromListToArrayWithOrder(list);
    }

    private double[] transferFromListToArrayWithOrder(List<Double> list) {
        Collections.sort(list);
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    private double[] getDefaultSampler(double fraction) {
        Preconditions.checkArgument((fraction > 0.0 ? 1 : 0) != 0, (Object)"Sample fraction should be positive.");
        int size = (int)(10000.0 * fraction);
        double step = 1.0 / fraction;
        double[] defaultSampler = new double[size];
        for (int i = 0; i < size; ++i) {
            defaultSampler[i] = Math.round(step * (double)i);
        }
        return defaultSampler;
    }

    private double[] getDefaultSampler(int fixSize) {
        Preconditions.checkArgument((fixSize > 0 ? 1 : 0) != 0, (Object)"Sample fraction should be positive.");
        double step = 10000.0 / (double)fixSize;
        double[] defaultSampler = new double[fixSize];
        for (int i = 0; i < fixSize; ++i) {
            defaultSampler[i] = Math.round(step * (double)i);
        }
        return defaultSampler;
    }

    private double[] getWrongSampler(double fraction) {
        Preconditions.checkArgument((fraction > 0.0 ? 1 : 0) != 0, (Object)"Sample size should be positive.");
        int size = (int)(10000.0 * fraction);
        int halfSourceSize = 5000;
        double[] wrongSampler = new double[size];
        for (int i = 0; i < size; ++i) {
            wrongSampler[i] = (double)i % (double)halfSourceSize;
        }
        return wrongSampler;
    }

    private double[] getWrongSampler(int fixSize) {
        Preconditions.checkArgument((fixSize > 0 ? 1 : 0) != 0, (Object)"Sample size be positive.");
        int halfSourceSize = 5000;
        double[] wrongSampler = new double[fixSize];
        for (int i = 0; i < fixSize; ++i) {
            wrongSampler[i] = (double)i % (double)halfSourceSize;
        }
        return wrongSampler;
    }

    private double getDValue(int m, int n) {
        Preconditions.checkArgument((m > 0 ? 1 : 0) != 0, (Object)"input sample size should be positive.");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"input sample size should be positive.");
        return 1.95 * Math.sqrt(((double)m + (double)n) / ((double)m * (double)n));
    }
}

