/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReduceTranslationTests
implements Serializable {
    ReduceTranslationTests() {
    }

    @Test
    void translateNonGroupedReduce() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            initialData.reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((reducer.getKeyColumns(0) == null || reducer.getKeyColumns(0).length == 0 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((reducer.getParallelism() == 1 || reducer.getParallelism() == -1 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateGroupedReduceNoMapper() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            initialData.groupBy(new int[]{2}).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((int)reducer.getParallelism()).isIn(new Object[]{8, -1});
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{2});
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateGroupedReduceWithkeyExtractor() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = ReduceTranslationTests.getSourceDataSet((ExecutionEnvironment)env);
            ((ReduceOperator)initialData.groupBy((KeySelector)new KeySelector<Tuple3<Double, StringValue, LongValue>, StringValue>(){

                public StringValue getKey(Tuple3<Double, StringValue, LongValue> value) {
                    return (StringValue)value.f1;
                }
            }).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Double, StringValue, LongValue>>(){

                public Tuple3<Double, StringValue, LongValue> reduce(Tuple3<Double, StringValue, LongValue> value1, Tuple3<Double, StringValue, LongValue> value2) {
                    return value1;
                }
            }).setParallelism(4)).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            MapOperatorBase keyProjector = (MapOperatorBase)sink.getInput();
            PlanUnwrappingReduceOperator reducer = (PlanUnwrappingReduceOperator)keyProjector.getInput();
            MapOperatorBase keyExtractor = (MapOperatorBase)reducer.getInput();
            Assertions.assertThat((int)keyExtractor.getParallelism()).isOne();
            Assertions.assertThat((int)reducer.getParallelism()).isEqualTo(4);
            Assertions.assertThat((int)keyProjector.getParallelism()).isEqualTo(4);
            TupleTypeInfo keyValueInfo = new TupleTypeInfo(new TypeInformation[]{new ValueTypeInfo(StringValue.class), initialData.getType()});
            Assertions.assertThat((Object)keyExtractor.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)keyExtractor.getOperatorInfo().getOutputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)keyProjector.getOperatorInfo().getInputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)keyProjector.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Class)keyExtractor.getUserCodeWrapper().getUserCodeClass()).isEqualTo(KeyExtractingMapper.class);
            Assertions.assertThat((Object)keyExtractor.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    private static DataSet<Tuple3<Double, StringValue, LongValue>> getSourceDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)new LongValue(77L))}).setParallelism(1);
    }
}

