/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.LongSumAggregator;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DeltaIterationTranslationTest
implements Serializable {
    DeltaIterationTranslationTest() {
    }

    @Test
    void testCorrectTranslation() {
        try {
            String jobName = "Test JobName";
            String iterationName = "Test Name";
            String beforeNextWorksetMap = "Some Mapper";
            String aggregatorName = "AggregatorName";
            int[] iterationKeys = new int[]{2};
            int numIterations = 13;
            int defaultParallelism = 133;
            int iterationParallelism = 77;
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(133);
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 13, iterationKeys);
            iteration.name("Test Name").parallelism(77);
            iteration.registerAggregator("AggregatorName", (Aggregator)new LongSumAggregator());
            JoinOperator.ProjectJoin worksetSelfJoin = iteration.getWorkset().map(new IdentityMapper()).join((DataSet)iteration.getWorkset()).where(new int[]{1}).equalTo(new int[]{1}).projectFirst(new int[]{0, 1});
            JoinOperator.EquiJoin joined = worksetSelfJoin.join((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2}).with((JoinFunction)new SolutionWorksetJoin());
            DataSet result = iteration.closeWith((DataSet)joined, (DataSet)joined.map((MapFunction)new NextWorksetMapper()).name("Some Mapper"));
            result.output((OutputFormat)new DiscardingOutputFormat());
            result.writeAsText("/dev/null");
            Plan p = env.createProgramPlan("Test JobName");
            Assertions.assertThat((String)p.getJobName()).isEqualTo("Test JobName");
            Assertions.assertThat((int)p.getDefaultParallelism()).isEqualTo(133);
            Iterator sinks = p.getDataSinks().iterator();
            GenericDataSinkBase sink1 = (GenericDataSinkBase)sinks.next();
            GenericDataSinkBase sink2 = (GenericDataSinkBase)sinks.next();
            DeltaIterationBase iteration2 = (DeltaIterationBase)sink1.getInput();
            Assertions.assertThat((Object)sink2.getInput()).isEqualTo((Object)iteration2);
            Assertions.assertThat((int)iteration2.getMaximumNumberOfIterations()).isEqualTo(13);
            Assertions.assertThat((int[])iteration2.getSolutionSetKeyFields()).containsExactly(iterationKeys);
            Assertions.assertThat((int)iteration2.getParallelism()).isEqualTo(77);
            Assertions.assertThat((String)iteration2.getName()).isEqualTo("Test Name");
            MapOperatorBase nextWorksetMapper = (MapOperatorBase)iteration2.getNextWorkset();
            InnerJoinOperatorBase solutionSetJoin = (InnerJoinOperatorBase)iteration2.getSolutionSetDelta();
            InnerJoinOperatorBase worksetSelfJoin2 = (InnerJoinOperatorBase)solutionSetJoin.getFirstInput();
            MapOperatorBase worksetMapper = (MapOperatorBase)worksetSelfJoin2.getFirstInput();
            Assertions.assertThat((Class)worksetMapper.getUserCodeWrapper().getUserCodeClass()).isEqualTo(IdentityMapper.class);
            Assertions.assertThat((Class)nextWorksetMapper.getUserCodeWrapper().getUserCodeClass()).isEqualTo(NextWorksetMapper.class);
            if (solutionSetJoin.getUserCodeWrapper().getUserCodeObject() instanceof WrappingFunction) {
                WrappingFunction wf = (WrappingFunction)solutionSetJoin.getUserCodeWrapper().getUserCodeObject();
                Assertions.assertThat(wf.getWrappedFunction().getClass()).isEqualTo(SolutionWorksetJoin.class);
            } else {
                Assertions.assertThat((Class)solutionSetJoin.getUserCodeWrapper().getUserCodeClass()).isEqualTo(SolutionWorksetJoin.class);
            }
            Assertions.assertThat((String)nextWorksetMapper.getName()).isEqualTo("Some Mapper");
            Assertions.assertThat((String)((AggregatorWithName)iteration2.getAggregators().getAllRegisteredAggregators().iterator().next()).getName()).isEqualTo("AggregatorName");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testRejectWhenSolutionSetKeysDontMatchJoin() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 10, new int[]{1});
            try {
                iteration.getWorkset().join((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2});
                Assertions.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {
                // empty catch block
            }
            try {
                iteration.getSolutionSet().join((DataSet)iteration.getWorkset()).where(new int[]{2}).equalTo(new int[]{1});
                Assertions.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testRejectWhenSolutionSetKeysDontMatchCoGroup() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource initialSolutionSet = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.44, (Object)5L, (Object)"abc")});
            DataSource initialWorkSet = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)1.23, (Object)"abc")});
            DeltaIteration iteration = initialSolutionSet.iterateDelta((DataSet)initialWorkSet, 10, new int[]{1});
            try {
                iteration.getWorkset().coGroup((DataSet)iteration.getSolutionSet()).where(new int[]{1}).equalTo(new int[]{2}).with((CoGroupFunction)new SolutionWorksetCoGroup1());
                Assertions.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {
                // empty catch block
            }
            try {
                iteration.getSolutionSet().coGroup((DataSet)iteration.getWorkset()).where(new int[]{2}).equalTo(new int[]{1}).with((CoGroupFunction)new SolutionWorksetCoGroup2());
                Assertions.fail((String)"Accepted invalid program.");
            }
            catch (InvalidProgramException invalidProgramException) {}
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static class SolutionWorksetCoGroup2
    extends RichCoGroupFunction<Tuple3<Double, Long, String>, Tuple2<Double, String>, Tuple3<Double, Long, String>> {
        private SolutionWorksetCoGroup2() {
        }

        public void coGroup(Iterable<Tuple3<Double, Long, String>> second, Iterable<Tuple2<Double, String>> first, Collector<Tuple3<Double, Long, String>> out) {
        }
    }

    private static class SolutionWorksetCoGroup1
    extends RichCoGroupFunction<Tuple2<Double, String>, Tuple3<Double, Long, String>, Tuple3<Double, Long, String>> {
        private SolutionWorksetCoGroup1() {
        }

        public void coGroup(Iterable<Tuple2<Double, String>> first, Iterable<Tuple3<Double, Long, String>> second, Collector<Tuple3<Double, Long, String>> out) {
        }
    }

    private static class IdentityMapper<T>
    extends RichMapFunction<T, T> {
        private IdentityMapper() {
        }

        public T map(T value) throws Exception {
            return value;
        }
    }

    private static class NextWorksetMapper
    extends RichMapFunction<Tuple3<Double, Long, String>, Tuple2<Double, String>> {
        private NextWorksetMapper() {
        }

        public Tuple2<Double, String> map(Tuple3<Double, Long, String> value) {
            return null;
        }
    }

    private static class SolutionWorksetJoin
    extends RichJoinFunction<Tuple2<Double, String>, Tuple3<Double, Long, String>, Tuple3<Double, Long, String>> {
        private SolutionWorksetJoin() {
        }

        public Tuple3<Double, Long, String> join(Tuple2<Double, String> first, Tuple3<Double, Long, String> second) {
            return null;
        }
    }
}

