/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.lang.reflect.Method;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperatorTest {
    OperatorTest() {
    }

    @Test
    void testConfigurationOfParallelism() {
        MockOperator operator = new MockOperator();
        int parallelism = 36;
        operator.setParallelism(parallelism);
        Assertions.assertThat((int)operator.getParallelism()).isEqualTo(parallelism);
        parallelism = -1;
        operator.setParallelism(parallelism);
        Assertions.assertThat((int)operator.getParallelism()).isEqualTo(parallelism);
    }

    @Test
    void testConfigurationOfResource() throws Exception {
        MockOperator operator = new MockOperator();
        Method opMethod = Operator.class.getDeclaredMethod("setResources", ResourceSpec.class, ResourceSpec.class);
        opMethod.setAccessible(true);
        ResourceSpec minResources = ResourceSpec.newBuilder((double)1.0, (int)100).build();
        ResourceSpec preferredResources = ResourceSpec.newBuilder((double)2.0, (int)200).build();
        opMethod.invoke((Object)operator, minResources, preferredResources);
        Assertions.assertThat((Object)operator.getMinResources()).isEqualTo((Object)minResources);
        Assertions.assertThat((Object)operator.getPreferredResources()).isEqualTo((Object)preferredResources);
    }

    private class MockOperator
    extends Operator {
        public MockOperator() {
            super((ExecutionEnvironment)ExecutionEnvironment.createCollectionsEnvironment(), (TypeInformation)ValueTypeInfo.NULL_VALUE_TYPE_INFO);
        }
    }
}

