/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MinByOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();

    MinByOperatorTest() {
    }

    @Test
    void testMinByKeyFieldsDataset() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.minBy(new int[]{4, 0, 1, 2, 3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCustomKeyFieldsDataset() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        DataSource customDs = env.fromCollection(this.customTypeData);
        Assertions.assertThatThrownBy(() -> MinByOperatorTest.lambda$testCustomKeyFieldsDataset$0((DataSet)customDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testOutOfTupleBoundsDataset1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> MinByOperatorTest.lambda$testOutOfTupleBoundsDataset1$1((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testOutOfTupleBoundsDataset2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> MinByOperatorTest.lambda$testOutOfTupleBoundsDataset2$2((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testOutOfTupleBoundsDataset3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> MinByOperatorTest.lambda$testOutOfTupleBoundsDataset3$3((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMinByKeyFieldsGrouping() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        try {
            groupDs.minBy(new int[]{4, 0, 1, 2, 3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCustomKeyFieldsGrouping() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        this.customTypeData.add(new CustomType());
        Assertions.assertThatThrownBy(() -> {
            UnsortedGrouping groupDs = env.fromCollection(this.customTypeData).groupBy(new int[]{0});
            groupDs.minBy(new int[]{0});
        }).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testOutOfTupleBoundsGrouping1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        Assertions.assertThatThrownBy(() -> groupDs.minBy(new int[]{5})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testOutOfTupleBoundsGrouping2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        Assertions.assertThatThrownBy(() -> groupDs.minBy(new int[]{-1})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testOutOfTupleBoundsGrouping3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        UnsortedGrouping groupDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo).groupBy(new int[]{0});
        Assertions.assertThatThrownBy(() -> groupDs.minBy(new int[]{1, 2, 3, 4, -1})).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMinByRowTypeInfoKeyFieldsDataset() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        TypeInformation[] types = new TypeInformation[]{Types.INT, Types.INT};
        String[] fieldNames = new String[]{"id", "value"};
        RowTypeInfo rowTypeInfo = new RowTypeInfo(types, fieldNames);
        DataSource tupleDs = env.fromCollection(Collections.singleton(new Row(2)), (TypeInformation)rowTypeInfo);
        Assertions.assertThatThrownBy(() -> MinByOperatorTest.lambda$testMinByRowTypeInfoKeyFieldsDataset$8((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testMinByRowTypeInfoKeyFieldsForUnsortedGrouping() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        TypeInformation[] types = new TypeInformation[]{Types.INT, Types.INT};
        String[] fieldNames = new String[]{"id", "value"};
        RowTypeInfo rowTypeInfo = new RowTypeInfo(types, fieldNames);
        UnsortedGrouping groupDs = env.fromCollection(Collections.singleton(new Row(2)), (TypeInformation)rowTypeInfo).groupBy(new int[]{0});
        Assertions.assertThatThrownBy(() -> groupDs.minBy(new int[]{1})).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testMinByRowTypeInfoKeyFieldsDataset$8(DataSet tupleDs) throws Throwable {
        tupleDs.minBy(new int[]{0});
    }

    private static /* synthetic */ void lambda$testOutOfTupleBoundsDataset3$3(DataSet tupleDs) throws Throwable {
        tupleDs.minBy(new int[]{1, 2, 3, 4, -1});
    }

    private static /* synthetic */ void lambda$testOutOfTupleBoundsDataset2$2(DataSet tupleDs) throws Throwable {
        tupleDs.minBy(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testOutOfTupleBoundsDataset1$1(DataSet tupleDs) throws Throwable {
        tupleDs.minBy(new int[]{5});
    }

    private static /* synthetic */ void lambda$testCustomKeyFieldsDataset$0(DataSet customDs) throws Throwable {
        customDs.minBy(new int[]{0});
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

