/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FirstNOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    FirstNOperatorTest() {
    }

    @Test
    void testUngroupedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.first(1);
        tupleDs.first(10);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testUngroupedFirstN$0((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testUngroupedFirstN$1((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{2}).first(1);
        tupleDs.groupBy(new int[]{1, 3}).first(10);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testGroupedFirstN$2((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testGroupedFirstN$3((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testGroupedSortedFirstN() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.groupBy(new int[]{2}).sortGroup(4, Order.ASCENDING).first(1);
        tupleDs.groupBy(new int[]{1, 3}).sortGroup(4, Order.ASCENDING).first(10);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testGroupedSortedFirstN$4((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
        Assertions.assertThatThrownBy(() -> FirstNOperatorTest.lambda$testGroupedSortedFirstN$5((DataSet)tupleDs)).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testGroupedSortedFirstN$5(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{2}).sortGroup(4, Order.ASCENDING).first(-1);
    }

    private static /* synthetic */ void lambda$testGroupedSortedFirstN$4(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{0}).sortGroup(4, Order.ASCENDING).first(0);
    }

    private static /* synthetic */ void lambda$testGroupedFirstN$3(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{2}).first(-1);
    }

    private static /* synthetic */ void lambda$testGroupedFirstN$2(DataSet tupleDs) throws Throwable {
        tupleDs.groupBy(new int[]{0}).first(0);
    }

    private static /* synthetic */ void lambda$testUngroupedFirstN$1(DataSet tupleDs) throws Throwable {
        tupleDs.first(-1);
    }

    private static /* synthetic */ void lambda$testUngroupedFirstN$0(DataSet tupleDs) throws Throwable {
        tupleDs.first(0);
    }
}

