/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DataSinkTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<CustomType> pojoData = new ArrayList<CustomType>();

    DataSinkTest() {
    }

    @BeforeEach
    void fillPojoData() {
        if (this.pojoData.isEmpty()) {
            this.pojoData.add(new CustomType());
        }
    }

    @Test
    void testTupleSingleOrderIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ANY);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testTupleTwoOrderIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ASCENDING).sortLocalOutput(3, Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testTupleSingleOrderExp() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("f0", Order.ANY);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    void testTupleSingleOrderExpFull() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ANY);
    }

    @Test
    void testTupleTwoOrderExp() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("f1", Order.ASCENDING).sortLocalOutput("f4", Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testTupleTwoOrderMixed() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(4, Order.ASCENDING).sortLocalOutput("f2", Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testFailTupleIndexOutOfBounds() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailTupleIndexOutOfBounds$0((DataSet)tupleDs)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testFailTupleInv() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailTupleInv$1((DataSet)tupleDs)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testPrimitiveOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        try {
            longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testFailPrimitiveOrder1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailPrimitiveOrder1$2((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testFailPrimitiveOrder2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailPrimitiveOrder2$3((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testFailPrimitiveOrder3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailPrimitiveOrder3$4((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testPojoSingleOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        try {
            pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myString", Order.ASCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testPojoTwoOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        try {
            pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myLong", Order.ASCENDING).sortLocalOutput("myString", Order.DESCENDING);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testFailPojoIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailPojoIdx$5((DataSet)pojoDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testFailPojoInvalidField() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testFailPojoInvalidField$6((DataSet)pojoDs)).isInstanceOf(CompositeType.InvalidFieldReferenceException.class);
    }

    @Test
    void testPojoSingleOrderFull() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testPojoSingleOrderFull$7((DataSet)pojoDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testArrayOrderFull() {
        ArrayList<Object[]> arrayData = new ArrayList<Object[]>();
        arrayData.add(new Object[0]);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(arrayData);
        Assertions.assertThatThrownBy(() -> DataSinkTest.lambda$testArrayOrderFull$8((DataSet)pojoDs)).isInstanceOf(InvalidProgramException.class);
    }

    private static /* synthetic */ void lambda$testArrayOrderFull$8(DataSet pojoDs) throws Throwable {
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testPojoSingleOrderFull$7(DataSet pojoDs) throws Throwable {
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testFailPojoInvalidField$6(DataSet pojoDs) throws Throwable {
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myInt", Order.ASCENDING).sortLocalOutput("notThere", Order.DESCENDING);
    }

    private static /* synthetic */ void lambda$testFailPojoIdx$5(DataSet pojoDs) throws Throwable {
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(1, Order.DESCENDING);
    }

    private static /* synthetic */ void lambda$testFailPrimitiveOrder3$4(DataSet longDs) throws Throwable {
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("nope", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testFailPrimitiveOrder2$3(DataSet longDs) throws Throwable {
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("0", Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testFailPrimitiveOrder1$2(DataSet longDs) throws Throwable {
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ASCENDING);
    }

    private static /* synthetic */ void lambda$testFailTupleInv$1(DataSet tupleDs) throws Throwable {
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("notThere", Order.ASCENDING).sortLocalOutput("f4", Order.DESCENDING);
    }

    private static /* synthetic */ void lambda$testFailTupleIndexOutOfBounds$0(DataSet tupleDs) throws Throwable {
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(3, Order.ASCENDING).sortLocalOutput(5, Order.DESCENDING);
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

