/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operator.JoinOperatorTest;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class CoGroupOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<JoinOperatorTest.CustomType> customTypeData = new ArrayList<JoinOperatorTest.CustomType>();

    CoGroupOperatorTest() {
    }

    @BeforeAll
    static void insertCustomData() {
        customTypeData.add(new JoinOperatorTest.CustomType());
    }

    @Test
    void testCoGroupKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyFields2$0((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyFields3$1((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyFields4$2((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCoGroupKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyFields5$3((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testCoGroupKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyFields6$4((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions2$5((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions3$6((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions4$7((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCoGroupKeyAtomicExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"*"});
    }

    @Test
    void testCoGroupKeyAtomicExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"*"}).equalTo(new String[]{"myInt"});
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression1$8((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression2$9((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression3$10((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression4$11((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression5$12((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyAtomicInvalidExpression6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyAtomicInvalidExpression6$13((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions2Nested$14((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions3Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions3Nested$15((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyExpressions4Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyExpressions4Nested$16((DataSet)ds1, (DataSet)ds2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCoGroupKeySelectors1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo((KeySelector & Serializable)value -> value.myLong);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyMixing1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector & Serializable)value -> value.myLong).equalTo(new int[]{3});
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyMixing2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{3}).equalTo((KeySelector & Serializable)value -> value.myLong);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testCoGroupKeyMixing3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyMixing3$17((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testCoGroupKeyMixing4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        Assertions.assertThatThrownBy(() -> CoGroupOperatorTest.lambda$testCoGroupKeyMixing4$18((DataSet)ds1, (DataSet)ds2)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testSemanticPropsWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        CoGroupOperator coGroupOp = tupleDs1.coGroup((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((CoGroupFunction)new DummyTestCoGroupFunction1());
        DualInputSemanticProperties semProps = coGroupOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 2)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 6)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 4, 6});
        Assertions.assertThat((Iterable)semProps.getReadFields(1)).containsExactly((Object[])new Integer[]{5, 3});
    }

    @Test
    void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        CoGroupOperator coGroupOp = (CoGroupOperator)((CoGroupOperator)tupleDs1.coGroup((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((CoGroupFunction)new DummyTestCoGroupFunction2()).withForwardedFieldsFirst(new String[]{"2;4->0"})).withForwardedFieldsSecond(new String[]{"0->4;1;1->3"});
        DualInputSemanticProperties semProps = coGroupOp.getSemanticProperties();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(0, 6)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 3)).containsExactly((Object[])new Integer[]{1, 3});
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 4)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getForwardingTargetFields(1, 6)).isEmpty();
        Assertions.assertThat((Iterable)semProps.getReadFields(0)).containsExactly((Object[])new Integer[]{2, 3, 4});
        Assertions.assertThat((Iterable)semProps.getReadFields(1)).isNull();
    }

    private static /* synthetic */ void lambda$testCoGroupKeyMixing4$18(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{1, 3}).equalTo((KeySelector & Serializable)value -> value.myLong);
    }

    private static /* synthetic */ void lambda$testCoGroupKeyMixing3$17(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{2}).equalTo((KeySelector & Serializable)value -> value.myLong);
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions4Nested$16(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"nested.myNonExistent"}).equalTo(new String[]{"nested.myInt"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions3Nested$15(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"nested.myInt", "nested.myString"}).equalTo(new String[]{"nested.myString"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions2Nested$14(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myString"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression6$13(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression5$12(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"*"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression4$11(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"myInt"}).equalTo(new String[]{"*", "invalidKey"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression3$10(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"myInt"}).equalTo(new String[]{"invalidKey"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression2$9(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"invalidKey"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyAtomicInvalidExpression1$8(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"*", "invalidKey"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions4$7(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"myNonExistent"}).equalTo(new String[]{"myInt"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions3$6(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"myInt", "myString"}).equalTo(new String[]{"myString"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyExpressions2$5(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myString"});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyFields6$4(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{4}).equalTo(new int[]{0});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyFields5$3(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{-1}).equalTo(new int[]{-1});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyFields4$2(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyFields3$1(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{0, 1}).equalTo(new int[]{2});
    }

    private static /* synthetic */ void lambda$testCoGroupKeyFields2$0(DataSet ds1, DataSet ds2) throws Throwable {
        ds1.coGroup(ds2).where(new int[]{0}).equalTo(new int[]{2});
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"0;1;2"})
    private static class DummyTestCoGroupFunction2
    implements CoGroupFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyTestCoGroupFunction2() {
        }

        public void coGroup(Iterable<Tuple5<Integer, Long, String, Long, Integer>> first, Iterable<Tuple5<Integer, Long, String, Long, Integer>> second, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->4;1;1->3"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"2;4->0"})
    @FunctionAnnotation.ReadFieldsFirst(value={"0;2;4"})
    @FunctionAnnotation.ReadFieldsSecond(value={"1;3"})
    private static class DummyTestCoGroupFunction1
    implements CoGroupFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        private DummyTestCoGroupFunction1() {
        }

        public void coGroup(Iterable<Tuple5<Integer, Long, String, Long, Integer>> first, Iterable<Tuple5<Integer, Long, String, Long, Integer>> second, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    private static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        private DummyTestKeySelector() {
        }

        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }
}

