/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregateOperatorTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();

    AggregateOperatorTest() {
    }

    @Test
    void testFieldsAggregate() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.aggregate(Aggregations.SUM, 1);
        Assertions.assertThatThrownBy(() -> AggregateOperatorTest.lambda$testFieldsAggregate$0((DataSet)tupleDs)).isInstanceOf(IllegalArgumentException.class);
        DataSource longDs = env.fromCollection(this.emptyLongData, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThatThrownBy(() -> AggregateOperatorTest.lambda$testFieldsAggregate$1((DataSet)longDs)).isInstanceOf(InvalidProgramException.class);
    }

    @Test
    void testAggregationTypes() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
            tupleDs.aggregate(Aggregations.SUM, 0).and(Aggregations.MIN, 4);
            tupleDs.aggregate(Aggregations.MIN, 2).aggregate(Aggregations.SUM, 1);
            Assertions.assertThatThrownBy(() -> AggregateOperatorTest.lambda$testAggregationTypes$2((DataSet)tupleDs)).isInstanceOf(UnsupportedAggregationTypeException.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static /* synthetic */ void lambda$testAggregationTypes$2(DataSet tupleDs) throws Throwable {
        tupleDs.aggregate(Aggregations.SUM, 2);
    }

    private static /* synthetic */ void lambda$testFieldsAggregate$1(DataSet longDs) throws Throwable {
        longDs.aggregate(Aggregations.MIN, 1);
    }

    private static /* synthetic */ void lambda$testFieldsAggregate$0(DataSet tupleDs) throws Throwable {
        tupleDs.aggregate(Aggregations.SUM, 10);
    }
}

