/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrintingOutputFormatTest {
    private final PrintStream originalSystemOut = System.out;
    private final PrintStream originalSystemErr = System.err;
    private final ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
    private final ByteArrayOutputStream arrayErrorStream = new ByteArrayOutputStream();
    private final String line = System.lineSeparator();

    PrintingOutputFormatTest() {
    }

    @BeforeEach
    void setUp() {
        System.setOut(new PrintStream(this.arrayOutputStream));
        System.setErr(new PrintStream(this.arrayErrorStream));
    }

    @AfterEach
    void tearDown() {
        if (System.out != this.originalSystemOut) {
            System.out.close();
        }
        if (System.err != this.originalSystemErr) {
            System.err.close();
        }
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    @Test
    void testPrintOutputFormatStdOut() {
        PrintingOutputFormat printSink = new PrintingOutputFormat();
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintOutputFormatStdErr() {
        PrintingOutputFormat printSink = new PrintingOutputFormat(true);
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assertions.assertThat((Object)printSink).hasToString("Print to System.err");
        Assertions.assertThat((Object)this.arrayErrorStream).hasToString("hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintOutputFormatWithPrefix() {
        PrintingOutputFormat printSink = new PrintingOutputFormat();
        printSink.open(1, 2);
        printSink.writeRecord((Object)"hello world!");
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("2> hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintOutputFormatWithIdentifierAndPrefix() {
        PrintingOutputFormat printSink = new PrintingOutputFormat("mySink", false);
        printSink.open(1, 2);
        printSink.writeRecord((Object)"hello world!");
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink:2> hello world!" + this.line);
        printSink.close();
    }

    @Test
    void testPrintOutputFormatWithIdentifierButNoPrefix() {
        PrintingOutputFormat printSink = new PrintingOutputFormat("mySink", false);
        printSink.open(0, 1);
        printSink.writeRecord((Object)"hello world!");
        Assertions.assertThat((Object)printSink).hasToString("Print to System.out");
        Assertions.assertThat((Object)this.arrayOutputStream).hasToString("mySink> hello world!" + this.line);
        printSink.close();
    }
}

