/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeExtractionTest {
    TypeExtractionTest() {
    }

    @Test
    void testFunctionWithMissingGenericsAndReturns() {
        RichMapFunction function = new RichMapFunction(){
            private static final long serialVersionUID = 1L;

            public Object map(Object value) throws Exception {
                return null;
            }
        };
        TypeInformation info = ExecutionEnvironment.getExecutionEnvironment().fromElements((Object[])new String[]{"arbitrary", "data"}).map((MapFunction)function).returns(Types.STRING).getResultType();
        Assertions.assertThat((Object)info).isEqualTo((Object)Types.STRING);
    }

    @Test
    void testGetterSetterWithVertex() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.fromElements((Object[])new VertexTyped[]{new VertexTyped(0L, 3.0), new VertexTyped(1L, 1.0)});
    }

    public static class VertexTyped
    extends Vertex<Long, Double> {
        public VertexTyped(Long l, Double d) {
            super(l, d);
        }

        public VertexTyped() {
        }
    }

    public static class Vertex<K, V> {
        private K key1;
        private K key2;
        private V value;

        public Vertex() {
        }

        public Vertex(K key, V value) {
            this.key1 = key;
            this.key2 = key;
            this.value = value;
        }

        public Vertex(K key1, K key2, V value) {
            this.key1 = key1;
            this.key2 = key2;
            this.value = value;
        }

        public void setKey1(K key1) {
            this.key1 = key1;
        }

        public void setKey2(K key2) {
            this.key2 = key2;
        }

        public K getKey1() {
            return this.key1;
        }

        public K getKey2() {
            return this.key2;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }
}

