/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.util.Collection;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.Operator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultipleInvokationsTest {
    MultipleInvokationsTest() {
    }

    @Test
    void testMultipleInvocationsGetPlan() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            Operator data = env.fromElements((Object[])new String[]{"Some", "test", "data"}).name("source1");
            data.output((OutputFormat)new DiscardingOutputFormat()).name("print1");
            data.output((OutputFormat)new DiscardingOutputFormat()).name("output1");
            Plan p = env.createProgramPlan();
            Assertions.assertThat((Collection)p.getDataSinks()).hasSize(2);
            for (GenericDataSinkBase sink : p.getDataSinks()) {
                Assertions.assertThat((String)sink.getName()).isIn(new Object[]{"print1", "output1"});
                Assertions.assertThat((String)sink.getInput().getName()).isEqualTo("source1");
            }
            data.writeAsText("/some/file/path").name("textsink");
            p = env.createProgramPlan();
            Assertions.assertThat((Collection)p.getDataSinks()).hasSize(1);
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            Assertions.assertThat((String)sink.getName()).isEqualTo("textsink");
            Assertions.assertThat((String)sink.getInput().getName()).isEqualTo("source1");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

