/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCrossFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.configuration.Configuration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionExecutionWithBroadcastVariableTest {
    private static final String BC_VAR_NAME = "BC";
    private static final String[] TEST_DATA = new String[]{"A", "B", "C", "D"};
    private static final String SUFFIX = "-suffixed";

    CollectionExecutionWithBroadcastVariableTest() {
    }

    @Test
    void testUnaryOp() {
        try {
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            DataSource bcData = env.fromElements((Object[])new String[]{SUFFIX});
            ArrayList result = new ArrayList();
            ((MapOperator)env.fromElements((Object[])TEST_DATA).map((MapFunction)new SuffixAppender()).withBroadcastSet((DataSet)bcData, BC_VAR_NAME)).output((OutputFormat)new LocalCollectionOutputFormat(result));
            env.execute();
            Assertions.assertThat(result).hasSameSizeAs((Object)TEST_DATA);
            for (String s : result) {
                Assertions.assertThat((int)s.indexOf(SUFFIX)).isGreaterThan(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testBinaryOp() {
        try {
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            DataSource bcData = env.fromElements((Object[])new String[]{SUFFIX});
            DataSource inData = env.fromElements((Object[])TEST_DATA);
            ArrayList result = new ArrayList();
            ((CrossOperator)inData.cross((DataSet)inData).with((CrossFunction)new SuffixCross()).withBroadcastSet((DataSet)bcData, BC_VAR_NAME)).output((OutputFormat)new LocalCollectionOutputFormat(result));
            env.execute();
            Assertions.assertThat(result).hasSize(TEST_DATA.length * TEST_DATA.length);
            for (String s : result) {
                Assertions.assertThat((int)s.indexOf(SUFFIX)).isEqualTo(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static final class SuffixCross
    extends RichCrossFunction<String, String, String> {
        private String suffix;

        private SuffixCross() {
        }

        public void open(Configuration parameters) {
            this.suffix = (String)this.getRuntimeContext().getBroadcastVariable(CollectionExecutionWithBroadcastVariableTest.BC_VAR_NAME).get(0);
        }

        public String cross(String s1, String s2) {
            return s1 + s2 + this.suffix;
        }
    }

    private static final class SuffixAppender
    extends RichMapFunction<String, String> {
        private String suffix;

        private SuffixAppender() {
        }

        public void open(Configuration parameters) {
            this.suffix = (String)this.getRuntimeContext().getBroadcastVariable(CollectionExecutionWithBroadcastVariableTest.BC_VAR_NAME).get(0);
        }

        public String map(String value) {
            return value + this.suffix;
        }
    }
}

