/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.FloatValue;
import org.junit.Assert;

public class FloatValueSummaryAggregatorTest
extends FloatSummaryAggregatorTest {
    @Override
    protected NumericColumnSummary<Float> summarize(Float ... values) {
        FloatValue[] floatValues = new FloatValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            floatValues[i] = new FloatValue(values[i].floatValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<FloatValue, NumericColumnSummary<Float>, ValueSummaryAggregator.FloatValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Float> result1, NumericColumnSummary<Float> result2) {
                Assert.assertEquals((float)((Float)result1.getMin()).floatValue(), (float)((Float)result2.getMin()).floatValue(), (float)0.0f);
                Assert.assertEquals((float)((Float)result1.getMax()).floatValue(), (float)((Float)result2.getMax()).floatValue(), (float)0.0f);
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-10);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-10);
            }
        }.summarize(floatValues);
    }
}

