/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class TextInputFormatTest {
    @Test
    public void testSimpleRead() {
        String FIRST = "First line";
        String SECOND = "Second line";
        try {
            File tempFile = File.createTempFile("TextInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            PrintStream ps = new PrintStream(tempFile);
            ps.println("First line");
            ps.println("Second line");
            ps.close();
            TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            Assert.assertTrue((String)"expected at least one input split", (splits.length >= 1 ? 1 : 0) != 0);
            inputFormat.open(splits[0]);
            String result = "";
            Assert.assertFalse((boolean)inputFormat.reachedEnd());
            result = (String)inputFormat.nextRecord((Object)"");
            Assert.assertNotNull((String)"Expecting first record here", (Object)result);
            Assert.assertEquals((Object)"First line", (Object)result);
            Assert.assertFalse((boolean)inputFormat.reachedEnd());
            result = (String)inputFormat.nextRecord((Object)result);
            Assert.assertNotNull((String)"Expecting second record here", (Object)result);
            Assert.assertEquals((Object)"Second line", (Object)result);
            Assert.assertTrue((inputFormat.reachedEnd() || null == inputFormat.nextRecord((Object)result) ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testNestedFileRead() {
        String[] dirs = new String[]{"tmp/first/", "tmp/second/"};
        ArrayList<String> expectedFiles = new ArrayList<String>();
        try {
            for (String dir : dirs) {
                File tmpDir = new File(dir);
                if (!tmpDir.exists()) {
                    tmpDir.mkdirs();
                }
                FileInputSplit[] tempFile = File.createTempFile("TextInputFormatTest", ".tmp", tmpDir);
                tempFile.deleteOnExit();
                expectedFiles.add("file:" + tempFile.getAbsolutePath());
            }
            File parentDir = new File("tmp");
            TextInputFormat inputFormat = new TextInputFormat(new Path(parentDir.toURI().toString()));
            inputFormat.setNestedFileEnumeration(true);
            inputFormat.setNumLineSamples(10);
            Configuration config = new Configuration();
            config.setBoolean("recursive.file.enumeration", false);
            config.setString("delimited-format.numSamples", "20");
            inputFormat.configure(config);
            Assert.assertTrue((boolean)inputFormat.getNestedFileEnumeration());
            Assert.assertTrue((inputFormat.getNumLineSamples() == 10 ? 1 : 0) != 0);
            FileInputSplit[] splits = inputFormat.createInputSplits(expectedFiles.size());
            ArrayList<String> paths = new ArrayList<String>();
            for (FileInputSplit split : splits) {
                paths.add(split.getPath().toString());
            }
            Collections.sort(expectedFiles);
            Collections.sort(paths);
            for (int i = 0; i < expectedFiles.size(); ++i) {
                Assert.assertTrue((boolean)((String)expectedFiles.get(i)).equals(paths.get(i)));
            }
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testRemovingTrailingCR() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\n");
        this.testRemovingTrailingCR("|", "|");
        this.testRemovingTrailingCR("|", "\n");
    }

    private void testRemovingTrailingCR(String lineBreaker, String delimiter) {
        File tempFile = null;
        String FIRST = "First line";
        String SECOND = "Second line";
        String CONTENT = FIRST + lineBreaker + SECOND + lineBreaker;
        try {
            tempFile = File.createTempFile("TextInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(CONTENT);
            wrt.close();
            TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
            inputFormat.setFilePath(tempFile.toURI().toString());
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(delimiter);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            String result = "";
            if (delimiter.equals("\n") && (lineBreaker.equals("\n") || lineBreaker.equals("\r\n")) || lineBreaker.equals(delimiter)) {
                result = (String)inputFormat.nextRecord((Object)"");
                Assert.assertNotNull((String)"Expecting first record here", (Object)result);
                Assert.assertEquals((Object)FIRST, (Object)result);
                result = (String)inputFormat.nextRecord((Object)result);
                Assert.assertNotNull((String)"Expecting second record here", (Object)result);
                Assert.assertEquals((Object)SECOND, (Object)result);
                result = (String)inputFormat.nextRecord((Object)result);
                Assert.assertNull((String)"The input file is over", (Object)result);
            } else {
                result = (String)inputFormat.nextRecord((Object)"");
                Assert.assertNotNull((String)"Expecting first record here", (Object)result);
                Assert.assertEquals((Object)CONTENT, (Object)result);
            }
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assert.fail((String)"Test erroneous");
        }
    }
}

