/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropertiesTranslationTest {
    @Test
    public void testUnaryFunctionWildcardForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
        input.map(new WildcardForwardedMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertNotNull((Object)fw3);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fw3.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionInPlaceForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
        input.map(new IndividualForwardedMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionMovingForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new ShufflingMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertNotNull((Object)fw3);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fw3.contains(Integer.valueOf(1)));
    }

    @Test
    public void testUnaryFunctionForwardedInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new NoAnnotationMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionForwardedInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new ReadSetMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionForwardedInLine3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new ReadSetMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionAllForwardedExceptAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new AllForwardedExceptMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assert.assertNotNull((Object)fw1);
        Assert.assertNotNull((Object)fw2);
        Assert.assertTrue((boolean)fw1.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fw2.contains(Integer.valueOf(2)));
    }

    @Test
    public void testUnaryFunctionReadFieldsAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new ReadSetMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet read = semantics.getReadFields(0);
        Assert.assertNotNull((Object)read);
        Assert.assertEquals((long)2L, (long)read.size());
        Assert.assertTrue((boolean)read.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)read.contains(Integer.valueOf(2)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testUnaryForwardedOverwritingInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new WildcardForwardedMapper()).withForwardedFields(new String[]{"0->1; 2"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testUnaryForwardedOverwritingInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new AllForwardedExceptMapper()).withForwardedFields(new String[]{"0->1; 2"});
    }

    @Test
    public void testBinaryForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)"test")});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)3.1415)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
    }

    @Test
    public void testBinaryForwardedInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new NoAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1; 1->2"})).withForwardedFieldsSecond(new String[]{"1->0"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 1).contains(Integer.valueOf(0)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
    }

    @Test
    public void testBinaryForwardedInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ReadSetJoin()).withForwardedFieldsFirst(new String[]{"0->1; 1->2"})).withForwardedFieldsSecond(new String[]{"1->0"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 1).contains(Integer.valueOf(0)));
        Assert.assertNotNull((Object)semantics.getReadFields(0));
        Assert.assertNotNull((Object)semantics.getReadFields(1));
        Assert.assertEquals((long)1L, (long)semantics.getReadFields(0).size());
        Assert.assertEquals((long)1L, (long)semantics.getReadFields(1).size());
        Assert.assertTrue((boolean)semantics.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getReadFields(1).contains(Integer.valueOf(0)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
    }

    @Test
    public void testBinaryForwardedAnnotationInLineMixed1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedFirstAnnotationJoin()).withForwardedFieldsSecond(new String[]{"1"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 1));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 1));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
    }

    @Test
    public void testBinaryForwardedAnnotationInLineMixed2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedSecondAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 1));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 1));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 1).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 1).contains(Integer.valueOf(2)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
    }

    @Test
    public void testBinaryAllForwardedExceptAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(0, 2));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 0));
        Assert.assertNotNull((Object)semantics.getForwardingTargetFields(1, 1));
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)semantics.getForwardingTargetFields(1, 2).size());
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getForwardingTargetFields(1, 2).contains(Integer.valueOf(2)));
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(0, 2).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 0).size());
        Assert.assertEquals((long)0L, (long)semantics.getForwardingTargetFields(1, 1).size());
    }

    @Test
    public void testBinaryReadFieldsAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ReadSetJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assert.assertNotNull((Object)semantics.getReadFields(0));
        Assert.assertNotNull((Object)semantics.getReadFields(1));
        Assert.assertEquals((long)1L, (long)semantics.getReadFields(0).size());
        Assert.assertEquals((long)1L, (long)semantics.getReadFields(1).size());
        Assert.assertTrue((boolean)semantics.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semantics.getReadFields(1).contains(Integer.valueOf(0)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedFirstAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedSecondAnnotationJoin()).withForwardedFieldsSecond(new String[]{"0->1"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1;"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).withForwardedFieldsSecond(new String[]{"0->1;"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).withForwardedFieldsFirst(new String[]{"0->1;"});
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testBinaryForwardedOverwritingInLine6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).withForwardedFieldsSecond(new String[]{"0->1;"});
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"1"})
    @FunctionAnnotation.ReadFieldsSecond(value={"0"})
    public static class ReadSetJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.NonForwardedFieldsFirst(value={"0;2"})
    @FunctionAnnotation.NonForwardedFieldsSecond(value={"0;1"})
    public static class AllForwardedExceptJoin<X>
    implements JoinFunction<Tuple3<X, X, X>, Tuple3<X, X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> join(Tuple3<X, X, X> first, Tuple3<X, X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"1 -> 0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"1 -> 1"})
    public static class ForwardedBothAnnotationJoin<A, B, C, D>
    implements JoinFunction<Tuple2<A, B>, Tuple2<C, D>, Tuple2<B, D>> {
        public Tuple2<B, D> join(Tuple2<A, B> first, Tuple2<C, D> second) {
            return new Tuple2(first.f1, second.f1);
        }
    }

    @FunctionAnnotation.ForwardedFieldsSecond(value={"1->2"})
    public static class ForwardedSecondAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->2"})
    public static class ForwardedFirstAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    public static class NoAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ReadFields(value={"0;2"})
    public static class ReadSetMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.NonForwardedFields(value={"1"})
    public static class AllForwardedExceptMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->2;1->0;2->1"})
    public static class ShufflingMapper<X>
    implements MapFunction<Tuple3<X, X, X>, Tuple3<X, X, X>> {
        public Tuple3<X, X, X> map(Tuple3<X, X, X> value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;2"})
    public static class IndividualForwardedMapper<X, Y, Z>
    implements MapFunction<Tuple3<X, Y, Z>, Tuple3<X, Y, Z>> {
        public Tuple3<X, Y, Z> map(Tuple3<X, Y, Z> value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    public static class WildcardForwardedMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }

    public static class NoAnnotationMapper<T>
    implements MapFunction<T, T> {
        public T map(T value) {
            return value;
        }
    }
}

