/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.ShortValue;
import org.junit.Assert;

public class ShortValueSummaryAggregatorTest
extends ShortSummaryAggregatorTest {
    @Override
    protected NumericColumnSummary<Short> summarize(Integer ... values) {
        ShortValue[] shortValues = new ShortValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            shortValues[i] = new ShortValue(values[i].shortValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<ShortValue, NumericColumnSummary<Short>, ValueSummaryAggregator.ShortValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Short> result1, NumericColumnSummary<Short> result2) {
                Assert.assertEquals((long)result1.getTotalCount(), (long)result2.getTotalCount());
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getMissingCount(), (long)result2.getMissingCount());
                Assert.assertEquals((long)result1.getNonMissingCount(), (long)result2.getNonMissingCount());
                Assert.assertEquals((long)result1.getInfinityCount(), (long)result2.getInfinityCount());
                Assert.assertEquals((long)result1.getNanCount(), (long)result2.getNanCount());
                Assert.assertEquals((Object)result1.containsNull(), (Object)result2.containsNull());
                Assert.assertEquals((Object)result1.containsNonNull(), (Object)result2.containsNonNull());
                Assert.assertEquals((long)((Short)result1.getMin()).shortValue(), (long)((Short)result2.getMin()).shortValue());
                Assert.assertEquals((long)((Short)result1.getMax()).shortValue(), (long)((Short)result2.getMax()).shortValue());
                Assert.assertEquals((long)((Short)result1.getSum()).shortValue(), (long)((Short)result2.getSum()).shortValue());
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(shortValues);
    }
}

