/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.FloatSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class FloatSummaryAggregatorTest {
    @Test
    public void testAnscomesQuartetXValues() throws Exception {
        Float[] q1x = new Float[]{Float.valueOf(10.0f), Float.valueOf(8.0f), Float.valueOf(13.0f), Float.valueOf(9.0f), Float.valueOf(11.0f), Float.valueOf(14.0f), Float.valueOf(6.0f), Float.valueOf(4.0f), Float.valueOf(12.0f), Float.valueOf(7.0f), Float.valueOf(5.0f)};
        Float[] q4x = new Float[]{Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(19.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f)};
        NumericColumnSummary<Float> q1 = this.summarize(q1x);
        NumericColumnSummary<Float> q4 = this.summarize(q4x);
        Assert.assertEquals((double)9.0, (double)q1.getMean(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)q4.getMean(), (double)0.0);
        Assert.assertEquals((double)11.0, (double)q1.getVariance(), (double)1.0E-10);
        Assert.assertEquals((double)11.0, (double)q4.getVariance(), (double)1.0E-10);
        double stddev = Math.sqrt(11.0);
        Assert.assertEquals((double)stddev, (double)q1.getStandardDeviation(), (double)1.0E-10);
        Assert.assertEquals((double)stddev, (double)q4.getStandardDeviation(), (double)1.0E-10);
    }

    @Test
    public void testAnscomesQuartetYValues() throws Exception {
        Float[] q1y = new Float[]{Float.valueOf(8.04f), Float.valueOf(6.95f), Float.valueOf(7.58f), Float.valueOf(8.81f), Float.valueOf(8.33f), Float.valueOf(9.96f), Float.valueOf(7.24f), Float.valueOf(4.26f), Float.valueOf(10.84f), Float.valueOf(4.82f), Float.valueOf(5.68f)};
        Float[] q2y = new Float[]{Float.valueOf(9.14f), Float.valueOf(8.14f), Float.valueOf(8.74f), Float.valueOf(8.77f), Float.valueOf(9.26f), Float.valueOf(8.1f), Float.valueOf(6.13f), Float.valueOf(3.1f), Float.valueOf(9.13f), Float.valueOf(7.26f), Float.valueOf(4.74f)};
        Float[] q3y = new Float[]{Float.valueOf(7.46f), Float.valueOf(6.77f), Float.valueOf(12.74f), Float.valueOf(7.11f), Float.valueOf(7.81f), Float.valueOf(8.84f), Float.valueOf(6.08f), Float.valueOf(5.39f), Float.valueOf(8.15f), Float.valueOf(6.42f), Float.valueOf(5.73f)};
        Float[] q4y = new Float[]{Float.valueOf(6.58f), Float.valueOf(5.76f), Float.valueOf(7.71f), Float.valueOf(8.84f), Float.valueOf(8.47f), Float.valueOf(7.04f), Float.valueOf(5.25f), Float.valueOf(12.5f), Float.valueOf(5.56f), Float.valueOf(7.91f), Float.valueOf(6.89f)};
        NumericColumnSummary<Float> q1 = this.summarize(q1y);
        NumericColumnSummary<Float> q2 = this.summarize(q2y);
        NumericColumnSummary<Float> q3 = this.summarize(q3y);
        NumericColumnSummary<Float> q4 = this.summarize(q4y);
        Assert.assertEquals((double)7.5, (double)q1.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q2.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q3.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q4.getMean(), (double)0.001);
        Assert.assertEquals((double)4.12, (double)q1.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q2.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q3.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q4.getVariance(), (double)0.01);
    }

    @Test
    public void testIsNan() throws Exception {
        FloatSummaryAggregator ag = new FloatSummaryAggregator();
        Assert.assertFalse((boolean)ag.isNan(Float.valueOf(-1.0f)));
        Assert.assertFalse((boolean)ag.isNan(Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)ag.isNan(Float.valueOf(23.0f)));
        Assert.assertFalse((boolean)ag.isNan(Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(Float.valueOf(Float.MIN_VALUE)));
        Assert.assertTrue((boolean)ag.isNan(Float.valueOf(Float.NaN)));
    }

    @Test
    public void testIsInfinite() throws Exception {
        FloatSummaryAggregator ag = new FloatSummaryAggregator();
        Assert.assertFalse((boolean)ag.isInfinite(Float.valueOf(-1.0f)));
        Assert.assertFalse((boolean)ag.isInfinite(Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)ag.isInfinite(Float.valueOf(23.0f)));
        Assert.assertFalse((boolean)ag.isInfinite(Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(Float.valueOf(Float.MIN_VALUE)));
        Assert.assertTrue((boolean)ag.isInfinite(Float.valueOf(Float.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)ag.isInfinite(Float.valueOf(Float.NEGATIVE_INFINITY)));
    }

    @Test
    public void testMean() throws Exception {
        Assert.assertEquals((double)50.0, (double)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f)).getMean(), (double)0.0);
        Assert.assertEquals((double)33.333333, (double)this.summarize(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(100.0f)).getMean(), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)this.summarize(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), Float.valueOf(100.0f)).getMean(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f), null).getMean(), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Float[0]).getMean());
    }

    @Test
    public void testSum() throws Exception {
        Assert.assertEquals((double)100.0, (double)((Float)this.summarize(Float.valueOf(0.0f), Float.valueOf(100.0f)).getSum()).floatValue(), (double)0.0);
        Assert.assertEquals((float)15.0f, (float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)).getSum()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)((Float)this.summarize(Float.valueOf(-100.0f), Float.valueOf(0.0f), Float.valueOf(100.0f), null).getSum()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)90.0f, (float)((Float)this.summarize(Float.valueOf(-10.0f), Float.valueOf(100.0f), null).getSum()).floatValue(), (float)0.0f);
        Assert.assertNull((Object)this.summarize(new Float[0]).getSum());
    }

    @Test
    public void testMax() throws Exception {
        Assert.assertEquals((float)1001.0f, (float)((Float)this.summarize(Float.valueOf(-1000.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(50.0f), Float.valueOf(999.0f), Float.valueOf(1001.0f)).getMax()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)11.0f, (float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMax()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)11.0f, (float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), null, Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), null, Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMax()).floatValue(), (float)0.0f);
        Assert.assertNull((Object)this.summarize(new Float[0]).getMax());
    }

    @Test
    public void testMin() throws Exception {
        Assert.assertEquals((float)-1000.0f, (float)((Float)this.summarize(Float.valueOf(-1000.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(50.0f), Float.valueOf(999.0f), Float.valueOf(1001.0f)).getMin()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)-2.0f, (float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMin()).floatValue(), (float)0.0f);
        Assert.assertEquals((float)-2.0f, (float)((Float)this.summarize(Float.valueOf(1.0f), Float.valueOf(8.0f), Float.valueOf(7.0f), Float.valueOf(6.0f), Float.valueOf(9.0f), null, Float.valueOf(10.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), null, Float.valueOf(0.0f), Float.valueOf(11.0f), Float.valueOf(-2.0f), Float.valueOf(3.0f)).getMin()).floatValue(), (float)0.0f);
        Assert.assertNull((Object)this.summarize(new Float[0]).getMin());
    }

    protected NumericColumnSummary<Float> summarize(Float ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Float, NumericColumnSummary<Float>, FloatSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Float> result1, NumericColumnSummary<Float> result2) {
                Assert.assertEquals((float)((Float)result1.getMin()).floatValue(), (float)((Float)result2.getMin()).floatValue(), (float)0.0f);
                Assert.assertEquals((float)((Float)result1.getMax()).floatValue(), (float)((Float)result2.getMax()).floatValue(), (float)0.0f);
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(values);
    }
}

