/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat;
import org.apache.flink.api.java.hadoop.mapreduce.wrapper.HadoopInputSplit;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HadoopInputFormatTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testConfigure() throws Exception {
        ConfigurableDummyInputFormat inputFormat = (ConfigurableDummyInputFormat)((Object)Mockito.mock(ConfigurableDummyInputFormat.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.configure(new Configuration());
        ((ConfigurableDummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(org.apache.hadoop.conf.Configuration.class));
    }

    @Test
    public void testCreateInputSplits() throws Exception {
        DummyInputFormat inputFormat = (DummyInputFormat)((Object)Mockito.mock(DummyInputFormat.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.createInputSplits(2);
        ((DummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).getSplits((JobContext)Mockito.any(JobContext.class));
    }

    @Test
    public void testOpen() throws Exception {
        DummyInputFormat inputFormat = (DummyInputFormat)((Object)Mockito.mock(DummyInputFormat.class));
        Mockito.when(inputFormat.createRecordReader((InputSplit)Mockito.any(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn((Object)new DummyRecordReader());
        HadoopInputSplit inputSplit = (HadoopInputSplit)Mockito.mock(HadoopInputSplit.class);
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(inputFormat, Job.getInstance(), null);
        hadoopInputFormat.open(inputSplit);
        ((DummyInputFormat)((Object)Mockito.verify((Object)((Object)inputFormat), (VerificationMode)Mockito.times((int)1)))).createRecordReader((InputSplit)Mockito.any(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class));
        Assert.assertThat((Object)hadoopInputFormat.fetched, (Matcher)Is.is((Object)false));
    }

    @Test
    public void testClose() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.close();
        ((DummyRecordReader)((Object)Mockito.verify((Object)((Object)recordReader), (VerificationMode)Mockito.times((int)1)))).close();
    }

    @Test
    public void testFetchNextInitialState() throws Exception {
        DummyRecordReader recordReader = new DummyRecordReader();
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.fetchNext();
        Assert.assertThat((Object)hadoopInputFormat.fetched, (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)hadoopInputFormat.hasNext, (Matcher)Is.is((Object)false));
    }

    @Test
    public void testFetchNextRecordReaderHasNewValue() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        Mockito.when((Object)recordReader.nextKeyValue()).thenReturn((Object)true);
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        hadoopInputFormat.fetchNext();
        Assert.assertThat((Object)hadoopInputFormat.fetched, (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)hadoopInputFormat.hasNext, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testFetchNextRecordReaderThrowsException() throws Exception {
        DummyRecordReader recordReader = (DummyRecordReader)((Object)Mockito.mock(DummyRecordReader.class));
        Mockito.when((Object)recordReader.nextKeyValue()).thenThrow(new Throwable[]{new InterruptedException()});
        HadoopInputFormat<String, Long> hadoopInputFormat = this.setupHadoopInputFormat(new DummyInputFormat(), Job.getInstance(), recordReader);
        this.exception.expect(IOException.class);
        hadoopInputFormat.fetchNext();
        Assert.assertThat((Object)hadoopInputFormat.hasNext, (Matcher)Is.is((Object)true));
    }

    @Test
    public void checkTypeInformation() throws Exception {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(new DummyVoidKeyInputFormat(), Void.class, Long.class, Job.getInstance());
        TypeInformation tupleType = hadoopInputFormat.getProducedType();
        TupleTypeInfo expectedType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.VOID_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Assert.assertThat((Object)tupleType.isTupleType(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)tupleType, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)expectedType)));
    }

    private HadoopInputFormat<String, Long> setupHadoopInputFormat(InputFormat<String, Long> inputFormat, Job job, RecordReader<String, Long> recordReader) {
        HadoopInputFormat hadoopInputFormat = new HadoopInputFormat(inputFormat, String.class, Long.class, job);
        hadoopInputFormat.recordReader = recordReader;
        return hadoopInputFormat;
    }

    public class ConfigurableDummyInputFormat
    extends DummyInputFormat
    implements Configurable {
        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    public class DummyInputFormat
    extends InputFormat<String, Long> {
        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            return null;
        }

        public RecordReader<String, Long> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return new DummyRecordReader();
        }
    }

    public class DummyRecordReader
    extends RecordReader<String, Long> {
        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return false;
        }

        public String getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public Long getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void close() throws IOException {
        }
    }

    public class DummyVoidKeyInputFormat<T>
    extends FileInputFormat<Void, T> {
        public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return null;
        }
    }
}

