/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.ShortSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class ShortSummaryAggregatorTest {
    @Test
    public void testIsNan() throws Exception {
        ShortSummaryAggregator ag = new ShortSummaryAggregator();
        Assert.assertFalse((boolean)ag.isNan(Short.valueOf((short)-1)));
        Assert.assertFalse((boolean)ag.isNan(Short.valueOf((short)0)));
        Assert.assertFalse((boolean)ag.isNan(Short.valueOf((short)23)));
        Assert.assertFalse((boolean)ag.isNan(Short.valueOf((short)Short.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(Short.valueOf((short)Short.MIN_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(null));
    }

    @Test
    public void testIsInfinite() throws Exception {
        ShortSummaryAggregator ag = new ShortSummaryAggregator();
        Assert.assertFalse((boolean)ag.isInfinite(Short.valueOf((short)-1)));
        Assert.assertFalse((boolean)ag.isInfinite(Short.valueOf((short)0)));
        Assert.assertFalse((boolean)ag.isInfinite(Short.valueOf((short)23)));
        Assert.assertFalse((boolean)ag.isInfinite(Short.valueOf((short)Short.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(Short.valueOf((short)Short.MIN_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(null));
    }

    @Test
    public void testMean() throws Exception {
        Assert.assertEquals((double)50.0, (double)this.summarize(0, 100).getMean(), (double)0.0);
        Assert.assertEquals((double)33.333333, (double)this.summarize(0, 0, 100).getMean(), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)this.summarize(0, 0, 100, 100).getMean(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)this.summarize(0, 100, null).getMean(), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Integer[0]).getMean());
    }

    @Test
    public void testSum() throws Exception {
        Assert.assertEquals((long)100L, (long)((Short)this.summarize(0, 100).getSum()).shortValue());
        Assert.assertEquals((long)15L, (long)((Short)this.summarize(1, 2, 3, 4, 5).getSum()).shortValue());
        Assert.assertEquals((long)0L, (long)((Short)this.summarize(-100, 0, 100, null).getSum()).shortValue());
        Assert.assertEquals((long)90L, (long)((Short)this.summarize(-10, 100, null).getSum()).shortValue());
        Assert.assertNull((Object)this.summarize(new Integer[0]).getSum());
    }

    @Test
    public void testMax() throws Exception {
        Assert.assertEquals((long)1001L, (long)((Short)this.summarize(-1000, 0, 1, 50, 999, 1001).getMax()).shortValue());
        Assert.assertEquals((long)0L, (long)((Short)this.summarize((Integer)Short.MIN_VALUE, -1000, 0).getMax()).shortValue());
        Assert.assertEquals((long)11L, (long)((Short)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMax()).shortValue());
        Assert.assertEquals((long)11L, (long)((Short)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMax()).shortValue());
        Assert.assertNull((Object)this.summarize(new Integer[0]).getMax());
    }

    @Test
    public void testMin() throws Exception {
        Assert.assertEquals((long)-1000L, (long)((Short)this.summarize(-1000, 0, 1, 50, 999, 1001).getMin()).shortValue());
        Assert.assertEquals((long)-32768L, (long)((Short)this.summarize((Integer)Short.MIN_VALUE, -1000, 0).getMin()).shortValue());
        Assert.assertEquals((long)-2L, (long)((Short)this.summarize(1, 8, 7, 6, 9, 10, 2, 3, 5, 0, 11, -2, 3).getMin()).shortValue());
        Assert.assertEquals((long)-2L, (long)((Short)this.summarize(1, 8, 7, 6, 9, null, 10, 2, 3, 5, null, 0, 11, -2, 3).getMin()).shortValue());
        Assert.assertNull((Object)this.summarize(new Integer[0]).getMin());
    }

    protected NumericColumnSummary<Short> summarize(Integer ... values) {
        Short[] shortValues = new Short[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            shortValues[i] = values[i].shortValue();
        }
        return (NumericColumnSummary)new AggregateCombineHarness<Short, NumericColumnSummary<Short>, ShortSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Short> result1, NumericColumnSummary<Short> result2) {
                Assert.assertEquals((long)result1.getTotalCount(), (long)result2.getTotalCount());
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getMissingCount(), (long)result2.getMissingCount());
                Assert.assertEquals((long)result1.getNonMissingCount(), (long)result2.getNonMissingCount());
                Assert.assertEquals((long)result1.getInfinityCount(), (long)result2.getInfinityCount());
                Assert.assertEquals((long)result1.getNanCount(), (long)result2.getNanCount());
                Assert.assertEquals((Object)result1.containsNull(), (Object)result2.containsNull());
                Assert.assertEquals((Object)result1.containsNonNull(), (Object)result2.containsNonNull());
                Assert.assertEquals((long)((Short)result1.getMin()).shortValue(), (long)((Short)result2.getMin()).shortValue());
                Assert.assertEquals((long)((Short)result1.getMax()).shortValue(), (long)((Short)result2.getMax()).shortValue());
                Assert.assertEquals((long)((Short)result1.getSum()).shortValue(), (long)((Short)result2.getSum()).shortValue());
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(shortValues);
    }
}

