/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.LongValue;
import org.junit.Assert;

public class LongValueSummaryAggregatorTest
extends LongSummaryAggregatorTest {
    @Override
    protected NumericColumnSummary<Long> summarize(Long ... values) {
        LongValue[] longValues = new LongValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            longValues[i] = new LongValue(values[i].longValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<LongValue, NumericColumnSummary<Long>, ValueSummaryAggregator.LongValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Long> result1, NumericColumnSummary<Long> result2) {
                Assert.assertEquals((long)result1.getTotalCount(), (long)result2.getTotalCount());
                Assert.assertEquals((long)result1.getNullCount(), (long)result2.getNullCount());
                Assert.assertEquals((long)result1.getMissingCount(), (long)result2.getMissingCount());
                Assert.assertEquals((long)result1.getNonMissingCount(), (long)result2.getNonMissingCount());
                Assert.assertEquals((long)result1.getInfinityCount(), (long)result2.getInfinityCount());
                Assert.assertEquals((long)result1.getNanCount(), (long)result2.getNanCount());
                Assert.assertEquals((Object)result1.containsNull(), (Object)result2.containsNull());
                Assert.assertEquals((Object)result1.containsNonNull(), (Object)result2.containsNonNull());
                Assert.assertEquals((long)((Long)result1.getMin()), (long)((Long)result2.getMin()));
                Assert.assertEquals((long)((Long)result1.getMax()), (long)((Long)result2.getMax()));
                Assert.assertEquals((long)((Long)result1.getSum()), (long)((Long)result2.getSum()));
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(longValues);
    }
}

