/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.DoubleSummaryAggregator;
import org.junit.Assert;
import org.junit.Test;

public class DoubleSummaryAggregatorTest {
    @Test
    public void testAnscomesQuartetXValues() throws Exception {
        Double[] q1x = new Double[]{10.0, 8.0, 13.0, 9.0, 11.0, 14.0, 6.0, 4.0, 12.0, 7.0, 5.0};
        Double[] q4x = new Double[]{8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 19.0, 8.0, 8.0, 8.0};
        NumericColumnSummary<Double> q1 = this.summarize(q1x);
        NumericColumnSummary<Double> q4 = this.summarize(q4x);
        Assert.assertEquals((double)9.0, (double)q1.getMean(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)q4.getMean(), (double)0.0);
        Assert.assertEquals((double)11.0, (double)q1.getVariance(), (double)1.0E-10);
        Assert.assertEquals((double)11.0, (double)q4.getVariance(), (double)1.0E-10);
        double stddev = Math.sqrt(11.0);
        Assert.assertEquals((double)stddev, (double)q1.getStandardDeviation(), (double)1.0E-10);
        Assert.assertEquals((double)stddev, (double)q4.getStandardDeviation(), (double)1.0E-10);
    }

    @Test
    public void testAnscomesQuartetYValues() throws Exception {
        Double[] q1y = new Double[]{8.04, 6.95, 7.58, 8.81, 8.33, 9.96, 7.24, 4.26, 10.84, 4.82, 5.68};
        Double[] q2y = new Double[]{9.14, 8.14, 8.74, 8.77, 9.26, 8.1, 6.13, 3.1, 9.13, 7.26, 4.74};
        Double[] q3y = new Double[]{7.46, 6.77, 12.74, 7.11, 7.81, 8.84, 6.08, 5.39, 8.15, 6.42, 5.73};
        Double[] q4y = new Double[]{6.58, 5.76, 7.71, 8.84, 8.47, 7.04, 5.25, 12.5, 5.56, 7.91, 6.89};
        NumericColumnSummary<Double> q1 = this.summarize(q1y);
        NumericColumnSummary<Double> q2 = this.summarize(q2y);
        NumericColumnSummary<Double> q3 = this.summarize(q3y);
        NumericColumnSummary<Double> q4 = this.summarize(q4y);
        Assert.assertEquals((double)7.5, (double)q1.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q2.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q3.getMean(), (double)0.001);
        Assert.assertEquals((double)7.5, (double)q4.getMean(), (double)0.001);
        Assert.assertEquals((double)4.12, (double)q1.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q2.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q3.getVariance(), (double)0.01);
        Assert.assertEquals((double)4.12, (double)q4.getVariance(), (double)0.01);
    }

    @Test
    public void testIsNan() throws Exception {
        DoubleSummaryAggregator ag = new DoubleSummaryAggregator();
        Assert.assertFalse((boolean)ag.isNan(Double.valueOf(-1.0)));
        Assert.assertFalse((boolean)ag.isNan(Double.valueOf(0.0)));
        Assert.assertFalse((boolean)ag.isNan(Double.valueOf(23.0)));
        Assert.assertFalse((boolean)ag.isNan(Double.valueOf(Double.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isNan(Double.valueOf(Double.MIN_VALUE)));
        Assert.assertTrue((boolean)ag.isNan(Double.valueOf(Double.NaN)));
    }

    @Test
    public void testIsInfinite() throws Exception {
        DoubleSummaryAggregator ag = new DoubleSummaryAggregator();
        Assert.assertFalse((boolean)ag.isInfinite(Double.valueOf(-1.0)));
        Assert.assertFalse((boolean)ag.isInfinite(Double.valueOf(0.0)));
        Assert.assertFalse((boolean)ag.isInfinite(Double.valueOf(23.0)));
        Assert.assertFalse((boolean)ag.isInfinite(Double.valueOf(Double.MAX_VALUE)));
        Assert.assertFalse((boolean)ag.isInfinite(Double.valueOf(Double.MIN_VALUE)));
        Assert.assertTrue((boolean)ag.isInfinite(Double.valueOf(Double.POSITIVE_INFINITY)));
        Assert.assertTrue((boolean)ag.isInfinite(Double.valueOf(Double.NEGATIVE_INFINITY)));
    }

    @Test
    public void testMean() throws Exception {
        Assert.assertEquals((double)50.0, (double)this.summarize(0.0, 100.0).getMean(), (double)0.0);
        Assert.assertEquals((double)33.333333, (double)this.summarize(0.0, 0.0, 100.0).getMean(), (double)1.0E-5);
        Assert.assertEquals((double)50.0, (double)this.summarize(0.0, 0.0, 100.0, 100.0).getMean(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)this.summarize(0.0, 100.0, null).getMean(), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Double[0]).getMean());
    }

    @Test
    public void testSum() throws Exception {
        Assert.assertEquals((double)100.0, (double)((Double)this.summarize(0.0, 100.0).getSum()), (double)0.0);
        Assert.assertEquals((double)15.0, (double)((Double)this.summarize(1.0, 2.0, 3.0, 4.0, 5.0).getSum()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)this.summarize(-100.0, 0.0, 100.0, null).getSum()), (double)0.0);
        Assert.assertEquals((double)90.0, (double)((Double)this.summarize(-10.0, 100.0, null).getSum()), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Double[0]).getSum());
    }

    @Test
    public void testMax() throws Exception {
        Assert.assertEquals((double)1001.0, (double)((Double)this.summarize(-1000.0, 0.0, 1.0, 50.0, 999.0, 1001.0).getMax()), (double)0.0);
        Assert.assertEquals((double)11.0, (double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, 10.0, 2.0, 3.0, 5.0, 0.0, 11.0, -2.0, 3.0).getMax()), (double)0.0);
        Assert.assertEquals((double)11.0, (double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, null, 10.0, 2.0, 3.0, 5.0, null, 0.0, 11.0, -2.0, 3.0).getMax()), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Double[0]).getMax());
    }

    @Test
    public void testMin() throws Exception {
        Assert.assertEquals((double)-1000.0, (double)((Double)this.summarize(-1000.0, 0.0, 1.0, 50.0, 999.0, 1001.0).getMin()), (double)0.0);
        Assert.assertEquals((double)-2.0, (double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, 10.0, 2.0, 3.0, 5.0, 0.0, 11.0, -2.0, 3.0).getMin()), (double)0.0);
        Assert.assertEquals((double)-2.0, (double)((Double)this.summarize(1.0, 8.0, 7.0, 6.0, 9.0, null, 10.0, 2.0, 3.0, 5.0, null, 0.0, 11.0, -2.0, 3.0).getMin()), (double)0.0);
        Assert.assertNull((Object)this.summarize(new Double[0]).getMin());
    }

    @Test
    public void testCounts() throws Exception {
        NumericColumnSummary<Double> summary = this.summarize(Double.NaN, 1.0, null, 123.0, -44.00001, Double.POSITIVE_INFINITY, 55.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, null, Double.NaN);
        Assert.assertEquals((long)11L, (long)summary.getTotalCount());
        Assert.assertEquals((long)2L, (long)summary.getNullCount());
        Assert.assertEquals((long)9L, (long)summary.getNonNullCount());
        Assert.assertEquals((long)7L, (long)summary.getMissingCount());
        Assert.assertEquals((long)4L, (long)summary.getNonMissingCount());
        Assert.assertEquals((long)2L, (long)summary.getNanCount());
        Assert.assertEquals((long)3L, (long)summary.getInfinityCount());
    }

    protected NumericColumnSummary<Double> summarize(Double ... values) {
        return (NumericColumnSummary)new AggregateCombineHarness<Double, NumericColumnSummary<Double>, DoubleSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Double> result1, NumericColumnSummary<Double> result2) {
                Assert.assertEquals((double)((Double)result1.getMin()), (double)((Double)result2.getMin()), (double)0.0);
                Assert.assertEquals((double)((Double)result1.getMax()), (double)((Double)result2.getMax()), (double)0.0);
                Assert.assertEquals((double)result1.getMean(), (double)result2.getMean(), (double)1.0E-12);
                Assert.assertEquals((double)result1.getVariance(), (double)result2.getVariance(), (double)1.0E-9);
                Assert.assertEquals((double)result1.getStandardDeviation(), (double)result2.getStandardDeviation(), (double)1.0E-12);
            }
        }.summarize(values);
    }
}

