/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.flink.api.java.sampling.BernoulliSampler;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.PoissonSampler;
import org.apache.flink.api.java.sampling.RandomSampler;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithReplacement;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithoutReplacement;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.shaded.com.google.common.collect.Sets;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.apache.flink.testutils.junit.RetryRule;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class RandomSamplerTest {
    private static final int SOURCE_SIZE = 10000;
    private static final int DEFAULT_PARTITION_NUMBER = 10;
    private static final KolmogorovSmirnovTest ksTest = new KolmogorovSmirnovTest();
    private static final List<Double> source = new ArrayList<Double>(10000);
    @Rule
    public final RetryRule retryRule = new RetryRule();
    private final List<Double>[] sourcePartitions = new List[10];

    @BeforeClass
    public static void init() {
        for (int i = 0; i < 10000; ++i) {
            source.add(Double.valueOf(i));
        }
    }

    private void initSourcePartition() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.sourcePartitions[i] = new ArrayList<Double>((int)Math.ceil(1000.0));
        }
        for (i = 0; i < 10000; ++i) {
            int index = i % 10;
            this.sourcePartitions[index].add(Double.valueOf(i));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBernoulliSamplerWithUnexpectedFraction1() {
        this.verifySamplerFraction(-1.0, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBernoulliSamplerWithUnexpectedFraction2() {
        this.verifySamplerFraction(2.0, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testBernoulliSamplerFraction() {
        this.verifySamplerFraction(0.01, false);
        this.verifySamplerFraction(0.05, false);
        this.verifySamplerFraction(0.1, false);
        this.verifySamplerFraction(0.3, false);
        this.verifySamplerFraction(0.5, false);
        this.verifySamplerFraction(0.854, false);
        this.verifySamplerFraction(0.99, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testBernoulliSamplerDuplicateElements() {
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.01));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.1));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new BernoulliSampler(0.5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPoissonSamplerWithUnexpectedFraction1() {
        this.verifySamplerFraction(-1.0, true);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testPoissonSamplerFraction() {
        this.verifySamplerFraction(0.01, true);
        this.verifySamplerFraction(0.05, true);
        this.verifySamplerFraction(0.1, true);
        this.verifySamplerFraction(0.5, true);
        this.verifySamplerFraction(0.854, true);
        this.verifySamplerFraction(0.99, true);
        this.verifySamplerFraction(1.5, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReservoirSamplerUnexpectedSize1() {
        this.verifySamplerFixedSampleSize(-1, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReservoirSamplerUnexpectedSize2() {
        this.verifySamplerFixedSampleSize(-1, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testBernoulliSamplerDistribution() {
        this.verifyBernoulliSampler(0.01);
        this.verifyBernoulliSampler(0.05);
        this.verifyBernoulliSampler(0.1);
        this.verifyBernoulliSampler(0.5);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testPoissonSamplerDistribution() {
        this.verifyPoissonSampler(0.01);
        this.verifyPoissonSampler(0.05);
        this.verifyPoissonSampler(0.1);
        this.verifyPoissonSampler(0.5);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerSampledSize() {
        this.verifySamplerFixedSampleSize(1, true);
        this.verifySamplerFixedSampleSize(10, true);
        this.verifySamplerFixedSampleSize(100, true);
        this.verifySamplerFixedSampleSize(1234, true);
        this.verifySamplerFixedSampleSize(9999, true);
        this.verifySamplerFixedSampleSize(20000, true);
        this.verifySamplerFixedSampleSize(1, false);
        this.verifySamplerFixedSampleSize(10, false);
        this.verifySamplerFixedSampleSize(100, false);
        this.verifySamplerFixedSampleSize(1234, false);
        this.verifySamplerFixedSampleSize(9999, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerSampledSize2() {
        ReservoirSamplerWithoutReplacement sampler = new ReservoirSamplerWithoutReplacement(20000);
        Iterator sampled = sampler.sample(source.iterator());
        Assert.assertTrue((String)"ReservoirSamplerWithoutReplacement sampled output size should not beyond the source size.", (this.getSize(sampled) == 10000 ? 1 : 0) != 0);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerDuplicateElements() {
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(100));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(1000));
        this.verifyRandomSamplerDuplicateElements((RandomSampler<Double>)new ReservoirSamplerWithoutReplacement(5000));
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerWithoutReplacement() {
        this.verifyReservoirSamplerWithoutReplacement(100, false);
        this.verifyReservoirSamplerWithoutReplacement(500, false);
        this.verifyReservoirSamplerWithoutReplacement(1000, false);
        this.verifyReservoirSamplerWithoutReplacement(5000, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerWithReplacement() {
        this.verifyReservoirSamplerWithReplacement(100, false);
        this.verifyReservoirSamplerWithReplacement(500, false);
        this.verifyReservoirSamplerWithReplacement(1000, false);
        this.verifyReservoirSamplerWithReplacement(5000, false);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerWithMultiSourcePartitions1() {
        this.initSourcePartition();
        this.verifyReservoirSamplerWithoutReplacement(100, true);
        this.verifyReservoirSamplerWithoutReplacement(500, true);
        this.verifyReservoirSamplerWithoutReplacement(1000, true);
        this.verifyReservoirSamplerWithoutReplacement(5000, true);
    }

    @Test
    @RetryOnFailure(times=3)
    public void testReservoirSamplerWithMultiSourcePartitions2() {
        this.initSourcePartition();
        this.verifyReservoirSamplerWithReplacement(100, true);
        this.verifyReservoirSamplerWithReplacement(500, true);
        this.verifyReservoirSamplerWithReplacement(1000, true);
        this.verifyReservoirSamplerWithReplacement(5000, true);
    }

    private void verifySamplerFixedSampleSize(int numSample, boolean withReplacement) {
        Object sampler = withReplacement ? new ReservoirSamplerWithReplacement(numSample) : new ReservoirSamplerWithoutReplacement(numSample);
        Iterator sampled = sampler.sample(source.iterator());
        Assert.assertEquals((long)numSample, (long)this.getSize(sampled));
    }

    private void verifySamplerFraction(double fraction, boolean withReplacement) {
        Object sampler = withReplacement ? new PoissonSampler(fraction) : new BernoulliSampler(fraction);
        int totalSampledSize = 0;
        double sampleCount = 20.0;
        int i = 0;
        while ((double)i < sampleCount) {
            totalSampledSize += this.getSize(sampler.sample(source.iterator()));
            ++i;
        }
        double resultFraction = (double)totalSampledSize / (10000.0 * sampleCount);
        Assert.assertTrue((String)String.format("expected fraction: %f, result fraction: %f", fraction, resultFraction), (Math.abs((resultFraction - fraction) / fraction) < 0.2 ? 1 : 0) != 0);
    }

    private void verifyRandomSamplerDuplicateElements(final RandomSampler<Double> sampler) {
        LinkedList list = Lists.newLinkedList((Iterable)new Iterable<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return sampler.sample(source.iterator());
            }
        });
        HashSet set = Sets.newHashSet((Iterable)list);
        Assert.assertTrue((String)"There should not have duplicate element for sampler without replacement.", (list.size() == set.size() ? 1 : 0) != 0);
    }

    private int getSize(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    private void verifyBernoulliSampler(double fraction) {
        BernoulliSampler sampler = new BernoulliSampler(fraction);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, true);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, false);
    }

    private void verifyPoissonSampler(double fraction) {
        PoissonSampler sampler = new PoissonSampler(fraction);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, true);
        this.verifyRandomSamplerWithFraction(fraction, (RandomSampler<Double>)sampler, false);
    }

    private void verifyReservoirSamplerWithReplacement(int numSamplers, boolean sampleOnPartitions) {
        ReservoirSamplerWithReplacement sampler = new ReservoirSamplerWithReplacement(numSamplers);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, true, sampleOnPartitions);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, false, sampleOnPartitions);
    }

    private void verifyReservoirSamplerWithoutReplacement(int numSamplers, boolean sampleOnPartitions) {
        ReservoirSamplerWithoutReplacement sampler = new ReservoirSamplerWithoutReplacement(numSamplers);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, true, sampleOnPartitions);
        this.verifyRandomSamplerWithSampleSize(numSamplers, (RandomSampler<Double>)sampler, false, sampleOnPartitions);
    }

    private void verifyRandomSamplerWithFraction(double fraction, RandomSampler<Double> sampler, boolean withDefaultSampler) {
        double[] baseSample = withDefaultSampler ? this.getDefaultSampler(fraction) : this.getWrongSampler(fraction);
        this.verifyKSTest(sampler, baseSample, withDefaultSampler);
    }

    private void verifyRandomSamplerWithSampleSize(int sampleSize, RandomSampler<Double> sampler, boolean withDefaultSampler, boolean sampleWithPartitions) {
        double[] baseSample = withDefaultSampler ? this.getDefaultSampler(sampleSize) : this.getWrongSampler(sampleSize);
        this.verifyKSTest(sampler, baseSample, withDefaultSampler, sampleWithPartitions);
    }

    private void verifyKSTest(RandomSampler<Double> sampler, double[] defaultSampler, boolean expectSuccess) {
        this.verifyKSTest(sampler, defaultSampler, expectSuccess, false);
    }

    private void verifyKSTest(RandomSampler<Double> sampler, double[] defaultSampler, boolean expectSuccess, boolean sampleOnPartitions) {
        double[] sampled = this.getSampledOutput(sampler, sampleOnPartitions);
        double pValue = ksTest.kolmogorovSmirnovStatistic(sampled, defaultSampler);
        double dValue = this.getDValue(sampled.length, defaultSampler.length);
        if (expectSuccess) {
            Assert.assertTrue((String)String.format("KS test result with p value(%f), d value(%f)", pValue, dValue), (pValue <= dValue ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)String.format("KS test result with p value(%f), d value(%f)", pValue, dValue), (pValue > dValue ? 1 : 0) != 0);
        }
    }

    private double[] getSampledOutput(RandomSampler<Double> sampler, boolean sampleOnPartitions) {
        Iterator sampled;
        if (sampleOnPartitions) {
            DistributedRandomSampler reservoirRandomSampler = (DistributedRandomSampler)sampler;
            LinkedList intermediateResult = Lists.newLinkedList();
            for (int i = 0; i < 10; ++i) {
                Iterator partialIntermediateResult = reservoirRandomSampler.sampleInPartition(this.sourcePartitions[i].iterator());
                while (partialIntermediateResult.hasNext()) {
                    intermediateResult.add(partialIntermediateResult.next());
                }
            }
            sampled = reservoirRandomSampler.sampleInCoordinator(intermediateResult.iterator());
        } else {
            sampled = sampler.sample(source.iterator());
        }
        ArrayList list = Lists.newArrayList();
        while (sampled.hasNext()) {
            list.add(sampled.next());
        }
        return this.transferFromListToArrayWithOrder(list);
    }

    private double[] transferFromListToArrayWithOrder(List<Double> list) {
        Collections.sort(list);
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    private double[] getDefaultSampler(double fraction) {
        Preconditions.checkArgument((fraction > 0.0 ? 1 : 0) != 0, (Object)"Sample fraction should be positive.");
        int size = (int)(10000.0 * fraction);
        double step = 1.0 / fraction;
        double[] defaultSampler = new double[size];
        for (int i = 0; i < size; ++i) {
            defaultSampler[i] = Math.round(step * (double)i);
        }
        return defaultSampler;
    }

    private double[] getDefaultSampler(int fixSize) {
        Preconditions.checkArgument((fixSize > 0 ? 1 : 0) != 0, (Object)"Sample fraction should be positive.");
        double step = 10000.0 / (double)fixSize;
        double[] defaultSampler = new double[fixSize];
        for (int i = 0; i < fixSize; ++i) {
            defaultSampler[i] = Math.round(step * (double)i);
        }
        return defaultSampler;
    }

    private double[] getWrongSampler(double fraction) {
        Preconditions.checkArgument((fraction > 0.0 ? 1 : 0) != 0, (Object)"Sample size should be positive.");
        int size = (int)(10000.0 * fraction);
        int halfSourceSize = 5000;
        double[] wrongSampler = new double[size];
        for (int i = 0; i < size; ++i) {
            wrongSampler[i] = (double)i % (double)halfSourceSize;
        }
        return wrongSampler;
    }

    private double[] getWrongSampler(int fixSize) {
        Preconditions.checkArgument((fixSize > 0 ? 1 : 0) != 0, (Object)"Sample size be positive.");
        int halfSourceSize = 5000;
        double[] wrongSampler = new double[fixSize];
        for (int i = 0; i < fixSize; ++i) {
            wrongSampler[i] = (double)i % (double)halfSourceSize;
        }
        return wrongSampler;
    }

    private double getDValue(int m, int n) {
        Preconditions.checkArgument((m > 0 ? 1 : 0) != 0, (Object)"input sample size should be positive.");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"input sample size should be positive.");
        double first = m;
        double second = n;
        return 1.95 * Math.sqrt((first + second) / (first * second));
    }
}

