/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.FilterOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.UdfOperatorUtils;
import org.apache.flink.api.java.operators.translation.PlanFilterOperator;

@Public
public class FilterOperator<T>
extends SingleInputUdfOperator<T, T, FilterOperator<T>> {
    protected final FilterFunction<T> function;
    protected final String defaultName;

    public FilterOperator(DataSet<T> input, FilterFunction<T> function, String defaultName) {
        super(input, input.getType());
        this.function = function;
        this.defaultName = defaultName;
        UdfOperatorUtils.analyzeSingleInputUdf(this, FilterFunction.class, defaultName, function, null);
    }

    protected FilterFunction<T> getFunction() {
        return this.function;
    }

    protected FilterOperatorBase<T, FlatMapFunction<T, T>> translateToDataFlow(Operator<T> input) {
        String name = this.getName() != null ? this.getName() : "Filter at " + this.defaultName;
        PlanFilterOperator<T> po = new PlanFilterOperator<T>(this.function, name, this.getInputType());
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setParallelism(this.getParallelism());
        } else {
            po.setParallelism(input.getParallelism());
        }
        return po;
    }
}

