/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.StringValue;

@PublicEvolving
public class TextValueInputFormat
extends DelimitedInputFormat<StringValue> {
    private static final long serialVersionUID = 1L;
    private String charsetName = "UTF-8";
    private boolean skipInvalidLines;
    private transient CharsetDecoder decoder;
    private transient ByteBuffer byteWrapper;
    private transient boolean ascii;

    public TextValueInputFormat(Path filePath) {
        super(filePath);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("The charset name may not be null.");
        }
        this.charsetName = charsetName;
    }

    public boolean isSkipInvalidLines() {
        return this.skipInvalidLines;
    }

    public void setSkipInvalidLines(boolean skipInvalidLines) {
        this.skipInvalidLines = skipInvalidLines;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        if (this.charsetName == null || !Charset.isSupported(this.charsetName)) {
            throw new RuntimeException("Unsupported charset: " + this.charsetName);
        }
        if (this.charsetName.equalsIgnoreCase(StandardCharsets.US_ASCII.name())) {
            this.ascii = true;
        }
        this.decoder = Charset.forName(this.charsetName).newDecoder();
        this.byteWrapper = ByteBuffer.allocate(1);
    }

    public StringValue readRecord(StringValue reuse, byte[] bytes, int offset, int numBytes) {
        if (this.ascii) {
            reuse.setValueAscii(bytes, offset, numBytes);
            return reuse;
        }
        ByteBuffer byteWrapper = this.byteWrapper;
        if (bytes != byteWrapper.array()) {
            this.byteWrapper = byteWrapper = ByteBuffer.wrap(bytes, 0, bytes.length);
        }
        byteWrapper.limit(offset + numBytes);
        byteWrapper.position(offset);
        try {
            CharBuffer result = this.decoder.decode(byteWrapper);
            reuse.setValue(result);
            return reuse;
        }
        catch (CharacterCodingException e) {
            if (this.skipInvalidLines) {
                return null;
            }
            byte[] copy = new byte[numBytes];
            System.arraycopy(bytes, offset, copy, 0, numBytes);
            throw new RuntimeException("Line could not be encoded: " + Arrays.toString(copy), e);
        }
    }

    public String toString() {
        return "TextValueInputFormat (" + this.getFilePath() + ") - " + this.charsetName + (this.skipInvalidLines ? "(skipping invalid lines)" : "");
    }
}

