/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.java.utils.Option;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.java.utils.RequiredParametersException;

@PublicEvolving
public class RequiredParameters {
    private static final String HELP_TEXT_PARAM_DELIMITER = "\t";
    private static final String HELP_TEXT_LINE_DELIMITER = "\n";
    private static final int HELP_TEXT_LENGTH_PER_PARAM = 100;
    private HashMap<String, Option> data = new HashMap();

    public Option add(String name) throws RequiredParametersException {
        if (!this.data.containsKey(name)) {
            Option option = new Option(name);
            this.data.put(name, option);
            return option;
        }
        throw new RequiredParametersException("Option with key " + name + " already exists.");
    }

    public void add(Option option) throws RequiredParametersException {
        if (this.data.containsKey(option.getName())) {
            throw new RequiredParametersException("Option with key " + option.getName() + " already exists.");
        }
        this.data.put(option.getName(), option);
    }

    public void applyTo(ParameterTool parameterTool) throws RequiredParametersException {
        LinkedList<String> missingArguments = new LinkedList<String>();
        for (Option o : this.data.values()) {
            if (parameterTool.data.containsKey(o.getName())) {
                if (Objects.equals(parameterTool.data.get(o.getName()), ParameterTool.NO_VALUE_KEY)) {
                    this.checkAndApplyDefaultValue(o, parameterTool.data);
                    continue;
                }
                this.checkAmbiguousValues(o, parameterTool.data);
                this.checkIsCastableToDefinedType(o, parameterTool.data);
                this.checkChoices(o, parameterTool.data);
                continue;
            }
            if (!this.hasNoDefaultValueAndNoValuePassedOnAlternativeName(o, parameterTool.data)) continue;
            missingArguments.add(o.getName());
        }
        if (!missingArguments.isEmpty()) {
            throw new RequiredParametersException(this.missingArgumentsText(missingArguments), missingArguments);
        }
    }

    private void checkAndApplyDefaultValue(Option o, Map<String, String> data) throws RequiredParametersException {
        if (this.hasNoDefaultValueAndNoValuePassedOnAlternativeName(o, data)) {
            throw new RequiredParametersException("No default value for undefined parameter " + o.getName());
        }
    }

    private void checkIsCastableToDefinedType(Option o, Map<String, String> data) throws RequiredParametersException {
        if (o.hasType() && !o.isCastableToDefinedType(data.get(o.getName()))) {
            throw new RequiredParametersException("Value for parameter " + o.getName() + " cannot be cast to type " + (Object)((Object)o.getType()));
        }
    }

    private void checkChoices(Option o, Map<String, String> data) throws RequiredParametersException {
        if (o.getChoices().size() > 0 && !o.getChoices().contains(data.get(o.getName()))) {
            throw new RequiredParametersException("Value " + data.get(o.getName()) + " is not in the list of valid choices for key " + o.getName());
        }
    }

    private boolean hasNoDefaultValueAndNoValuePassedOnAlternativeName(Option o, Map<String, String> data) throws RequiredParametersException {
        if (o.hasAlt() && data.containsKey(o.getAlt())) {
            data.put(o.getName(), data.get(o.getAlt()));
        } else if (o.hasDefaultValue()) {
            data.put(o.getName(), o.getDefaultValue());
            if (o.hasAlt()) {
                data.put(o.getAlt(), o.getDefaultValue());
            }
        } else {
            return true;
        }
        return false;
    }

    private void checkAmbiguousValues(Option o, Map<String, String> data) throws RequiredParametersException {
        if (data.containsKey(o.getAlt()) && !Objects.equals(data.get(o.getAlt()), ParameterTool.NO_VALUE_KEY)) {
            throw new RequiredParametersException("Value passed for parameter " + o.getName() + " is ambiguous. Value passed for short and long name.");
        }
    }

    public String getHelp() {
        StringBuilder sb = new StringBuilder(this.data.size() * 100);
        sb.append("Required Parameters:");
        sb.append(HELP_TEXT_LINE_DELIMITER);
        for (Option o : this.data.values()) {
            sb.append(this.helpText(o));
        }
        sb.append(HELP_TEXT_LINE_DELIMITER);
        return sb.toString();
    }

    public String getHelp(List<String> missingArguments) {
        return this.getHelp() + this.missingArgumentsText(missingArguments);
    }

    private String helpText(Option option) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(HELP_TEXT_PARAM_DELIMITER);
        if (option.hasAlt()) {
            sb.append("-");
            sb.append(option.getAlt());
            sb.append(", ");
        }
        sb.append("--");
        sb.append(option.getName());
        sb.append(HELP_TEXT_PARAM_DELIMITER);
        if (option.getHelpText() != null) {
            sb.append(option.getHelpText());
            sb.append(HELP_TEXT_PARAM_DELIMITER);
        }
        if (option.hasDefaultValue()) {
            sb.append("default: ");
            sb.append(option.getDefaultValue());
            sb.append(HELP_TEXT_PARAM_DELIMITER);
        }
        if (!option.getChoices().isEmpty()) {
            sb.append("choices: ");
            for (String choice : option.getChoices()) {
                sb.append(choice);
                sb.append(" ");
            }
        }
        sb.append(HELP_TEXT_LINE_DELIMITER);
        return sb.toString();
    }

    private String missingArgumentsText(List<String> missingArguments) {
        StringBuilder sb = new StringBuilder(missingArguments.size() * 10);
        sb.append("Missing arguments for:");
        sb.append(HELP_TEXT_LINE_DELIMITER);
        for (String arg : missingArguments) {
            sb.append(arg);
            sb.append(" ");
        }
        return sb.toString();
    }
}

