/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class SortPartitionTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.createTypeInfo(CustomType.class), BasicArrayTypeInfo.LONG_ARRAY_TYPE_INFO});
    private final List<Long> emptyLongData = new ArrayList<Long>();
    private final List<CustomType> customTypeData = new ArrayList<CustomType>();
    private final List<Tuple4<Integer, Long, CustomType, Long[]>> tupleWithCustomData = new ArrayList<Tuple4<Integer, Long, CustomType, Long[]>>();

    @Test
    public void testSortPartitionPositionKeys1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition(0, Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testSortPartitionPositionKeys2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition(0, Order.ASCENDING).sortPartition(3, Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithPositionKeys3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition(2, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithPositionKeys4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition(3, Order.ASCENDING);
    }

    @Test
    public void testSortPartitionExpressionKeys1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.sortPartition("f1", Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testSortPartitionExpressionKeys2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition("f0", Order.ASCENDING).sortPartition("f2.nested.myInt", Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithExpressionKeys3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition("f2.nested", Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithExpressionKeys4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition("f3", Order.ASCENDING);
    }

    @Test
    public void testSortPartitionWithKeySelector1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Integer>(){

                public Integer getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                    return (Integer)value.f0;
                }
            }, Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Long[]>(){

            public Long[] getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (Long[])value.f3;
            }
        }, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition("f1", Order.ASCENDING).sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, CustomType>(){

            public CustomType getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (CustomType)value.f2;
            }
        }, Order.ASCENDING);
    }

    @Test
    public void testSortPartitionWithKeySelector4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        try {
            tupleDs.sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, Tuple2<Integer, Long>>(){

                public Tuple2<Integer, Long> getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                    return new Tuple2(value.f0, value.f1);
                }
            }, Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testSortPartitionWithKeySelector5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.tupleWithCustomData, this.tupleWithCustomInfo);
        tupleDs.sortPartition((KeySelector)new KeySelector<Tuple4<Integer, Long, CustomType, Long[]>, CustomType>(){

            public CustomType getKey(Tuple4<Integer, Long, CustomType, Long[]> value) throws Exception {
                return (CustomType)value.f2;
            }
        }, Order.ASCENDING).sortPartition("f1", Order.ASCENDING);
    }

    public static class CustomType2
    implements Serializable {
        public int myInt;
        public int[] myIntArray;
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nest nested;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }

        public static class Nest {
            public int myInt;
        }
    }
}

