/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CrossOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static List<CustomType> customTypeData = new ArrayList<CustomType>();

    @BeforeClass
    public static void insertCustomData() {
        customTypeData.add(new CustomType());
    }

    @Test
    public void testCrossProjection1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection21() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection22() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection23() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection24() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection25() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection26() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.cross((DataSet)ds2).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCrossProjection27() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.cross((DataSet)ds2).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection28() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection29() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{5});
    }

    public void testCrossProjection10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection30() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{-1});
    }

    public void testCrossProjection11() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection31() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{-1});
    }

    public void testCrossProjection12() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{2}).projectFirst(new int[]{1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection32() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{2}).projectFirst(new int[]{-1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection13() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectSecond(new int[]{0}).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCrossProjection14() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.cross((DataSet)ds2).projectFirst(new int[]{0}).projectSecond(new int[]{5});
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

