/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operator.JoinOperatorTest;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CoGroupOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static List<JoinOperatorTest.CustomType> customTypeData = new ArrayList<JoinOperatorTest.CustomType>();

    @BeforeClass
    public static void insertCustomData() {
        customTypeData.add(new JoinOperatorTest.CustomType());
    }

    @Test
    public void testCoGroupKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{2});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{0, 1}).equalTo(new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCoGroupKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testCoGroupKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.coGroup((DataSet)ds2).where(new int[]{-1}).equalTo(new int[]{-1});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{4}).equalTo(new int[]{0});
    }

    @Test
    public void testCoGroupKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt", "myString"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"myNonExistent"}).equalTo(new String[]{"myInt"});
    }

    @Test
    public void testCoGroupKeyAtomicExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"*"});
    }

    @Test
    public void testCoGroupKeyAtomicExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"*"}).equalTo(new String[]{"myInt"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"*", "invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 1});
        ds1.coGroup((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"*", "invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.coGroup((DataSet)ds2).where(new String[]{"*"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyAtomicInvalidExpression6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        ds1.coGroup((DataSet)ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    @Test
    public void testCoGroupKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyExpressions3Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myInt", "nested.myString"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCoGroupKeyExpressions4Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new String[]{"nested.myNonExistent"}).equalTo(new String[]{"nested.myInt"});
    }

    @Test
    public void testCoGroupKeySelectors1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            }).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCoGroupKeyMixing1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.coGroup((DataSet)ds2).where((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            }).equalTo(new int[]{3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCoGroupKeyMixing2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.coGroup((DataSet)ds2).where(new int[]{3}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

                public Long getKey(JoinOperatorTest.CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyMixing3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{2}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

            public Long getKey(JoinOperatorTest.CustomType value) {
                return value.myLong;
            }
        });
    }

    @Test(expected=InvalidProgramException.class)
    public void testCoGroupKeyMixing4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.coGroup((DataSet)ds2).where(new int[]{1, 3}).equalTo((KeySelector)new KeySelector<JoinOperatorTest.CustomType, Long>(){

            public Long getKey(JoinOperatorTest.CustomType value) {
                return value.myLong;
            }
        });
    }

    @Test
    public void testSemanticPropsWithKeySelector1() {
        DataSource tupleDs2;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        CoGroupOperator coGroupOp = tupleDs1.coGroup((DataSet)(tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo))).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((CoGroupFunction)new DummyTestCoGroupFunction1());
        DualInputSemanticProperties semProps = coGroupOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(6)));
        Assert.assertTrue((semProps.getReadFields(1).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)semProps.getReadFields(1).contains(Integer.valueOf(5)));
    }

    @Test
    public void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        CoGroupOperator coGroupOp = (CoGroupOperator)((CoGroupOperator)tupleDs1.coGroup((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((CoGroupFunction)new DummyTestCoGroupFunction2()).withForwardedFieldsFirst(new String[]{"2;4->0"})).withForwardedFieldsSecond(new String[]{"0->4;1;1->3"});
        DualInputSemanticProperties semProps = coGroupOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getReadFields(1) == null ? 1 : 0) != 0);
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"0;1;2"})
    public static class DummyTestCoGroupFunction2
    implements CoGroupFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        public void coGroup(Iterable<Tuple5<Integer, Long, String, Long, Integer>> first, Iterable<Tuple5<Integer, Long, String, Long, Integer>> second, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->4;1;1->3"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"2;4->0"})
    @FunctionAnnotation.ReadFieldsFirst(value={"0;2;4"})
    @FunctionAnnotation.ReadFieldsSecond(value={"1;3"})
    public static class DummyTestCoGroupFunction1
    implements CoGroupFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        public void coGroup(Iterable<Tuple5<Integer, Long, String, Long, Integer>> first, Iterable<Tuple5<Integer, Long, String, Long, Integer>> second, Collector<Tuple5<Integer, Long, String, Long, Integer>> out) throws Exception {
        }
    }

    public static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }
}

