/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.sca.CodeErrorException;
import org.apache.flink.api.java.sca.UdfAnalyzer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class UdfAnalyzerTest {
    @Test
    public void testSingleFieldExtract() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map1.class, "Tuple2<String,Integer>", "String");
    }

    @Test
    public void testForwardIntoTuple() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map2.class, "Tuple2<String,Integer>", "Tuple2<String,String>");
    }

    @Test
    public void testForwardWithArrayAttrAccess() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map3.class, "String[]", "Integer");
    }

    @Test
    public void testForwardWithGenericTypePublicAttrAccess() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map4.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo", "String");
    }

    @Test
    public void testForwardWithPojoPublicAttrAccess() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map5.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "String");
    }

    @Test
    public void testForwardWithPojoPrivateAttrAccess() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map6.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "String");
    }

    @Test
    public void testForwardIntoTupleWithCondition() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map7.class, "Tuple2<String,Integer>", "Tuple2<String,String>");
    }

    @Test
    public void testSingleFieldExtractWithCondition() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map8.class, "Tuple2<String,String>", "String");
    }

    @Test
    public void testForwardIntoTupleWithInstanceVar() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map9.class, "String", "Tuple1<String>");
    }

    @Test
    public void testForwardIntoTupleWithInstanceVar2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map10.class, "String", "Tuple1<Tuple1<String>>");
    }

    @Test
    public void testForwardIntoTupleWithInstanceVarChangedByOtherMethod() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map11.class, "String", "Tuple2<String, String>");
    }

    @Test
    public void testForwardIntoNestedTuple() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map12.class, "Tuple2<String,Integer>", "Tuple2<Tuple1<String>,Tuple1<String>>");
    }

    @Test
    public void testForwardIntoNestedTupleWithVarAndModification() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map13.class, "Tuple2<String,Integer>", "Tuple2<Tuple1<String>,Tuple1<String>>");
    }

    @Test
    public void testForwardIntoTupleWithAssignment() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map14.class, "Tuple2<String,Integer>", "Tuple2<String,String>");
    }

    @Test
    public void testForwardIntoTupleWithInputPath() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map15.class, "Tuple2<Tuple1<String>,Integer>", "Tuple2<String,String>");
    }

    @Test
    public void testForwardIntoPojoByGettersAndSetters() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map16.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>");
    }

    @Test
    public void testForwardIntoTupleWithInstanceVarAndCondition() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map17.class, "String", "Tuple1<String>");
    }

    @Test
    public void testForwardIntoUnsupportedObject() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map18.class, "Tuple1<String>", "java.util.ArrayList");
    }

    @Test
    public void testForwardWithNewTupleToNewTupleAssignment() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map19.class, "Integer", "Tuple1<Integer>");
    }

    @Test
    public void testForwardWithGetMethod() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map20.class, "Tuple4<Integer, Integer, Integer, Integer>", "Tuple4<Integer, Integer, Integer, Integer>");
    }

    @Test
    public void testForwardWithSetMethod() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map21.class, "Tuple2<Integer, Integer>", "Tuple2<Integer, Integer>");
    }

    @Test
    public void testForwardIntoNewTupleWithSetMethod() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map22.class, "Tuple2<Integer, Integer>", "Tuple2<Integer, Integer>");
    }

    @Test
    public void testForwardWithGetMethod2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map23.class, "Tuple1<Integer>", "Tuple1<Integer>");
    }

    @Test
    public void testForwardWithSetMethod2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map24.class, "Tuple2<Integer, Integer>", "Tuple2<Integer, Integer>");
    }

    @Test
    public void testForwardWithModifiedInput() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map25.class, "Tuple2<Integer, Integer>", "Tuple2<Integer, Integer>");
    }

    @Test
    public void testForwardWithTuplesGetSetFieldMethods() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map26.class, "Integer", "Tuple2<Integer, Integer>");
    }

    @Test
    public void testForwardWithTuplesGetSetFieldMethods2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map27.class, "Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>", "Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>");
    }

    @Test
    public void testForwardWithBranching1() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map28.class, "Integer", "Integer");
    }

    @Test
    public void testForwardWithBranching2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map29.class, "Tuple3<String, String, String>", "Tuple3<String, String, String>");
    }

    @Test
    public void testForwardWithBranching3() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map30.class, "Tuple2<String,String>", "String");
    }

    @Test
    public void testForwardWithInheritance() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map31.class, "Tuple2<String,String>", "Tuple2<String,String>");
    }

    @Test
    public void testForwardWithUnboxingAndBoxing() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map32.class, "Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double>", "Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double>");
    }

    @Test
    public void testForwardWithBranching4() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map33.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>");
    }

    @Test
    public void testForwardWithBranching5() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map34.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>");
    }

    @Test
    public void testForwardWithArrayModification() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map35.class, "String[]", "Tuple2<String[], String[]>");
    }

    @Test
    public void testForwardWithBranching6() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map36.class, "Tuple3<String, String, String>", "Tuple3<String, String, String>");
    }

    @Test
    public void testForwardWithGetAndModification() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map37.class, "Tuple1<Tuple1<String>>", "Tuple1<Tuple1<String>>");
    }

    @Test
    public void testForwardWithInheritance2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map38.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo2<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo2<field=String,field2=String>");
    }

    @Test
    public void testForwardWithGenericTypeOutput() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map39.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo");
    }

    @Test
    public void testForwardWithRecursion() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map40.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>");
    }

    @Test
    public void testForwardWithGetRuntimeContext() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(MapFunction.class, Map41.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>");
    }

    @Test
    public void testForwardWithCollector() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(FlatMapFunction.class, FlatMap1.class, "Tuple1<Integer>", "Tuple1<Integer>");
    }

    @Test
    public void testForwardWith2Collectors() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(FlatMapFunction.class, FlatMap2.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>");
    }

    @Test
    public void testForwardWithCollectorPassing() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInput(FlatMapFunction.class, FlatMap3.class, "Tuple1<Integer>", "Tuple1<Integer>");
    }

    @Test
    public void testForwardWithDualInput() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInput(JoinFunction.class, Join1.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>", "Tuple2<Long, Long>");
    }

    @Test
    public void testForwardWithDualInputAndCollector() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInput(FlatJoinFunction.class, Join2.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>", "Tuple2<Long, Long>");
    }

    @Test
    public void testForwardWithIterable() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce1.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>", new String[]{"0"});
    }

    @Test
    public void testForwardWithIterable2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce2.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>", new String[]{"0", "1"});
    }

    @Test
    public void testForwardWithIterable3() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce3.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", new String[]{"field2"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce4.class, "Tuple2<Long, Long>", "Long", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumptionForJavac() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce4_Javac.class, "Tuple2<Long, Long>", "Long", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption2() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce5.class, "Tuple2<Long, Long>", "Long", new String[]{"f1"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption3() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce6.class, "Tuple2<Long, Long>", "Long", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption4() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce7.class, "Tuple2<Long, Long>", "Long", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption5() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce8.class, "Tuple2<Long, Long>", "Long", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption6() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce9.class, "Tuple2<Long, Long>", "Tuple2<Long, Long>", new String[]{"f0"});
    }

    @Test
    public void testForwardWithAtLeastOneIterationAssumption7() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(GroupReduceFunction.class, GroupReduce10.class, "Tuple2<Long, Long>", "Boolean", new String[]{"f0"});
    }

    @Test
    public void testForwardWithReduce() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(ReduceFunction.class, Reduce1.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", new String[]{"field"});
    }

    @Test
    public void testForwardWithBranchingReduce() {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(ReduceFunction.class, Reduce2.class, "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", "org.apache.flink.api.java.sca.UdfAnalyzerTest$MyPojo<field=String,field2=String>", new String[]{"field"});
    }

    @Test
    public void testNullReturnException() {
        UdfAnalyzer ua2;
        try {
            ua2 = new UdfAnalyzer(MapFunction.class, NullReturnMapper1.class, "operator", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, null, true);
            ua2.analyze();
            Assert.fail();
        }
        catch (CodeErrorException ua2) {
            // empty catch block
        }
        try {
            ua2 = new UdfAnalyzer(MapFunction.class, NullReturnMapper2.class, "operator", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, null, true);
            ua2.analyze();
            Assert.fail();
        }
        catch (CodeErrorException ua3) {
            // empty catch block
        }
        try {
            ua2 = new UdfAnalyzer(FlatMapFunction.class, NullReturnFlatMapper.class, "operator", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, null, true);
            ua2.analyze();
            Assert.fail();
        }
        catch (CodeErrorException codeErrorException) {
            // empty catch block
        }
    }

    @Test
    public void testPutStaticException() {
        try {
            UdfAnalyzer ua = new UdfAnalyzer(MapFunction.class, PutStaticMapper.class, "operator", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, null, true);
            ua.analyze();
            Assert.fail();
        }
        catch (CodeErrorException codeErrorException) {
            // empty catch block
        }
    }

    @Test
    public void testFilterModificationException1() {
        try {
            UdfAnalyzer ua = new UdfAnalyzer(FilterFunction.class, FilterMod1.class, "operator", TypeInfoParser.parse((String)"Tuple2<String, String>"), null, null, null, null, true);
            ua.analyze();
            Assert.fail();
        }
        catch (CodeErrorException codeErrorException) {
            // empty catch block
        }
    }

    @Test
    public void testFilterModificationException2() {
        try {
            UdfAnalyzer ua = new UdfAnalyzer(FilterFunction.class, FilterMod2.class, "operator", TypeInfoParser.parse((String)"Tuple2<String, String>"), null, null, null, null, true);
            ua.analyze();
            Assert.fail();
        }
        catch (CodeErrorException codeErrorException) {
            // empty catch block
        }
    }

    public static void compareAnalyzerResultWithAnnotationsSingleInput(Class<?> baseClass, Class<?> clazz, String in, String out) {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsSingleInputWithKeys(baseClass, clazz, in, out, null);
    }

    public static void compareAnalyzerResultWithAnnotationsSingleInputWithKeys(Class<?> baseClass, Class<?> clazz, String in, String out, String[] keys) {
        TypeInformation inType = TypeInfoParser.parse((String)in);
        TypeInformation outType = TypeInfoParser.parse((String)out);
        Set annotations = FunctionAnnotation.readSingleForwardAnnotations(clazz);
        SingleInputSemanticProperties expected = SemanticPropUtil.getSemanticPropsSingle((Set)annotations, (TypeInformation)inType, (TypeInformation)outType);
        if (expected == null) {
            expected = new SingleInputSemanticProperties();
        }
        UdfAnalyzer ua = new UdfAnalyzer(baseClass, clazz, "operator", inType, null, outType, (Keys)(keys == null ? null : new Keys.ExpressionKeys(keys, inType)), null, true);
        ua.analyze();
        SingleInputSemanticProperties actual = (SingleInputSemanticProperties)ua.getSemanticProperties();
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    public static void compareAnalyzerResultWithAnnotationsDualInput(Class<?> baseClass, Class<?> clazz, String in1, String in2, String out) {
        UdfAnalyzerTest.compareAnalyzerResultWithAnnotationsDualInputWithKeys(baseClass, clazz, in1, in2, out, null, null);
    }

    public static void compareAnalyzerResultWithAnnotationsDualInputWithKeys(Class<?> baseClass, Class<?> clazz, String in1, String in2, String out, String[] keys1, String[] keys2) {
        TypeInformation in1Type = TypeInfoParser.parse((String)in1);
        TypeInformation in2Type = TypeInfoParser.parse((String)in2);
        TypeInformation outType = TypeInfoParser.parse((String)out);
        Set annotations = FunctionAnnotation.readDualForwardAnnotations(clazz);
        DualInputSemanticProperties expected = SemanticPropUtil.getSemanticPropsDual((Set)annotations, (TypeInformation)in1Type, (TypeInformation)in2Type, (TypeInformation)outType);
        UdfAnalyzer ua = new UdfAnalyzer(baseClass, clazz, "operator", in1Type, in2Type, outType, (Keys)(keys1 == null ? null : new Keys.ExpressionKeys(keys1, in1Type)), (Keys)(keys2 == null ? null : new Keys.ExpressionKeys(keys2, in2Type)), true);
        ua.analyze();
        DualInputSemanticProperties actual = (DualInputSemanticProperties)ua.getSemanticProperties();
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    public static class ExtendingTuple
    extends Tuple2<String, String> {
        public void setFirstField() {
            this.setField("Hello", 0);
        }

        public String getSecondField() {
            return (String)this.getField(1);
        }
    }

    public static class MyPojo2
    extends MyPojo {
    }

    public static class MyPojo {
        private String field;
        public String field2;

        public MyPojo() {
        }

        public MyPojo(String field, String field2) {
            this.field = field;
            this.field2 = field2;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }
    }

    public static class FilterMod2
    implements FilterFunction<Tuple2<String, String>> {
        public boolean filter(Tuple2<String, String> value) throws Exception {
            value.f0 = "";
            return false;
        }
    }

    public static class FilterMod1
    implements FilterFunction<Tuple2<String, String>> {
        public boolean filter(Tuple2<String, String> value) throws Exception {
            value.f0 = value.f1;
            return false;
        }
    }

    public static class PutStaticMapper
    implements MapFunction<String, String> {
        public static String test = "";

        public String map(String value) throws Exception {
            test = "test";
            return "";
        }
    }

    public static class NullReturnFlatMapper
    implements FlatMapFunction<String, String> {
        public void flatMap(String value, Collector<String> out) throws Exception {
            String s = null;
            if ("dd".equals("")) {
                s = "";
            }
            out.collect((Object)s);
        }
    }

    public static class NullReturnMapper2
    implements MapFunction<String, String> {
        public String map(String value) throws Exception {
            if (value.equals("test")) {
                return null;
            }
            return "";
        }
    }

    public static class NullReturnMapper1
    implements MapFunction<String, String> {
        public String map(String value) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field"})
    public static class Reduce2
    implements ReduceFunction<MyPojo> {
        public MyPojo reduce(MyPojo value1, MyPojo value2) throws Exception {
            if (value1.field == "") {
                return value2;
            }
            return value1;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field"})
    public static class Reduce1
    implements ReduceFunction<MyPojo> {
        public MyPojo reduce(MyPojo value1, MyPojo value2) throws Exception {
            return new MyPojo(value1.getField(), value2.getField2());
        }
    }

    public static class GroupReduce10
    implements GroupReduceFunction<Tuple2<Long, Long>, Boolean> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Boolean> out) throws Exception {
            Iterator<Tuple2<Long, Long>> it = values.iterator();
            boolean f = it.hasNext();
            if (!f) {
                System.out.println();
            }
            if (f) {
                System.out.println();
            }
            out.collect((Object)f);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0"})
    public static class GroupReduce9
    implements GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long>> out) throws Exception {
            Tuple2<Long, Long> rv2 = null;
            for (Tuple2<Long, Long> rv2 : values) {
            }
            out.collect(rv2);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->*"})
    public static class GroupReduce8
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            Iterator<Tuple2<Long, Long>> it = values.iterator();
            while (it.hasNext()) {
                id = (Long)it.next().f0;
            }
            out.collect((Object)id);
        }
    }

    public static class GroupReduce7
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            for (Tuple2<Long, Long> value : values) {
                id = (Long)value.f0;
            }
            id = 0L;
            out.collect((Object)id);
        }
    }

    public static class GroupReduce6
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            for (Tuple2<Long, Long> value : values) {
                id = (Long)value.f0;
            }
            id = 0L;
            out.collect((Object)id);
        }
    }

    public static class GroupReduce5
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            for (Tuple2<Long, Long> value : values) {
                id = (Long)value.f0;
                if (value == null) continue;
                id = (Long)value.f1;
            }
            out.collect((Object)id);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->*"})
    public static class GroupReduce4_Javac
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            Iterator<Tuple2<Long, Long>> it = values.iterator();
            if (it.hasNext()) {
                id = (Long)it.next().f0;
            } else {
                System.out.println("hello world");
            }
            out.collect((Object)id);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->*"})
    public static class GroupReduce4
    implements GroupReduceFunction<Tuple2<Long, Long>, Long> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Long> out) throws Exception {
            Long id = 0L;
            for (Tuple2<Long, Long> value : values) {
                id = (Long)value.f0;
            }
            out.collect((Object)id);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field2"})
    public static class GroupReduce3
    implements GroupReduceFunction<MyPojo, MyPojo> {
        public void reduce(Iterable<MyPojo> values, Collector<MyPojo> out) throws Exception {
            for (MyPojo value : values) {
                out.collect((Object)value);
            }
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1->0"})
    public static class GroupReduce2
    implements GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long>> out) throws Exception {
            Iterator<Tuple2<Long, Long>> it = values.iterator();
            Tuple2 outTuple = new Tuple2();
            Tuple2<Long, Long> first = it.next();
            outTuple.f0 = first.f1;
            outTuple.f1 = first.f0;
            while (it.hasNext()) {
                Tuple2<Long, Long> t = it.next();
                if ((Long)t.f0 != 42L) continue;
                Tuple2 tuple2 = outTuple;
                Long.valueOf((Long)tuple2.f1 + (Long)t.f0);
                tuple2.f1 = tuple2.f1;
            }
            out.collect((Object)outTuple);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    public static class GroupReduce1
    implements GroupReduceFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void reduce(Iterable<Tuple2<Long, Long>> values, Collector<Tuple2<Long, Long>> out) throws Exception {
            out.collect(values.iterator().next());
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*"})
    public static class Join2
    implements FlatJoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public void join(Tuple2<Long, Long> candidate, Tuple2<Long, Long> old, Collector<Tuple2<Long, Long>> out) {
            if ((Long)candidate.f1 < (Long)old.f1) {
                out.collect(candidate);
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f1->f1"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f0"})
    public static class Join1
    implements JoinFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public Tuple2<Long, Long> join(Tuple2<Long, Long> vertexWithComponent, Tuple2<Long, Long> edge) {
            return new Tuple2(edge.f1, vertexWithComponent.f1);
        }
    }

    public static class FlatMap3
    implements FlatMapFunction<Tuple1<Integer>, Tuple1<Integer>> {
        public void flatMap(Tuple1<Integer> value, Collector<Tuple1<Integer>> out) throws Exception {
            this.addToCollector(out);
            out.collect(value);
        }

        private void addToCollector(Collector<Tuple1<Integer>> out) {
            out.collect((Object)new Tuple1());
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->1;1->0"})
    public static class FlatMap2
    implements FlatMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        Tuple2<Long, Long> invertedEdge = new Tuple2();

        public void flatMap(Tuple2<Long, Long> edge, Collector<Tuple2<Long, Long>> out) {
            this.invertedEdge.f0 = edge.f1;
            this.invertedEdge.f1 = edge.f0;
            out.collect(this.invertedEdge);
            out.collect(this.invertedEdge);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    public static class FlatMap1
    implements FlatMapFunction<Tuple1<Integer>, Tuple1<Integer>> {
        public void flatMap(Tuple1<Integer> value, Collector<Tuple1<Integer>> out) throws Exception {
            out.collect(value);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field;field2"})
    public static class Map41
    extends RichMapFunction<MyPojo, MyPojo> {
        private MyPojo field;

        public MyPojo map(MyPojo value) throws Exception {
            this.field = value;
            this.getRuntimeContext().getIntCounter("test").getLocalValue();
            return this.field;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field2"})
    public static class Map40
    implements MapFunction<MyPojo, MyPojo> {
        public MyPojo map(MyPojo value) throws Exception {
            return this.recursiveFunction(value);
        }

        private MyPojo recursiveFunction(MyPojo value) {
            if (value.field == "xyz") {
                value.field = value.field + "x";
                return this.recursiveFunction(value);
            }
            return value;
        }
    }

    public static class Map39
    implements MapFunction<MyPojo, MyPojo> {
        public MyPojo map(MyPojo value) throws Exception {
            MyPojo mp = new MyPojo();
            mp.field = value.field2;
            return mp;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field"})
    public static class Map38
    implements MapFunction<MyPojo2, MyPojo2> {
        public MyPojo2 map(MyPojo2 value) throws Exception {
            value.setField2("test");
            return value;
        }
    }

    public static class Map37
    implements MapFunction<Tuple1<Tuple1<String>>, Tuple1<Tuple1<String>>> {
        public Tuple1<Tuple1<String>> map(Tuple1<Tuple1<String>> value) throws Exception {
            ((Tuple1)value.getField((int)Integer.valueOf((String)"2.").intValue())).f0 = "Hello";
            return value;
        }
    }

    public static class Map36
    implements MapFunction<Tuple3<String, String, String>, Tuple3<String, String, String>> {
        public Tuple3<String, String, String> map(Tuple3<String, String, String> value) throws Exception {
            int i = 0;
            do {
                value.setField((Object)"", i);
            } while (++i >= 2);
            return value;
        }
    }

    public static class Map35
    implements MapFunction<String[], Tuple2<String[], String[]>> {
        public Tuple2<String[], String[]> map(String[] value) throws Exception {
            String[] tmp = value;
            value[0] = "Hello";
            return new Tuple2((Object)value, (Object)tmp);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1"})
    public static class Map34
    implements MapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private Tuple2<Long, Long> t;

        public Tuple2<Long, Long> map(Tuple2<Long, Long> value) throws Exception {
            if (value != new Object()) {
                return value;
            }
            if ((Long)value.f0 == 1L && (Long)value.f1 == 2L) {
                this.t = value;
                this.t.f0 = 23L;
                return this.t;
            }
            return new Tuple2(value.f0, value.f1);
        }
    }

    public static class Map33
    implements MapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        public Tuple2<Long, Long> map(Tuple2<Long, Long> value) throws Exception {
            Tuple2 t = new Tuple2();
            t.f0 = value.f0 != null ? value.f0 : value.f1;
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    public static class Map32
    implements MapFunction<Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double>, Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double>> {
        public Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double> map(Tuple8<Boolean, Character, Byte, Short, Integer, Long, Float, Double> value) throws Exception {
            boolean f0 = (Boolean)value.f0;
            char f1 = ((Character)value.f1).charValue();
            byte f2 = (Byte)value.f2;
            short f3 = (Short)value.f3;
            int f4 = (Integer)value.f4;
            long f5 = (Long)value.f5;
            float f6 = ((Float)value.f6).floatValue();
            double f7 = (Double)value.f7;
            return new Tuple8((Object)f0, (Object)Character.valueOf(f1), (Object)f2, (Object)f3, (Object)f4, (Object)f5, (Object)Float.valueOf(f6), (Object)f7);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"1->1;1->0"})
    public static class Map31
    implements MapFunction<Tuple2<String, String>, ExtendingTuple> {
        public ExtendingTuple map(Tuple2<String, String> value) throws Exception {
            ExtendingTuple t = new ExtendingTuple();
            t.f1 = value.f1;
            t.setFirstField();
            t.f0 = t.getSecondField();
            return t;
        }
    }

    public static class Map30
    implements MapFunction<Tuple2<String, String>, String> {
        public String map(Tuple2<String, String> value) throws Exception {
            String tmp = ((String)value.f0).equals("") ? (String)value.f0 : (String)value.f1;
            return tmp;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0"})
    public static class Map29
    implements MapFunction<Tuple3<String, String, String>, Tuple3<String, String, String>> {
        public Tuple3<String, String, String> map(Tuple3<String, String, String> value) throws Exception {
            String tmp = (String)value.f0;
            for (int i = 0; i < 2; ++i) {
                value.setField((Object)"Test", i);
            }
            Tuple3 tuple = ((String)value.f0).equals("x") ? new Tuple3((Object)tmp, value.f0, null) : new Tuple3((Object)tmp, value.f0, (Object)"");
            return tuple;
        }
    }

    public static class Map28
    implements MapFunction<Integer, Integer> {
        public Integer map(Integer value) throws Exception {
            if (value == null) {
                value = 123;
            }
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"2->3;3->7"})
    public static class Map27
    implements MapFunction<Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>, Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>> {
        public Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer> map(Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer> value) throws Exception {
            Tuple8 tuple = new Tuple8();
            if (tuple.f0 == null) {
                tuple.setField((Object)123456, 0);
            } else {
                tuple.setField(value.f0, 0);
            }
            tuple.setField(value.f2, 3);
            tuple.setField(value.f3, 7);
            return tuple;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->1"})
    public static class Map26
    implements MapFunction<Integer, Tuple2<Integer, Integer>> {
        public Tuple2<Integer, Integer> map(Integer value) throws Exception {
            Tuple2 tuple = new Tuple2();
            if (tuple.equals((Object)new Tuple2())) {
                tuple.f0 = 123456;
            }
            if (tuple.equals((Object)new Tuple2())) {
                tuple.f0 = value;
            }
            tuple.f1 = value;
            return tuple;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f1->f0;f1"})
    public static class Map25
    implements MapFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public Tuple2<Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            value.f0 = value.f1;
            return value;
        }
    }

    public static class Map24
    implements MapFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public Tuple2<Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            value.setField((Object)2, 0);
            int i = 5;
            value.setField((Object)(i * i + 2), 1);
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    public static class Map23
    implements MapFunction<Tuple1<Integer>, Tuple1<Integer>> {
        public Tuple1<Integer> map(Tuple1<Integer> value) throws Exception {
            if (((Integer)value.f0).equals(23)) {
                return new Tuple1(value.getField(0));
            }
            if (((Integer)value.f0).equals(22)) {
                Tuple1 inputContainer = new Tuple1();
                inputContainer.f0 = value.f0;
                return new Tuple1(inputContainer.getField(0));
            }
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f1;f1->f0"})
    public static class Map22
    implements MapFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public Tuple2<Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            Tuple2 t = new Tuple2();
            t.setField(value.f1, 0);
            t.setField(value.getField(0), 1);
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f1;f1->f0"})
    public static class Map21
    implements MapFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        public Tuple2<Integer, Integer> map(Tuple2<Integer, Integer> value) throws Exception {
            Integer i = (Integer)value.f0;
            value.setField(value.f1, 0);
            value.setField((Object)i, 1);
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0;f1"})
    public static class Map20
    implements MapFunction<Tuple4<Integer, Integer, Integer, Integer>, Tuple4<Integer, Integer, Integer, Integer>> {
        public Tuple4<Integer, Integer, Integer, Integer> map(Tuple4<Integer, Integer, Integer, Integer> value) throws Exception {
            Tuple4 t = new Tuple4();
            t.f0 = value.getField(0);
            t.f1 = value.getField(1);
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public static class Map19
    implements MapFunction<Integer, Tuple1<Integer>> {
        public Tuple1<Integer> map(Integer value) throws Exception {
            Tuple1 tuple = new Tuple1();
            tuple.f0 = value;
            Tuple1 tuple2 = new Tuple1();
            tuple2.f0 = tuple.f0;
            return tuple2;
        }
    }

    public static class Map18
    implements MapFunction<Tuple1<String>, ArrayList<String>> {
        private ArrayList<String> list = new ArrayList();

        public ArrayList<String> map(Tuple1<String> value) throws Exception {
            this.list.add((String)value.f0);
            return this.list;
        }
    }

    public static class Map17
    implements MapFunction<String, Tuple1<String>> {
        private Tuple1<String> tuple = new Tuple1();

        public Tuple1<String> map(String value) throws Exception {
            this.tuple.f0 = !((String)this.tuple.f0).equals("") ? "empty" : value;
            return this.tuple;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field->field2;field2->field"})
    public static class Map16
    implements MapFunction<MyPojo, MyPojo> {
        public MyPojo map(MyPojo value) throws Exception {
            MyPojo p = new MyPojo();
            p.setField(value.getField2());
            p.setField2(value.getField());
            return p;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0.f0->f0"})
    public static class Map15
    implements MapFunction<Tuple2<Tuple1<String>, Integer>, Tuple2<String, String>> {
        public Tuple2<String, String> map(Tuple2<Tuple1<String>, Integer> value) throws Exception {
            Tuple2 t = new Tuple2();
            t.f0 = ((Tuple1)value.f0).f0;
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0"})
    public static class Map14
    implements MapFunction<Tuple2<String, Integer>, Tuple2<String, String>> {
        public Tuple2<String, String> map(Tuple2<String, Integer> value) throws Exception {
            Tuple2 t = new Tuple2();
            t.f0 = value.f0;
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f1.f0"})
    public static class Map13
    implements MapFunction<Tuple2<String, Integer>, Tuple2<Tuple1<String>, Tuple1<String>>> {
        public Tuple2<Tuple1<String>, Tuple1<String>> map(Tuple2<String, Integer> value) throws Exception {
            Tuple2 t = new Tuple2((Object)new Tuple1(value.f0), (Object)new Tuple1(value.f0));
            t.f0 = null;
            return t;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f0.f0;f0->f1.f0"})
    public static class Map12
    implements MapFunction<Tuple2<String, Integer>, Tuple2<Tuple1<String>, Tuple1<String>>> {
        public Tuple2<Tuple1<String>, Tuple1<String>> map(Tuple2<String, Integer> value) throws Exception {
            return new Tuple2((Object)new Tuple1(value.f0), (Object)new Tuple1(value.f0));
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f1"})
    public static class Map11
    implements MapFunction<String, Tuple2<String, String>> {
        private Tuple2<String, String> tuple = new Tuple2();

        public Tuple2<String, String> map(String value) throws Exception {
            this.tuple.f0 = value;
            this.modify();
            this.tuple.f1 = value;
            return this.tuple;
        }

        private void modify() {
            this.tuple.f0 = null;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0.f0"})
    public static class Map10
    implements MapFunction<String, Tuple1<Tuple1<String>>> {
        private Tuple1<Tuple1<String>> tuple = new Tuple1();

        public Tuple1<Tuple1<String>> map(String value) throws Exception {
            ((Tuple1)this.tuple.f0).f0 = value;
            return this.tuple;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*->f0"})
    public static class Map9
    implements MapFunction<String, Tuple1<String>> {
        private Tuple1<String> tuple = new Tuple1();

        public Tuple1<String> map(String value) throws Exception {
            this.tuple.f0 = value;
            return this.tuple;
        }
    }

    public static class Map8
    implements MapFunction<Tuple2<String, String>, String> {
        public String map(Tuple2<String, String> value) throws Exception {
            if (((String)value.f0).equals("whatever")) {
                return (String)value.f0;
            }
            return (String)value.f1;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f1"})
    public static class Map7
    implements MapFunction<Tuple2<String, Integer>, Tuple2<String, String>> {
        public Tuple2<String, String> map(Tuple2<String, Integer> value) throws Exception {
            if (((String)value.f0).equals("whatever")) {
                return new Tuple2(value.f0, value.f0);
            }
            return new Tuple2((Object)"hello", value.f0);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field->*"})
    public static class Map6
    implements MapFunction<MyPojo, String> {
        public String map(MyPojo value) throws Exception {
            return value.field;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"field2->*"})
    public static class Map5
    implements MapFunction<MyPojo, String> {
        public String map(MyPojo value) throws Exception {
            return value.field2;
        }
    }

    public static class Map4
    implements MapFunction<MyPojo, String> {
        public String map(MyPojo value) throws Exception {
            return value.field2;
        }
    }

    public static class Map3
    implements MapFunction<String[], Integer> {
        public Integer map(String[] value) throws Exception {
            return value.length;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->f0;f0->f1"})
    public static class Map2
    implements MapFunction<Tuple2<String, Integer>, Tuple2<String, String>> {
        public Tuple2<String, String> map(Tuple2<String, Integer> value) throws Exception {
            return new Tuple2(value.f0, value.f0);
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0->*"})
    public static class Map1
    implements MapFunction<Tuple2<String, Integer>, String> {
        public String map(Tuple2<String, Integer> value) throws Exception {
            return (String)value.f0;
        }
    }
}

