/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinOperatorTest {
    private static final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>> emptyNestedTupleData = new ArrayList<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Tuple2<Integer, String>, Long, String, Long, Integer>> nestedTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static final List<Tuple5<CustomType, Long, String, Long, Integer>> emptyNestedCustomTupleData = new ArrayList<Tuple5<CustomType, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<CustomType, Long, String, Long, Integer>> nestedCustomTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{TypeExtractor.getForClass(CustomType.class), BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private static List<CustomTypeWithTuple> customTypeWithTupleData = new ArrayList<CustomTypeWithTuple>();
    private static List<CustomType> customTypeData = new ArrayList<CustomType>();
    private static List<NestedCustomType> customNestedTypeData = new ArrayList<NestedCustomType>();

    @BeforeClass
    public static void insertCustomData() {
        customTypeData.add(new CustomType());
        customTypeWithTupleData.add(new CustomTypeWithTuple());
        customNestedTypeData.add(new NestedCustomType());
    }

    @Test
    public void testJoinKeyFields1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyFields2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{2});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyFields3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0, 1}).equalTo(new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinKeyFields4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{5}).equalTo(new int[]{0});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinKeyFields5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{-1}).equalTo(new int[]{-1});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyFields6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new int[]{4}).equalTo(new int[]{0});
    }

    @Test
    public void testJoinKeyExpressions1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyExpressionsNested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customNestedTypeData);
        DataSource ds2 = env.fromCollection(customNestedTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyExpressions2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyExpressions3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"myInt", "myString"}).equalTo(new String[]{"myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testJoinKeyExpressions4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"myNonExistent"}).equalTo(new String[]{"myInt"});
    }

    @Test
    public void testJoinKeyMixedKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo((KeySelector)new KeySelector<CustomType, Integer>(){

                public Integer getKey(CustomType value) throws Exception {
                    return value.myInt;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyMixedKeySelectorTurned() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Integer>(){

                public Integer getKey(CustomType value) throws Exception {
                    return value.myInt;
                }
            }).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyMixedTupleIndex() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"f0"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyNestedTuples() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedTupleData, this.nestedTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"f0.f0"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyNestedTuplesWithCustom() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedCustomTupleData, this.nestedCustomTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            TypeInformation t = ds1.join((DataSet)ds2).where(new String[]{"f0.myInt"}).equalTo(new int[]{4}).getType();
            Assert.assertTrue((String)"not a composite type", (boolean)(t instanceof CompositeType));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyWithCustomContainingTuple0() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"intByString.f0"}).equalTo(new String[]{"myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyWithCustomContainingTuple1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"intByString.f0"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyWithCustomContainingTuple2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeWithTupleData);
        DataSource ds2 = env.fromCollection(customTypeWithTupleData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt", "myInt", "intByString.f1"}).equalTo(new String[]{"intByString.f0", "myInt", "myString"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyNestedTuplesWrongType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyNestedTupleData, this.nestedTupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"f0.f1"}).equalTo(new int[]{4});
    }

    @Test
    public void testJoinKeyMixedTupleIndexTurned() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"f0"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyMixedTupleIndexWrongType() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"f0"}).equalTo(new int[]{3});
    }

    @Test
    public void testJoinKeyMixedTupleIndex2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"myInt"}).equalTo(new int[]{4});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyMixedWrong() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"myString"}).equalTo((KeySelector)new KeySelector<CustomType, Integer>(){

            public Integer getKey(CustomType value) throws Exception {
                return value.myInt;
            }
        });
    }

    @Test
    public void testJoinKeyExpressions1Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myInt"});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyExpressions2Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"nested.myInt"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyExpressions3Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"nested.myInt", "nested.myString"}).equalTo(new String[]{"nested.myString"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testJoinKeyExpressions4Nested() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new String[]{"nested.myNonExistent"}).equalTo(new String[]{"nested.myInt"});
    }

    @Test
    public void testJoinKeySelectors1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyMixing1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).equalTo(new int[]{3});
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinKeyMixing2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where(new int[]{3}).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            });
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyMixing3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new int[]{2}).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

            public Long getKey(CustomType value) {
                return value.myLong;
            }
        });
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyMixing4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(customTypeData);
        ds1.join((DataSet)ds2).where(new int[]{1, 3}).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

            public Long getKey(CustomType value) {
                return value.myLong;
            }
        });
    }

    @Test
    public void testJoinKeyAtomic1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"*"}).equalTo(new int[]{0});
    }

    @Test
    public void testJoinKeyAtomic2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"*"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"*", "invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"*", "invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new String[]{"invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new String[]{"invalidKey"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        DataSource ds2 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        ds1.join((DataSet)ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    @Test(expected=InvalidProgramException.class)
    public void testJoinKeyInvalidAtomic6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromElements((Object[])new Integer[]{0, 0, 0});
        DataSource ds2 = env.fromElements((Object[])new ArrayList[]{new ArrayList()});
        ds1.join((DataSet)ds2).where(new String[]{"*"}).equalTo(new String[]{"*"});
    }

    @Test
    public void testJoinProjection1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection21() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0});
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{-1});
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).project(new int[]{9});
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{3});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 2}).projectSecond(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{0, 2}).projectFirst(new int[]{1, 4}).projectFirst(new int[]{1});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            System.out.println("FAILED: " + e);
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection26() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(customTypeData);
        DataSource ds2 = env.fromCollection(customTypeData);
        try {
            ds1.join((DataSet)ds2).where((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).equalTo((KeySelector)new KeySelector<CustomType, Long>(){

                public Long getKey(CustomType value) {
                    return value.myLong;
                }
            }).projectFirst(new int[0]).projectSecond(new int[0]);
        }
        catch (Exception e) {
            System.out.println("FAILED: " + e);
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection7() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJoinProjection27() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        try {
            ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[0]).projectFirst(new int[]{1, 4});
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection8() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection28() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection9() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection29() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{5});
    }

    public void testJoinProjection10() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection30() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{-1});
    }

    public void testJoinProjection11() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{2});
    }

    public void testJoinProjection12() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{2}).projectFirst(new int[]{1});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection13() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{0}).projectFirst(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection33() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectSecond(new int[]{-1}).projectFirst(new int[]{3});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection14() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{5});
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testJoinProjection34() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource ds2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        ds1.join((DataSet)ds2).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0}).projectSecond(new int[]{-1});
    }

    @Test
    public void testSemanticPropsWithKeySelector1() {
        DataSource tupleDs2;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator.EquiJoin joinOp = tupleDs1.join((DataSet)(tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo))).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((JoinFunction)new DummyTestJoinFunction1());
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(6)));
        Assert.assertTrue((semProps.getReadFields(1).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)semProps.getReadFields(1).contains(Integer.valueOf(5)));
    }

    @Test
    public void testSemanticPropsWithKeySelector2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator joinOp = (JoinOperator)((JoinOperator)tupleDs1.join((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).with((JoinFunction)new DummyTestJoinFunction2()).withForwardedFieldsFirst(new String[]{"2;4->0"})).withForwardedFieldsSecond(new String[]{"0->4;1;1->3"});
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)semProps.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getReadFields(1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testSemanticPropsWithKeySelector3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs1 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        DataSource tupleDs2 = env.fromCollection(emptyTupleData, this.tupleTypeInfo);
        JoinOperator.ProjectJoin joinOp = tupleDs1.join((DataSet)tupleDs2).where((KeySelector)new DummyTestKeySelector()).equalTo((KeySelector)new DummyTestKeySelector()).projectFirst(new int[]{2}).projectSecond(new int[]{0, 0, 3}).projectFirst(new int[]{0, 4}).projectSecond(new int[]{2});
        DualInputSemanticProperties semProps = joinOp.getSemanticProperties();
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(0, 6).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(0, 6).contains(Integer.valueOf(5)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 2).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 4).contains(Integer.valueOf(6)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 5).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)semProps.getForwardingTargetFields(1, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((semProps.getForwardingTargetFields(1, 6).size() == 0 ? 1 : 0) != 0);
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"0;1;2"})
    public static class DummyTestJoinFunction2
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        public Tuple5<Integer, Long, String, Long, Integer> join(Tuple5<Integer, Long, String, Long, Integer> first, Tuple5<Integer, Long, String, Long, Integer> second) throws Exception {
            return new Tuple5();
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->4;1;1->3"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"2;4->0"})
    @FunctionAnnotation.ReadFieldsFirst(value={"0;2;4"})
    @FunctionAnnotation.ReadFieldsSecond(value={"1;3"})
    public static class DummyTestJoinFunction1
    implements JoinFunction<Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>, Tuple5<Integer, Long, String, Long, Integer>> {
        public Tuple5<Integer, Long, String, Long, Integer> join(Tuple5<Integer, Long, String, Long, Integer> first, Tuple5<Integer, Long, String, Long, Integer> second) throws Exception {
            return new Tuple5();
        }
    }

    public static class DummyTestKeySelector
    implements KeySelector<Tuple5<Integer, Long, String, Long, Integer>, Tuple2<Long, Integer>> {
        public Tuple2<Long, Integer> getKey(Tuple5<Integer, Long, String, Long, Integer> value) throws Exception {
            return new Tuple2();
        }
    }

    public static class CustomTypeWithTuple
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public NestedCustomType nested;
        public String myString;
        public Tuple2<Integer, String> intByString;

        public CustomTypeWithTuple() {
        }

        public CustomTypeWithTuple(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
            this.nested = new NestedCustomType(i, l, s);
            this.intByString = new Tuple2((Object)i, (Object)s);
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public NestedCustomType nested;
        public String myString;
        public Object nothing;
        public List<String> countries;
        public Writable interfaceTest;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
            this.countries = null;
            this.interfaceTest = null;
            this.nested = new NestedCustomType(i, l, s);
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }

    public static class NestedCustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;
        public Nested nest;

        public NestedCustomType() {
        }

        public NestedCustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString + "," + this.nest;
        }
    }

    public static class Nested
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;

        public Nested() {
        }

        public Nested(int i, long l, String s) {
            this.myInt = i;
        }

        public String toString() {
            return "" + this.myInt;
        }
    }
}

