/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSinkTest {
    private final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final List<CustomType> pojoData = new ArrayList<CustomType>();

    @Before
    public void fillPojoData() {
        if (this.pojoData.isEmpty()) {
            this.pojoData.add(new CustomType());
        }
    }

    @Test
    public void testTupleSingleOrderIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ANY);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testTupleTwoOrderIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ASCENDING).sortLocalOutput(3, Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testTupleSingleOrderExp() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("f0", Order.ANY);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public void testTupleSingleOrderExpFull() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ANY);
    }

    @Test
    public void testTupleTwoOrderExp() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("f1", Order.ASCENDING).sortLocalOutput("f4", Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testTupleTwoOrderMixed() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        try {
            tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(4, Order.ASCENDING).sortLocalOutput("f2", Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testFailTupleIndexOutOfBounds() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(3, Order.ASCENDING).sortLocalOutput(5, Order.DESCENDING);
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testFailTupleInv() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("notThere", Order.ASCENDING).sortLocalOutput("f4", Order.DESCENDING);
    }

    @Test
    public void testPrimitiveOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        try {
            longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testFailPrimitiveOrder1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(0, Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFailPrimitiveOrder2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("0", Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testFailPrimitiveOrder3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource longDs = env.generateSequence(0L, 2L);
        longDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("nope", Order.ASCENDING);
    }

    @Test
    public void testPojoSingleOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        try {
            pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myString", Order.ASCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testPojoTwoOrder() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        try {
            pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myLong", Order.ASCENDING).sortLocalOutput("myString", Order.DESCENDING);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testFailPojoIdx() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput(1, Order.DESCENDING);
    }

    @Test(expected=CompositeType.InvalidFieldReferenceException.class)
    public void testFailPojoInvalidField() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("myInt", Order.ASCENDING).sortLocalOutput("notThere", Order.DESCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testPojoSingleOrderFull() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(this.pojoData);
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
    }

    @Test(expected=InvalidProgramException.class)
    public void testArrayOrderFull() {
        ArrayList<Object[]> arrayData = new ArrayList<Object[]>();
        arrayData.add(new Object[0]);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource pojoDs = env.fromCollection(arrayData);
        pojoDs.writeAsText("/tmp/willNotHappen").sortLocalOutput("*", Order.ASCENDING);
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;
        public long myLong;
        public String myString;

        public CustomType() {
        }

        public CustomType(int i, long l, String s) {
            this.myInt = i;
            this.myLong = l;
            this.myString = s;
        }

        public String toString() {
            return this.myInt + "," + this.myLong + "," + this.myString;
        }
    }
}

