/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.IOException;
import org.apache.flink.api.java.hadoop.mapred.HadoopOutputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HadoopOutputFormatTest {
    @Test
    public void testOpen() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        JobConf jobConf = (JobConf)Mockito.spy((Object)new JobConf());
        Mockito.when((Object)jobConf.getOutputCommitter()).thenReturn((Object)outputCommitter);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.open(1, 1);
        ((JobConf)Mockito.verify((Object)jobConf, (VerificationMode)Mockito.times((int)2))).getOutputCommitter();
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).setupJob((JobContext)Mockito.any(JobContext.class));
        ((OutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).getRecordWriter((FileSystem)Mockito.any(FileSystem.class), (JobConf)Mockito.any(JobConf.class), Matchers.anyString(), (Progressable)Mockito.any(Progressable.class));
    }

    @Test
    public void testConfigureWithConfigurable() {
        ConfigurableDummyOutputFormat dummyOutputFormat = (ConfigurableDummyOutputFormat)Mockito.mock(ConfigurableDummyOutputFormat.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat((OutputFormat)dummyOutputFormat, jobConf);
        outputFormat.configure((Configuration)Matchers.any());
        ((ConfigurableDummyOutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).setConf((org.apache.hadoop.conf.Configuration)Mockito.any(org.apache.hadoop.conf.Configuration.class));
    }

    @Test
    public void testConfigureWithJobConfigurable() {
        JobConfigurableDummyOutputFormat dummyOutputFormat = (JobConfigurableDummyOutputFormat)Mockito.mock(JobConfigurableDummyOutputFormat.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat((OutputFormat)dummyOutputFormat, jobConf);
        outputFormat.configure((Configuration)Matchers.any());
        ((JobConfigurableDummyOutputFormat)Mockito.verify((Object)dummyOutputFormat, (VerificationMode)Mockito.times((int)1))).configure((JobConf)Mockito.any(JobConf.class));
    }

    @Test
    public void testCloseWithTaskCommit() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        Mockito.when((Object)outputCommitter.needsTaskCommit((TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn((Object)true);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.outputCommitter = outputCommitter;
        outputFormat.close();
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((Reporter)Mockito.any(Reporter.class));
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).commitTask((TaskAttemptContext)Mockito.any(TaskAttemptContext.class));
    }

    @Test
    public void testCloseWithoutTaskCommit() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        Mockito.when((Object)outputCommitter.needsTaskCommit((TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn((Object)false);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.outputCommitter = outputCommitter;
        outputFormat.close();
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).close((Reporter)Mockito.any(Reporter.class));
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)0)))).commitTask((TaskAttemptContext)Mockito.any(TaskAttemptContext.class));
    }

    @Test
    public void testWriteRecord() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyRecordWriter recordWriter = (DummyRecordWriter)Mockito.mock(DummyRecordWriter.class);
        JobConf jobConf = (JobConf)Mockito.mock(JobConf.class);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.recordWriter = recordWriter;
        outputFormat.writeRecord(new Tuple2((Object)"key", (Object)1L));
        ((DummyRecordWriter)Mockito.verify((Object)recordWriter, (VerificationMode)Mockito.times((int)1))).write(Matchers.anyString(), Mockito.anyLong());
    }

    @Test
    public void testFinalizeGlobal() throws Exception {
        OutputFormat dummyOutputFormat = (OutputFormat)Mockito.mock(DummyOutputFormat.class);
        DummyOutputCommitter outputCommitter = (DummyOutputCommitter)((Object)Mockito.mock(DummyOutputCommitter.class));
        JobConf jobConf = (JobConf)Mockito.spy((Object)new JobConf());
        Mockito.when((Object)jobConf.getOutputCommitter()).thenReturn((Object)outputCommitter);
        HadoopOutputFormat outputFormat = new HadoopOutputFormat(dummyOutputFormat, jobConf);
        outputFormat.finalizeGlobal(1);
        ((DummyOutputCommitter)((Object)Mockito.verify((Object)((Object)outputCommitter), (VerificationMode)Mockito.times((int)1)))).commitJob((JobContext)Mockito.any(JobContext.class));
    }

    public class DummyRecordWriter
    implements RecordWriter<String, Long> {
        public void write(String s, Long aLong) throws IOException {
        }

        public void close(Reporter reporter) throws IOException {
        }
    }

    public class DummyOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        }
    }

    public class JobConfigurableDummyOutputFormat
    extends DummyOutputFormat
    implements JobConfigurable {
        public void configure(JobConf jobConf) {
        }
    }

    public class ConfigurableDummyOutputFormat
    extends DummyOutputFormat
    implements Configurable {
        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
        }

        public org.apache.hadoop.conf.Configuration getConf() {
            return null;
        }
    }

    public class DummyOutputFormat
    implements OutputFormat<String, Long> {
        public RecordWriter<String, Long> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
        }
    }
}

