/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.junit.Assert;

public class TupleSerializerTestInstance<T extends Tuple>
extends SerializerTestInstance<T> {
    public TupleSerializerTestInstance(TypeSerializer<T> serializer, Class<T> typeClass, int length, T[] testData) {
        super(serializer, typeClass, length, (Object[])testData);
    }

    protected void deepEquals(String message, T shouldTuple, T isTuple) {
        Assert.assertEquals((long)shouldTuple.getArity(), (long)isTuple.getArity());
        for (int i = 0; i < shouldTuple.getArity(); ++i) {
            Object should = shouldTuple.getField(i);
            Object is = isTuple.getField(i);
            if (should.getClass().isArray()) {
                if (should instanceof boolean[]) {
                    Assert.assertTrue((String)message, (boolean)Arrays.equals((boolean[])should, (boolean[])is));
                    continue;
                }
                if (should instanceof byte[]) {
                    Assert.assertArrayEquals((String)message, (byte[])((byte[])should), (byte[])((byte[])is));
                    continue;
                }
                if (should instanceof short[]) {
                    Assert.assertArrayEquals((String)message, (short[])((short[])should), (short[])((short[])is));
                    continue;
                }
                if (should instanceof int[]) {
                    Assert.assertArrayEquals((String)message, (int[])((int[])should), (int[])((int[])is));
                    continue;
                }
                if (should instanceof long[]) {
                    Assert.assertArrayEquals((String)message, (long[])((long[])should), (long[])((long[])is));
                    continue;
                }
                if (should instanceof float[]) {
                    Assert.assertArrayEquals((String)message, (float[])((float[])should), (float[])((float[])is), (float)0.0f);
                    continue;
                }
                if (should instanceof double[]) {
                    Assert.assertArrayEquals((String)message, (double[])((double[])should), (double[])((double[])is), (double)0.0);
                    continue;
                }
                if (should instanceof char[]) {
                    Assert.assertArrayEquals((String)message, (char[])((char[])should), (char[])((char[])is));
                    continue;
                }
                Assert.assertArrayEquals((String)message, (Object[])((Object[])should), (Object[])((Object[])is));
                continue;
            }
            Assert.assertEquals((String)message, (Object)should, (Object)is);
        }
    }
}

