/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.junit.Assert;
import org.junit.Test;

public class PojoSerializerTest
extends SerializerTestBase<TestUserClass> {
    private TypeInformation<TestUserClass> type = TypeExtractor.getForClass(TestUserClass.class);

    protected TypeSerializer<TestUserClass> createSerializer() {
        TypeSerializer serializer = this.type.createSerializer();
        assert (serializer instanceof PojoSerializer);
        return serializer;
    }

    protected int getLength() {
        return -1;
    }

    protected Class<TestUserClass> getTypeClass() {
        return TestUserClass.class;
    }

    protected TestUserClass[] getTestData() {
        Random rnd = new Random(874597969123412341L);
        return new TestUserClass[]{new TestUserClass(rnd.nextInt(), "foo", rnd.nextDouble(), new int[]{1, 2, 3}, new NestedTestUserClass(rnd.nextInt(), "foo@boo", rnd.nextDouble(), new int[]{10, 11, 12})), new TestUserClass(rnd.nextInt(), "bar", rnd.nextDouble(), new int[]{4, 5, 6}, new NestedTestUserClass(rnd.nextInt(), "bar@bas", rnd.nextDouble(), new int[]{20, 21, 22})), new TestUserClass(rnd.nextInt(), null, rnd.nextDouble(), null, null)};
    }

    @Test
    public void testTuplePojoTestEquality() {
        PojoTypeInfo pType = (PojoTypeInfo)this.type;
        ArrayList result = new ArrayList();
        pType.getKey("nestedClass.dumm2", 0, result);
        int[] fields = new int[]{((CompositeType.FlatFieldDescriptor)result.get(0)).getPosition()};
        TypeComparator pojoComp = pType.createComparator(fields, new boolean[]{true}, 0);
        TestUserClass pojoTestRecord = new TestUserClass(0, "abc", 3.0, new int[]{1, 2, 3}, new NestedTestUserClass(1, "haha", 4.0, new int[]{5, 4, 3}));
        int pHash = pojoComp.hash((Object)pojoTestRecord);
        Tuple1 tupleTest = new Tuple1((Object)"haha");
        TupleTypeInfo tType = (TupleTypeInfo)TypeExtractor.getForObject((Object)tupleTest);
        TypeComparator tupleComp = tType.createComparator(new int[]{0}, new boolean[]{true}, 0);
        int tHash = tupleComp.hash((Object)tupleTest);
        Assert.assertTrue((String)"The hashing for tuples and pojos must be the same, so that they are mixable", (pHash == tHash ? 1 : 0) != 0);
        Tuple3 multiTupleTest = new Tuple3((Object)1, (Object)"haha", (Object)4.0);
        TupleTypeInfo multiTupleType = (TupleTypeInfo)TypeExtractor.getForObject((Object)multiTupleTest);
        Keys.ExpressionKeys fieldKey = new Keys.ExpressionKeys(new int[]{1, 0, 2}, (TypeInformation)multiTupleType);
        Keys.ExpressionKeys expressKey = new Keys.ExpressionKeys(new String[]{"nestedClass.dumm2", "nestedClass.dumm1", "nestedClass.dumm3"}, (TypeInformation)pType);
        try {
            Assert.assertTrue((String)"Expecting the keys to be compatible", (boolean)fieldKey.areCompatible((Keys)expressKey));
        }
        catch (Keys.IncompatibleKeysException e) {
            e.printStackTrace();
            Assert.fail((String)("Keys must be compatible: " + e.getMessage()));
        }
        TypeComparator multiPojoComp = pType.createComparator(expressKey.computeLogicalKeyPositions(), new boolean[]{true, true, true}, 0);
        int multiPojoHash = multiPojoComp.hash((Object)pojoTestRecord);
        TypeComparator multiTupleComp = multiTupleType.createComparator(fieldKey.computeLogicalKeyPositions(), new boolean[]{true, true, true}, 0);
        int multiTupleHash = multiTupleComp.hash((Object)multiTupleTest);
        Assert.assertTrue((String)"The hashing for tuples and pojos must be the same, so that they are mixable. Also for those with multiple key fields", (multiPojoHash == multiTupleHash ? 1 : 0) != 0);
    }

    public static class NestedTestUserClass {
        public int dumm1;
        public String dumm2;
        public double dumm3;
        public int[] dumm4;

        public NestedTestUserClass() {
        }

        public NestedTestUserClass(int dumm1, String dumm2, double dumm3, int[] dumm4) {
            this.dumm1 = dumm1;
            this.dumm2 = dumm2;
            this.dumm3 = dumm3;
            this.dumm4 = dumm4;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.dumm1, this.dumm2, this.dumm3, this.dumm4});
        }

        public boolean equals(Object other) {
            if (!(other instanceof NestedTestUserClass)) {
                return false;
            }
            NestedTestUserClass otherTUC = (NestedTestUserClass)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (!this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            if (this.dumm3 != otherTUC.dumm3) {
                return false;
            }
            if (this.dumm4.length != otherTUC.dumm4.length) {
                return false;
            }
            for (int i = 0; i < this.dumm4.length; ++i) {
                if (this.dumm4[i] == otherTUC.dumm4[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class TestUserClass {
        public int dumm1;
        public String dumm2;
        public double dumm3;
        public int[] dumm4;
        public NestedTestUserClass nestedClass;

        public TestUserClass() {
        }

        public TestUserClass(int dumm1, String dumm2, double dumm3, int[] dumm4, NestedTestUserClass nestedClass) {
            this.dumm1 = dumm1;
            this.dumm2 = dumm2;
            this.dumm3 = dumm3;
            this.dumm4 = dumm4;
            this.nestedClass = nestedClass;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.dumm1, this.dumm2, this.dumm3, this.dumm4, this.nestedClass});
        }

        public boolean equals(Object other) {
            if (!(other instanceof TestUserClass)) {
                return false;
            }
            TestUserClass otherTUC = (TestUserClass)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (this.dumm2 == null && otherTUC.dumm2 != null || this.dumm2 != null && !this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            if (this.dumm3 != otherTUC.dumm3) {
                return false;
            }
            if (this.dumm4 != null && otherTUC.dumm4 == null || this.dumm4 == null && otherTUC.dumm4 != null || this.dumm4 != null && otherTUC.dumm4 != null && this.dumm4.length != otherTUC.dumm4.length) {
                return false;
            }
            if (this.dumm4 != null && otherTUC.dumm4 != null) {
                for (int i = 0; i < this.dumm4.length; ++i) {
                    if (this.dumm4[i] == otherTUC.dumm4[i]) continue;
                    return false;
                }
            }
            return (this.nestedClass != null || otherTUC.nestedClass == null) && (this.nestedClass == null || this.nestedClass.equals(otherTUC.nestedClass));
        }
    }
}

