/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.apache.flink.api.java.typeutils.runtime.KryoSerializer;
import org.apache.flink.api.java.typeutils.runtime.TestDataOutputSerializer;
import org.apache.flink.api.java.typeutils.runtime.TestInputView;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.junit.Assert;
import org.junit.Test;

public class KryoGenericTypeSerializerTest
extends AbstractGenericTypeSerializerTest {
    @Test
    public void testJavaList() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        this.fillCollection(a);
        this.runTests(a);
    }

    @Test
    public void testJavaSet() {
        HashSet<Integer> b = new HashSet<Integer>();
        this.fillCollection(b);
        this.runTests(b);
    }

    @Test
    public void testJavaDequeue() {
        LinkedList<Integer> c = new LinkedList<Integer>();
        this.fillCollection(c);
        this.runTests(c);
    }

    private void fillCollection(Collection<Integer> coll) {
        coll.add(42);
        coll.add(1337);
        coll.add(49);
        coll.add(1);
    }

    @Override
    protected <T> TypeSerializer<T> createSerializer(Class<T> type) {
        return new KryoSerializer(type);
    }

    @Test
    public void testForwardEOFExceptionWhileSerializing() {
        try {
            char[] charData = new char[40000];
            Random rnd = new Random();
            for (int i = 0; i < charData.length; ++i) {
                charData[i] = (char)rnd.nextInt(10000);
            }
            String str = new String(charData);
            TestDataOutputSerializer target = new TestDataOutputSerializer(10000, 30000);
            KryoSerializer serializer = new KryoSerializer(String.class);
            try {
                serializer.serialize((Object)str, (DataOutputView)target);
                Assert.fail((String)"should throw a java.io.EOFException");
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                Assert.fail((String)("throws wrong exception: should throw a java.io.EOFException, has thrown a " + e.getClass().getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testForwardEOFExceptionWhileDeserializing() {
        try {
            int numElements = 100;
            TestDataOutputSerializer target = new TestDataOutputSerializer(5 * numElements, 5 * numElements);
            KryoSerializer serializer = new KryoSerializer(Integer.class);
            for (int i = 0; i < numElements; ++i) {
                serializer.serialize((Object)i, (DataOutputView)target);
            }
            TestInputView source = new TestInputView(target.copyByteBuffer());
            for (int i = 0; i < numElements; ++i) {
                int value = (Integer)serializer.deserialize((DataInputView)source);
                Assert.assertEquals((long)i, (long)value);
            }
            try {
                serializer.deserialize((DataInputView)source);
                Assert.fail((String)"should throw a java.io.EOFException");
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                Assert.fail((String)("throws wrong exception: should throw a java.io.EOFException, has thrown a " + e.getClass().getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

