/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.GenericTypeComparator;
import org.junit.Test;

public abstract class AbstractGenericTypeComparatorTest {
    @Test
    public void testString() {
        this.runTests("", "Lorem Ipsum Dolor Omit Longer", "aaaa", "abcd", "abce", "abdd", "accd", "bbcd");
    }

    @Test
    public void testSimpleTypesObjects() {
        this.runTests(new SimpleTypes(0, 1L, 2, "", 3, 4.0), new SimpleTypes(1, 1L, 2, "", 3, 4.0), new SimpleTypes(1, 2L, 2, "", 3, 4.0), new SimpleTypes(1, 2L, 3, "", 3, 4.0), new SimpleTypes(1, 2L, 3, "a", 3, 4.0), new SimpleTypes(1, 2L, 3, "b", 3, 4.0), new SimpleTypes(1, 2L, 3, "b", 4, 4.0), new SimpleTypes(1, 2L, 3, "b", 4, 6.0));
    }

    @Test
    public void testCompositeObject() {
        ComplexNestedObject1 o1 = new ComplexNestedObject1(-1100.0, new String[0]);
        ComplexNestedObject1 o2 = new ComplexNestedObject1(0.0, new String[0]);
        ComplexNestedObject1 o3 = new ComplexNestedObject1(44.0, new String[0]);
        ComplexNestedObject1 o4 = new ComplexNestedObject1(76923.0, "A");
        ComplexNestedObject1 o5 = new ComplexNestedObject1(5626435.0, "A somewhat random collection");
        this.runTests(o1, o2, o3, o4, o5);
    }

    @Test
    public void testBeanStyleObjects() {
        Book b111 = new Book(-1L, "A Low level interfaces", 12L);
        Book b122 = new Book(-1L, "Low level interfaces", 12L);
        Book b123 = new Book(-1L, "Low level interfaces", 12648430L);
        Book b2 = new Book(0L, "Debugging byte streams", 1337L);
        Book b3 = new Book(976243875L, "The Serialization Odysse", 42L);
        this.runTests(b111, b122, b123, b2, b3);
        BookAuthor b1 = new BookAuthor(976243875L, new ArrayList<String>(), "Arno Nym");
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        BookAuthor b22 = new BookAuthor(976243875L, list, "The Saurus");
        this.runTests(b1, b22);
    }

    private <T> void runTests(T ... sortedTestData) {
        ComparatorTestInstance<T> testBase = new ComparatorTestInstance<T>(sortedTestData);
        testBase.testAll();
    }

    protected abstract <T> TypeSerializer<T> createSerializer(Class<T> var1);

    public static class BookAuthor
    implements Comparable<BookAuthor> {
        private long authorId;
        private List<String> bookTitles;
        private String authorName;

        public BookAuthor() {
        }

        public BookAuthor(long authorId, List<String> bookTitles, String authorName) {
            this.authorId = authorId;
            this.bookTitles = bookTitles;
            this.authorName = authorName;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == BookAuthor.class) {
                BookAuthor other = (BookAuthor)obj;
                return other.authorName.equals(this.authorName) && other.authorId == this.authorId && other.bookTitles.equals(this.bookTitles);
            }
            return false;
        }

        @Override
        public int compareTo(BookAuthor o) {
            int oSize;
            int cmp;
            int n = this.authorId < o.authorId ? -1 : (cmp = this.authorId == o.authorId ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            int size = this.bookTitles.size();
            int n2 = size < (oSize = o.bookTitles.size()) ? -1 : (cmp = size == oSize ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < size; ++i) {
                cmp = this.bookTitles.get(i).compareTo(o.bookTitles.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return this.authorName.compareTo(o.authorName);
        }
    }

    public static class Book
    implements Comparable<Book> {
        private long bookId;
        private String title;
        private long authorId;

        public Book() {
        }

        public Book(long bookId, String title, long authorId) {
            this.bookId = bookId;
            this.title = title;
            this.authorId = authorId;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == Book.class) {
                Book other = (Book)obj;
                return other.bookId == this.bookId && other.authorId == this.authorId && this.title.equals(other.title);
            }
            return false;
        }

        @Override
        public int compareTo(Book o) {
            int cmp;
            int n = this.bookId < o.bookId ? -1 : (cmp = this.bookId == o.bookId ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.title.compareTo(o.title);
            if (cmp != 0) {
                return cmp;
            }
            return this.authorId < o.authorId ? -1 : (this.authorId == o.authorId ? 0 : 1);
        }
    }

    public static class ComplexNestedObject1
    implements Comparable<ComplexNestedObject1> {
        private double doubleValue;
        private List<String> stringList;

        public ComplexNestedObject1() {
        }

        public ComplexNestedObject1(double value, String ... listElements) {
            this.doubleValue = value;
            this.stringList = new ArrayList<String>();
            for (String str : listElements) {
                this.stringList.add(str);
            }
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == ComplexNestedObject1.class) {
                ComplexNestedObject1 other = (ComplexNestedObject1)obj;
                return other.doubleValue == this.doubleValue && this.stringList.equals(other.stringList);
            }
            return false;
        }

        @Override
        public int compareTo(ComplexNestedObject1 o) {
            int otherSize;
            int cmp;
            int n = this.doubleValue < o.doubleValue ? -1 : (cmp = this.doubleValue == o.doubleValue ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            int size = this.stringList.size();
            int n2 = size < (otherSize = o.stringList.size()) ? -1 : (cmp = size == otherSize ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < size; ++i) {
                cmp = this.stringList.get(i).compareTo(o.stringList.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    public static final class SimpleTypes
    implements Comparable<SimpleTypes> {
        private final int iVal;
        private final long lVal;
        private final byte bVal;
        private final String sVal;
        private final short rVal;
        private final double dVal;

        public SimpleTypes() {
            this(0, 0L, 0, "", 0, 0.0);
        }

        public SimpleTypes(int iVal, long lVal, byte bVal, String sVal, short rVal, double dVal) {
            this.iVal = iVal;
            this.lVal = lVal;
            this.bVal = bVal;
            this.sVal = sVal;
            this.rVal = rVal;
            this.dVal = dVal;
        }

        public String toString() {
            return String.format("(%d, %d, %d, %s, %d, %f)", this.iVal, this.lVal, this.bVal, this.sVal, this.rVal, this.dVal);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == SimpleTypes.class) {
                SimpleTypes other = (SimpleTypes)obj;
                return other.iVal == this.iVal && other.lVal == this.lVal && other.bVal == this.bVal && other.sVal.equals(this.sVal) && other.rVal == this.rVal && other.dVal == this.dVal;
            }
            return false;
        }

        @Override
        public int compareTo(SimpleTypes o) {
            int cmp;
            int n = this.iVal < o.iVal ? -1 : (cmp = this.iVal == o.iVal ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            int n2 = this.lVal < o.lVal ? -1 : (cmp = this.lVal == o.lVal ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            int n3 = this.bVal < o.bVal ? -1 : (cmp = this.bVal == o.bVal ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.sVal.compareTo(o.sVal);
            if (cmp != 0) {
                return cmp;
            }
            int n4 = this.rVal < o.rVal ? -1 : (cmp = this.rVal == o.rVal ? 0 : 1);
            if (cmp != 0) {
                return cmp;
            }
            return this.dVal < o.dVal ? -1 : (this.dVal == o.dVal ? 0 : 1);
        }
    }

    private class ComparatorTestInstance<T>
    extends ComparatorTestBase<T> {
        private final T[] testData;
        private final Class<T> type;

        public ComparatorTestInstance(T[] testData) {
            if (testData == null || testData.length == 0) {
                throw new IllegalArgumentException();
            }
            this.testData = testData;
            this.type = testData[0].getClass();
        }

        protected TypeComparator<T> createComparator(boolean ascending) {
            return new GenericTypeComparator(ascending, AbstractGenericTypeComparatorTest.this.createSerializer(this.type), this.type);
        }

        protected TypeSerializer<T> createSerializer() {
            return AbstractGenericTypeComparatorTest.this.createSerializer(this.type);
        }

        protected T[] getSortedTestData() {
            return this.testData;
        }

        public void testAll() {
            this.testDuplicate();
            this.testEquality();
            this.testEqualityWithReference();
            this.testInequality();
            this.testInequalityWithReference();
            this.testNormalizedKeysEqualsFullLength();
            this.testNormalizedKeysEqualsHalfLength();
            this.testNormalizedKeysGreatSmallFullLength();
            this.testNormalizedKeysGreatSmallAscDescHalfLength();
            this.testNormalizedKeyReadWriter();
        }
    }
}

