/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.type.extractor;

import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParserTest;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class PojoTypeExtractionTest {
    @Test(expected=RuntimeException.class)
    public void testDuplicateFieldException() {
        TypeExtractor.createTypeInfo(HasDuplicateField.class);
    }

    @Test
    public void testPojoWithGenericFields() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenericFields.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
    }

    @Test
    public void testIncorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(IncorrectPojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof GenericTypeInfo));
        typeForClass = TypeExtractor.createTypeInfo(WrongCtorPojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof GenericTypeInfo));
    }

    @Test
    public void testCorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(BeanStylePojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        typeForClass = TypeExtractor.createTypeInfo(TypedPojoGetterSetterCheck.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
    }

    @Test
    public void testPojoWC() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(WC.class);
        this.checkWCPojoAsserts(typeForClass);
        WC t = new WC();
        t.complex = new ComplexNestedClass();
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)t);
        this.checkWCPojoAsserts(typeForObject);
    }

    private void checkWCPojoAsserts(TypeInformation<?> typeInfo) {
        int pos;
        Assert.assertFalse((boolean)typeInfo.isBasicType());
        Assert.assertFalse((boolean)typeInfo.isTupleType());
        Assert.assertEquals((long)10L, (long)typeInfo.getTotalFields());
        Assert.assertTrue((boolean)(typeInfo instanceof PojoTypeInfo));
        PojoTypeInfo pojoType = (PojoTypeInfo)typeInfo;
        ArrayList ffd = new ArrayList();
        String[] fields = new String[]{"count", "complex.date", "complex.hadoopCitizen", "complex.collection", "complex.nothing", "complex.someFloat", "complex.someNumber", "complex.word.f0", "complex.word.f1", "complex.word.f2"};
        int[] positions = new int[]{9, 1, 2, 0, 3, 4, 5, 6, 7, 8};
        Assert.assertEquals((long)fields.length, (long)positions.length);
        for (int i = 0; i < fields.length; ++i) {
            pojoType.getKey(fields[i], 0, ffd);
            Assert.assertEquals((String)"Too many keys returned", (long)1L, (long)ffd.size());
            Assert.assertEquals((String)("position of field " + fields[i] + " wrong"), (long)positions[i], (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
            ffd.clear();
        }
        pojoType.getKey("complex.word.*", 0, ffd);
        Assert.assertEquals((long)3L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assert.assertTrue((pos <= 8 ? 1 : 0) != 0);
            Assert.assertTrue((6 <= pos ? 1 : 0) != 0);
            if (pos == 6) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 7) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos != 8) continue;
            Assert.assertEquals(String.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        pojoType.getKey("complex.word._", 0, ffd);
        Assert.assertEquals((long)3L, (long)ffd.size());
        ffd.clear();
        pojoType.getKey("complex.*", 0, ffd);
        Assert.assertEquals((long)9L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assert.assertTrue((ffdE.getPosition() <= 8 ? 1 : 0) != 0);
            Assert.assertTrue((0 <= ffdE.getPosition() ? 1 : 0) != 0);
            if (pos == 0) {
                Assert.assertEquals(List.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 1) {
                Assert.assertEquals(Date.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 2) {
                Assert.assertEquals(TypeInfoParserTest.MyWritable.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 3) {
                Assert.assertEquals(Object.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 4) {
                Assert.assertEquals(Float.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 5) {
                Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 6) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 7) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 8) {
                Assert.assertEquals(String.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos != 9) continue;
            Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        pojoType.getKey("*", 0, ffd);
        Assert.assertEquals((long)10L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            Assert.assertTrue((ffdE.getPosition() <= 9 ? 1 : 0) != 0);
            Assert.assertTrue((0 <= ffdE.getPosition() ? 1 : 0) != 0);
            if (ffdE.getPosition() != 9) continue;
            Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        TypeInformation typeComplexNested = pojoType.getTypeAt(0);
        Assert.assertTrue((boolean)(typeComplexNested instanceof PojoTypeInfo));
        Assert.assertEquals((long)7L, (long)typeComplexNested.getArity());
        Assert.assertEquals((long)9L, (long)typeComplexNested.getTotalFields());
        PojoTypeInfo pojoTypeComplexNested = (PojoTypeInfo)typeComplexNested;
        boolean dateSeen = false;
        boolean intSeen = false;
        boolean floatSeen = false;
        boolean tupleSeen = false;
        boolean objectSeen = false;
        boolean writableSeen = false;
        boolean collectionSeen = false;
        for (int i = 0; i < pojoTypeComplexNested.getArity(); ++i) {
            PojoField field = pojoTypeComplexNested.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("date")) {
                if (dateSeen) {
                    Assert.fail((String)"already seen");
                }
                dateSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.DATE_TYPE_INFO, (Object)field.type);
                Assert.assertEquals(Date.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("someNumber")) {
                if (intSeen) {
                    Assert.fail((String)"already seen");
                }
                intSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                Assert.assertEquals(Integer.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("someFloat")) {
                if (floatSeen) {
                    Assert.fail((String)"already seen");
                }
                floatSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)field.type);
                Assert.assertEquals(Float.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("word")) {
                if (tupleSeen) {
                    Assert.fail((String)"already seen");
                }
                tupleSeen = true;
                Assert.assertTrue((boolean)(field.type instanceof TupleTypeInfo));
                Assert.assertEquals(Tuple3.class, (Object)field.type.getTypeClass());
                TupleTypeInfo tupleTypeFromComplexNested = (TupleTypeInfo)field.type;
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(0));
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(1));
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(2));
                continue;
            }
            if (name.equals("nothing")) {
                if (objectSeen) {
                    Assert.fail((String)"already seen");
                }
                objectSeen = true;
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.type);
                Assert.assertEquals(Object.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("hadoopCitizen")) {
                if (writableSeen) {
                    Assert.fail((String)"already seen");
                }
                writableSeen = true;
                Assert.assertEquals((Object)new WritableTypeInfo(TypeInfoParserTest.MyWritable.class), (Object)field.type);
                Assert.assertEquals(TypeInfoParserTest.MyWritable.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("collection")) {
                if (collectionSeen) {
                    Assert.fail((String)"already seen");
                }
                collectionSeen = true;
                Assert.assertEquals((Object)new GenericTypeInfo(List.class), (Object)field.type);
                continue;
            }
            Assert.fail((String)("field " + field + " is not expected"));
        }
        Assert.assertTrue((String)"Field was not present", (boolean)dateSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)intSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)floatSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)tupleSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)objectSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)writableSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)collectionSeen);
        TypeInformation typeAtOne = pojoType.getTypeAt(1);
        Assert.assertTrue((boolean)(typeAtOne instanceof BasicTypeInfo));
        Assert.assertEquals((Object)typeInfo.getTypeClass(), WC.class);
        Assert.assertEquals((long)typeInfo.getArity(), (long)2L);
    }

    @Test
    public void testPojoAllPublic() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(AllPublic.class);
        this.checkAllPublicAsserts(typeForClass);
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)new AllPublic());
        this.checkAllPublicAsserts(typeForObject);
    }

    private void checkAllPublicAsserts(TypeInformation<?> typeInformation) {
        Assert.assertTrue((boolean)(typeInformation instanceof PojoTypeInfo));
        Assert.assertEquals((long)10L, (long)typeInformation.getArity());
        Assert.assertEquals((long)12L, (long)typeInformation.getTotalFields());
        boolean arrayListSeen = false;
        boolean multisetSeen = false;
        boolean strArraySeen = false;
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("somethingFancy")) {
                if (arrayListSeen) {
                    Assert.fail((String)"already seen");
                }
                arrayListSeen = true;
                Assert.assertTrue((boolean)(field.type instanceof GenericTypeInfo));
                Assert.assertEquals(ArrayList.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("fancyIds")) {
                if (multisetSeen) {
                    Assert.fail((String)"already seen");
                }
                multisetSeen = true;
                Assert.assertTrue((boolean)(field.type instanceof GenericTypeInfo));
                Assert.assertEquals(HashMultiset.class, (Object)field.type.getTypeClass());
                continue;
            }
            if (name.equals("fancyArray")) {
                if (strArraySeen) {
                    Assert.fail((String)"already seen");
                }
                strArraySeen = true;
                Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)field.type);
                Assert.assertEquals(String[].class, (Object)field.type.getTypeClass());
                continue;
            }
            if (Arrays.asList("date", "someNumber", "someFloat", "word", "nothing", "hadoopCitizen", "collection").contains(name)) continue;
            Assert.fail((String)("field " + field + " is not expected"));
        }
        Assert.assertTrue((String)"Field was not present", (boolean)arrayListSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)multisetSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)strArraySeen);
    }

    @Test
    public void testPojoExtendingTuple() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(FromTuple.class);
        this.checkFromTuplePojo(typeForClass);
        FromTuple ft = new FromTuple();
        ft.f0 = "";
        ft.f1 = "";
        ft.f2 = 0L;
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)((Object)ft));
        this.checkFromTuplePojo(typeForObject);
    }

    private void checkFromTuplePojo(TypeInformation<?> typeInformation) {
        Assert.assertTrue((boolean)(typeInformation instanceof PojoTypeInfo));
        Assert.assertEquals((long)4L, (long)typeInformation.getTotalFields());
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("special")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                continue;
            }
            if (name.equals("f0") || name.equals("f1")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.type);
                continue;
            }
            if (name.equals("f2")) {
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)field.type);
                continue;
            }
            Assert.fail((String)"unexpected field");
        }
    }

    @Test
    public void testPojoWithGenerics() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ParentSettingGenerics.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("field1")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)field.type);
                continue;
            }
            if (name.equals("field3")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.type);
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testPojoWithGenericsSomeFieldsGeneric() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenerics.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("field1")) {
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.type);
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.type);
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testPojoWithComplexHierarchy() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ComplexHierarchyTop.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.field.getName();
            if (name.equals("field1")) {
                Assert.assertTrue((boolean)(field.type instanceof PojoTypeInfo));
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertTrue((boolean)(field.type instanceof TupleTypeInfo));
                Assert.assertTrue((boolean)((TupleTypeInfo)field.type).getTypeAt(0).equals(BasicTypeInfo.STRING_TYPE_INFO));
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.type);
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testGetterSetterWithVertex() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource set = env.fromElements((Object[])new VertexTyped[]{new VertexTyped(0L, 3.0), new VertexTyped(1L, 1.0)});
    }

    public static class VertexTyped
    extends Vertex<Long, Double> {
        public VertexTyped(Long l, Double d) {
            super(l, d);
        }

        public VertexTyped() {
        }
    }

    public static class Vertex<K, V> {
        private K key1;
        private K key2;
        private V value;

        public Vertex() {
        }

        public Vertex(K key, V value) {
            this.key1 = key;
            this.key2 = key;
            this.value = value;
        }

        public Vertex(K key1, K key2, V value) {
            this.key1 = key1;
            this.key2 = key2;
            this.value = value;
        }

        public void setKey1(K key1) {
            this.key1 = key1;
        }

        public void setKey2(K key2) {
            this.key2 = key2;
        }

        public K getKey1() {
            return this.key1;
        }

        public K getKey2() {
            return this.key2;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }

    public static class GenericPojoGetterSetterCheck<T> {
        T packageProtected;

        public T getPackageProtected() {
            return this.packageProtected;
        }
    }

    public static class TypedPojoGetterSetterCheck
    extends GenericPojoGetterSetterCheck<String> {
        public void setPackageProtected(String in) {
            this.packageProtected = in;
        }
    }

    public static class PojoWithGenericFields {
        private Collection<String> users;
        private boolean favorited;

        public boolean isFavorited() {
            return this.favorited;
        }

        public void setFavorited(boolean favorited) {
            this.favorited = favorited;
        }

        public Collection<String> getUsers() {
            return this.users;
        }

        public void setUsers(Collection<String> users) {
            this.users = users;
        }
    }

    public static class WrongCtorPojo {
        public int a;

        public WrongCtorPojo(int a) {
            this.a = a;
        }
    }

    public static class BeanStylePojo {
        public String abc;
        private int field;

        public int getField() {
            return this.field;
        }

        public void setField(int f) {
            this.field = f;
        }
    }

    public static class IncorrectPojo {
        private int isPrivate;

        public int getIsPrivate() {
            return this.isPrivate;
        }
    }

    public static class FromTuple
    extends Tuple3<String, String, Long> {
        private static final long serialVersionUID = 1L;
        public int special;
    }

    public static class ComplexHierarchy<T>
    extends PojoWithGenerics<FromTuple, T> {
    }

    public static class ComplexHierarchyTop
    extends ComplexHierarchy<Tuple1<String>> {
    }

    public static class PojoWithGenerics<T1, T2> {
        public int key;
        public T1 field1;
        public T2 field2;
    }

    public static class ParentSettingGenerics
    extends PojoWithGenerics<Integer, Long> {
        public String field3;
    }

    public static class AllPublic
    extends ComplexNestedClass {
        public ArrayList<String> somethingFancy;
        public HashMultiset<Integer> fancyIds;
        public String[] fancyArray;
    }

    public static class ComplexNestedClass {
        public static int ignoreStaticField;
        public transient int ignoreTransientField;
        public Date date;
        public Integer someNumber;
        public float someFloat;
        public Tuple3<Long, Long, String> word;
        public Object nothing;
        public TypeInfoParserTest.MyWritable hadoopCitizen;
        public List<String> collection;
    }

    public static class WC {
        public ComplexNestedClass complex;
        private int count;

        public int getCount() {
            return this.count;
        }

        public void setCount(int c) {
            this.count = c;
        }
    }

    public static class HasDuplicateField
    extends WC {
        private int count;
    }
}

